/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Iterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionValueModelWrapper<E>
extends AbstractModel {
    protected final CollectionValueModel<? extends E> collectionHolder;
    protected final CollectionChangeListener collectionChangeListener;

    protected CollectionValueModelWrapper(CollectionValueModel<? extends E> collectionHolder) {
        this.collectionHolder = collectionHolder;
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, CollectionChangeListener.class, "values");
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent event) {
                CollectionValueModelWrapper.this.itemsAdded(event);
            }

            public void itemsRemoved(CollectionChangeEvent event) {
                CollectionValueModelWrapper.this.itemsRemoved(event);
            }

            public void collectionCleared(CollectionChangeEvent event) {
                CollectionValueModelWrapper.this.collectionCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                CollectionValueModelWrapper.this.collectionChanged(event);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    @Override
    public synchronized void addCollectionChangeListener(CollectionChangeListener listener) {
        if (this.hasNoCollectionChangeListeners("values")) {
            this.engageModel();
        }
        super.addCollectionChangeListener(listener);
    }

    @Override
    public synchronized void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        if (collectionName == "values" && this.hasNoCollectionChangeListeners("values")) {
            this.engageModel();
        }
        super.addCollectionChangeListener(collectionName, listener);
    }

    @Override
    public synchronized void removeCollectionChangeListener(CollectionChangeListener listener) {
        super.removeCollectionChangeListener(listener);
        if (this.hasNoCollectionChangeListeners("values")) {
            this.disengageModel();
        }
    }

    @Override
    public synchronized void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        super.removeCollectionChangeListener(collectionName, listener);
        if (collectionName == "values" && this.hasNoCollectionChangeListeners("values")) {
            this.disengageModel();
        }
    }

    protected void engageModel() {
        this.collectionHolder.addCollectionChangeListener("values", this.collectionChangeListener);
    }

    protected void disengageModel() {
        this.collectionHolder.removeCollectionChangeListener("values", this.collectionChangeListener);
    }

    protected Iterator<E> items(CollectionChangeEvent event) {
        return event.items();
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.collectionHolder);
    }

    protected abstract void itemsAdded(CollectionChangeEvent var1);

    protected abstract void itemsRemoved(CollectionChangeEvent var1);

    protected abstract void collectionCleared(CollectionChangeEvent var1);

    protected abstract void collectionChanged(CollectionChangeEvent var1);
}

