/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import org.eclipse.jpt.utility.internal.model.value.ValueAspectAdapter;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.model.listener.TreeChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueTreeAdapter<T extends Model>
extends ValueAspectAdapter<T> {
    protected final String[] treeNames;
    protected final TreeChangeListener valueTreeListener;

    public ValueTreeAdapter(WritablePropertyValueModel<T> valueHolder, String ... treeNames) {
        super(valueHolder);
        this.treeNames = treeNames;
        this.valueTreeListener = this.buildValueTreeListener();
    }

    protected TreeChangeListener buildValueTreeListener() {
        return new TreeChangeListener(){

            public void nodeAdded(TreeChangeEvent event) {
                ValueTreeAdapter.this.valueAspectChanged();
            }

            public void nodeRemoved(TreeChangeEvent event) {
                ValueTreeAdapter.this.valueAspectChanged();
            }

            public void treeCleared(TreeChangeEvent event) {
                ValueTreeAdapter.this.valueAspectChanged();
            }

            public void treeChanged(TreeChangeEvent event) {
                ValueTreeAdapter.this.valueAspectChanged();
            }

            public String toString() {
                return "value tree listener: " + Arrays.asList(ValueTreeAdapter.this.treeNames);
            }
        };
    }

    @Override
    protected void engageValue_() {
        String[] stringArray = this.treeNames;
        int n = this.treeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String treeName = stringArray[n2];
            ((Model)this.value).addTreeChangeListener(treeName, this.valueTreeListener);
            ++n2;
        }
    }

    @Override
    protected void disengageValue_() {
        String[] stringArray = this.treeNames;
        int n = this.treeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String treeName = stringArray[n2];
            ((Model)this.value).removeTreeChangeListener(treeName, this.valueTreeListener);
            ++n2;
        }
    }
}

