/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.launcher;

import com.ibm.icu.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.debug.internal.ui.launcher.util.WorkspaceClassPathFinder;
import org.eclipse.birt.report.designer.ui.editors.ReportEditorProxy;
import org.eclipse.birt.report.viewer.utilities.IWorkspaceClasspathFinder;
import org.eclipse.birt.report.viewer.utilities.WorkspaceClasspathManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.IDE;

public class DebugStartupClass
implements IStartup {
    private static final String WORKSPACE_CLASSPATH_KEY = "workspace.projectclasspath";
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.debug.internal.ui.launcher.DebugStartupClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public void earlyStartup() {
        WorkspaceClassPathFinder finder = new WorkspaceClassPathFinder();
        WorkspaceClasspathManager.registerClassPathFinder((IWorkspaceClasspathFinder)finder);
        String projectClassPaths = finder.getClassPath();
        if (projectClassPaths == null) {
            projectClassPaths = "";
        }
        System.setProperty(WORKSPACE_CLASSPATH_KEY, projectClassPaths);
        String value = System.getProperty("user.projectname");
        if (value == null || value.length() == 0) {
            return;
        }
        StringTokenizer token = new StringTokenizer(value, ";");
        while (token.hasMoreTokens()) {
            token.nextToken();
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                int openCount = 0;
                try {
                    String value = System.getProperty("user.openfiles");
                    if (value == null || value.length() == 0) {
                        return;
                    }
                    StringTokenizer token = new StringTokenizer(value, ";");
                    while (token.hasMoreTokens()) {
                        String str = token.nextToken();
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(str));
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                        IWorkbenchPage page = window.getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                        ++openCount;
                    }
                }
                catch (PartInitException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                if (openCount == 1) {
                    FormEditor editor = DebugStartupClass.getActiveReportEditor();
                    editor.setActivePage("org.eclipse.birt.report.designer.ui.editors.preview.web");
                }
            }
        });
    }

    public static FormEditor getActiveReportEditor() {
        IEditorPart editor;
        IWorkbenchPage pg;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (pg = window.getActivePage()) != null && (editor = pg.getActiveEditor()) != null) {
            if (editor instanceof ReportEditorProxy) {
                IEditorPart part = ((ReportEditorProxy)editor).getEditorPart();
                if (part instanceof FormEditor) {
                    return (FormEditor)part;
                }
            } else if (editor instanceof FormEditor) {
                return (FormEditor)editor;
            }
        }
        return null;
    }
}

