/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.launcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class ScriptLaunchShortcut
implements ILaunchShortcut {
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.debug.internal.ui.script.launcher.ScriptLaunchShortcut");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public void launch(ISelection selection, String mode) {
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput obj = editor.getEditorInput();
        if (!(obj instanceof FileEditorInput)) {
            return;
        }
        FileEditorInput input = (FileEditorInput)obj;
        String fileName = input.getPath().toOSString();
        ILaunchConfiguration config = ScriptLaunchShortcut.findLaunchConfiguration(fileName, ScriptLaunchShortcut.getConfigurationType());
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    public static ILaunchConfigurationType getConfigurationType() {
        return ScriptLaunchShortcut.getLaunchManager().getLaunchConfigurationType("org.eclipse.birt.report.debug.ui.launchConfigurationType.script");
    }

    protected static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public static ILaunchConfiguration findLaunchConfiguration(String fileName, ILaunchConfigurationType configType) {
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute("report.file.name", "").equals(fileName)) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            logger.warning(e.getMessage());
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return ScriptLaunchShortcut.createConfiguration(fileName);
        }
        return (ILaunchConfiguration)candidateConfigs.get(0);
    }

    protected static ILaunchConfiguration createConfiguration(String fileName) {
        String name = "New_configuration";
        name = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name);
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = ScriptLaunchShortcut.getConfigurationType();
            wc = configType.newInstance(null, ScriptLaunchShortcut.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name));
            wc.setAttribute("report.file.name", fileName);
            config = wc.doSave();
        }
        catch (CoreException exception) {
            logger.warning(exception.getMessage());
        }
        return config;
    }
}

