/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.appconfig;

import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.jst.jsf.validation.internal.appconfig.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.appconfig.FacesConfigValidator;
import org.eclipse.jst.jsf.validation.internal.appconfig.Messages;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AppConfigValidator
extends AbstractValidator
implements IValidator {
    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        ValidationResult vr = new ValidationResult();
        if (resource == null || !(resource instanceof IFile)) {
            return vr;
        }
        IReporter reporter = vr.getReporter(monitor);
        this.validateFile((IFile)resource, reporter);
        return vr;
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        IStatus status = Status.OK_STATUS;
        try {
            this.validate(helper, reporter);
        }
        catch (ValidationException e) {
            Logger.logException((Throwable)e);
            status = new Status(4, JSFCorePlugin.getDefault().getPluginID(), 4, e.getLocalizedMessage(), (Throwable)e);
        }
        return status;
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        String[] uris = helper.getURIs();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (uris.length > 0) {
            IFile currentFile = null;
            int i = 0;
            while (i < uris.length && !reporter.isCancelled()) {
                currentFile = wsRoot.getFile((IPath)new Path(uris[i]));
                if (currentFile != null && currentFile.exists()) {
                    this.validateFile(currentFile, reporter);
                }
                ++i;
            }
        }
    }

    private void validateFile(IFile file, IReporter reporter) {
        FacesConfigArtifactEdit facesConfigEdit = null;
        IPath path = JSFAppConfigUtils.getWebContentFolderRelativePath(file);
        if (path == null) {
            reporter.addMessage((IValidator)this, (IMessage)new Message(JSFCorePlugin.getDefault().getBundle().getSymbolicName(), 2, Messages.CONFIG_FILE_NOT_UNDER_WEBCONTENT_FOLDER));
        } else {
            try {
                facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)file.getProject(), (String)path.toString());
                if (facesConfigEdit != null && facesConfigEdit.getFacesConfig() != null) {
                    String version = this.validateVersioning(file, facesConfigEdit, reporter);
                    this.validateModel(file, facesConfigEdit, reporter, version);
                }
            }
            finally {
                if (facesConfigEdit != null) {
                    facesConfigEdit.dispose();
                }
            }
        }
    }

    private String validateVersioning(IFile file, FacesConfigArtifactEdit facesConfigEdit, IReporter reporter) {
        String appConfigFileVersion = this.getAppConfigFileVersion(facesConfigEdit);
        if (appConfigFileVersion != null) {
            String projectVersion = this.getJSFVersion(file.getProject());
            if ("1.1".equals(projectVersion) || "1.0".equals(projectVersion)) {
                if ("1.2".equals(appConfigFileVersion)) {
                    reporter.addMessage((IValidator)this, DiagnosticFactory.create_APP_CONFIG_IS_NEWER_THAN_JSF_VERSION(file));
                }
            } else if ("1.2".equals(projectVersion) && ("1.1".equals(appConfigFileVersion) || "1.0".equals(appConfigFileVersion))) {
                reporter.addMessage((IValidator)this, DiagnosticFactory.create_APP_CONFIG_IS_OLDER_THAN_JSF_VERSION(file, appConfigFileVersion, projectVersion));
            }
        }
        return appConfigFileVersion;
    }

    private String getAppConfigFileVersion(FacesConfigArtifactEdit facesConfigEdit) {
        String appConfigVersion = null;
        IDOMModel domModel = facesConfigEdit.getIDOMModel();
        IDOMDocument document = domModel.getDocument();
        if (document == null) {
            return null;
        }
        DocumentType docType = domModel.getDocument().getDoctype();
        if (docType != null) {
            appConfigVersion = this.extractVersionFromPublicId(docType);
            if (appConfigVersion == null) {
                appConfigVersion = this.extractVersionFromSystemId(docType);
            }
        } else {
            NodeList rootNodes = domModel.getDocument().getChildNodes();
            int i = 0;
            while (i < rootNodes.getLength()) {
                NamedNodeMap map;
                Node versionAttrib;
                Node node = rootNodes.item(i);
                if (node.getNodeType() == 1 && "faces-config".equals(node.getLocalName()) && (versionAttrib = (map = node.getAttributes()).getNamedItem("version")) != null) {
                    appConfigVersion = versionAttrib.getNodeValue();
                    break;
                }
                ++i;
            }
        }
        return appConfigVersion;
    }

    private void validateModel(IFile file, FacesConfigArtifactEdit facesConfigEdit, IReporter reporter, String version) {
        FacesConfigType facesConfigType = facesConfigEdit.getFacesConfig();
        FacesConfigValidator validator = new FacesConfigValidator(version);
        ArrayList messages = new ArrayList();
        validator.validate((EObject)facesConfigType, messages, file);
        for (IMessage message : messages) {
            reporter.addMessage((IValidator)this, message);
        }
    }

    private String getJSFVersion(IProject project) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            Set facets = facetedProject.getProjectFacets();
            for (IProjectFacetVersion facetVersion : facets) {
                if (!"jst.jsf".equals(facetVersion.getProjectFacet().getId())) continue;
                return facetVersion.getVersionString();
            }
        }
        catch (CoreException ce) {
            JSFCorePlugin.log((Exception)((Object)ce), "Problem loading faceted project");
        }
        return null;
    }

    private String extractVersionFromPublicId(DocumentType docType) {
        String classTypeString;
        String[] classTypes;
        Pattern pattern;
        Matcher matcher;
        String publicId = docType.getPublicId();
        if (publicId != null && (matcher = (pattern = Pattern.compile("-\\/\\/(.*)\\/\\/(.*)\\/\\/.*")).matcher(publicId)).matches() && (classTypes = (classTypeString = matcher.group(2)).split("\\s+")).length > 0 && "DTD".equals(classTypes[0])) {
            String appConfigVersion = "1.0";
            if ("1.1".equals(classTypes[classTypes.length - 1])) {
                appConfigVersion = "1.1";
            }
            return appConfigVersion;
        }
        return null;
    }

    private String extractVersionFromSystemId(DocumentType docType) {
        String version;
        Pattern pattern;
        Matcher matcher;
        String systemId = docType.getSystemId();
        if (systemId != null && (matcher = (pattern = Pattern.compile("http:\\/\\/java.sun.com\\/dtd\\/web-facesconfig_(.*)\\.dtd")).matcher(systemId)).matches() && ("1_1".equals(version = matcher.group(1)) || "1_0".equals(version))) {
            return version.replaceAll("_", ".");
        }
        return null;
    }
}

