/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.awt.Color;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.XMLEncodeUtil;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.HyperlinkDef;
import org.eclipse.birt.report.engine.emitter.excel.IExcelWriter;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelContext;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelXmlWriter
implements IExcelWriter {
    private boolean isRTLSheet = false;
    public static final int rightToLeftisTrue = 1;
    private final XMLWriterXLS writer = new XMLWriterXLS();
    private String pageHeader;
    private String pageFooter;
    private int sheetIndex = 1;
    protected static Logger logger = Logger.getLogger(ExcelXmlWriter.class.getName());
    ExcelContext context = null;

    public XMLWriterXLS getWriter() {
        return this.writer;
    }

    public ExcelXmlWriter(OutputStream out, ExcelContext context) {
        this(out, "UTF-8", context);
    }

    public ExcelXmlWriter(OutputStream out) {
        this.writer.open(out, "UTF-8");
    }

    public ExcelXmlWriter(OutputStream out, String encoding, ExcelContext context) {
        this.context = context;
        this.writer.open(out, encoding);
    }

    public ExcelXmlWriter(OutputStream out, boolean isRTLSheet) {
        this.isRTLSheet = isRTLSheet;
        this.writer.open(out, "UTF-8");
    }

    public ExcelXmlWriter(OutputStream out, ExcelContext context, boolean isRTLSheet) {
        this(out, "UTF-8", context);
        this.isRTLSheet = isRTLSheet;
    }

    public ExcelXmlWriter(OutputStream out, String encoding, ExcelContext context, boolean isRTLSheet) {
        this.context = context;
        this.isRTLSheet = isRTLSheet;
        this.writer.open(out, encoding);
    }

    private void writeDocumentProperties(IReportContent reportContent) {
        if (reportContent == null) {
            return;
        }
        ReportDesignHandle reportDesign = reportContent.getDesign().getReportDesign();
        this.writer.openTag("DocumentProperties");
        this.writer.attribute("xmlns", "urn:schemas-microsoft-com:office:office");
        this.writer.openTag("Author");
        this.writer.text(reportDesign.getStringProperty("author"));
        this.writer.closeTag("Author");
        this.writer.openTag("Title");
        this.writer.text(reportContent.getTitle());
        this.writer.closeTag("Title");
        this.writer.openTag("Description");
        this.writer.text(reportDesign.getComments());
        this.writer.closeTag("Description");
        this.writer.openTag("Subject");
        this.writer.text(reportDesign.getSubject());
        this.writer.closeTag("Subject");
        this.writer.closeTag("DocumentProperties");
    }

    private void writeText(int type, Object value, StyleEntry style) {
        String txt = ExcelUtil.format(value, type);
        this.writer.openTag("Data");
        if (type == 1) {
            if (ExcelUtil.isNaN(value) || ExcelUtil.isBigNumber(value) || ExcelUtil.isInfinity(value)) {
                this.writer.attribute("ss:Type", "String");
            } else {
                this.writer.attribute("ss:Type", "Number");
            }
        } else if (type == 0) {
            this.writer.attribute("ss:Type", "DateTime");
        } else {
            this.writer.attribute("ss:Type", "String");
        }
        if (style != null) {
            String textTransform = (String)style.getProperty(26);
            if ("capitalize".equalsIgnoreCase(textTransform)) {
                txt = this.capitalize(txt);
            } else if ("uppercase".equalsIgnoreCase(textTransform)) {
                txt = txt.toUpperCase();
            } else if ("lowercase".equalsIgnoreCase(textTransform)) {
                txt = txt.toLowerCase();
            }
        }
        this.writer.text(txt);
        this.writer.closeTag("Data");
    }

    private String capitalize(String text) {
        boolean capitalizeNextChar = true;
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\n' || c == '\r') {
                capitalizeNextChar = true;
            } else if (capitalizeNextChar) {
                array[i] = Character.toUpperCase(array[i]);
                capitalizeNextChar = false;
            }
            ++i;
        }
        return new String(array);
    }

    @Override
    public void startRow(double rowHeight) {
        this.writer.openTag("Row");
        this.writer.attribute("ss:AutoFitHeight", 0);
        if (rowHeight > 0.0) {
            this.writer.attribute("ss:Height", rowHeight);
        }
    }

    @Override
    public void endRow() {
        this.writer.closeTag("Row");
    }

    private void startCell(int cellIndex, int colspan, int rowspan, int styleId, HyperlinkDef hyperLink, BookmarkDef linkedBookmark) {
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", cellIndex);
        if (styleId > 0) {
            this.writer.attribute("ss:StyleID", styleId);
        }
        if (hyperLink != null) {
            String urlAddress = hyperLink.getUrl();
            if (hyperLink.getType() == 2) {
                if (linkedBookmark != null) {
                    urlAddress = "#" + linkedBookmark.getValidName();
                } else {
                    logger.log(Level.WARNING, "The bookmark: {" + urlAddress + "} is not defined!");
                }
            }
            if (urlAddress != null && urlAddress.length() >= 255) {
                logger.log(Level.WARNING, "The URL: {" + urlAddress + "} is too long!");
                urlAddress = urlAddress.substring(0, 254);
            }
            this.writer.attribute("ss:HRef", urlAddress);
        }
        if (colspan > 0) {
            this.writer.attribute("ss:MergeAcross", colspan);
        }
        if (rowspan > 0) {
            this.writer.attribute("ss:MergeDown", rowspan);
        }
    }

    @Override
    public void outputData(SheetData sheetData, StyleEntry style, int column, int colSpan) {
        int rowSpan = sheetData.getRowSpan();
        int styleId = sheetData.getStyleId();
        int type = sheetData.getDataType();
        if (type == 5) {
            this.outputData(2, "", style, column, colSpan, sheetData.getRowSpan(), sheetData.getStyleId(), null, null);
        } else {
            Data d = (Data)sheetData;
            Object value = d.getValue();
            HyperlinkDef hyperLink = d.getHyperlinkDef();
            BookmarkDef linkedBookmark = d.getLinkedBookmark();
            this.outputData(type, value, style, column, colSpan, rowSpan, styleId, hyperLink, linkedBookmark);
        }
    }

    @Override
    public void outputData(int col, int row, int type, Object value) {
        this.outputData(type, value, null, col, 0, 0, -1, null, null);
    }

    private void outputData(int type, Object value, StyleEntry style, int column, int colSpan, int rowSpan, int styleId, HyperlinkDef hyperLink, BookmarkDef linkedBookmark) {
        this.startCell(column, colSpan, rowSpan, styleId, hyperLink, linkedBookmark);
        this.writeText(type, value, style);
        if (hyperLink != null && hyperLink.getToolTip() != null) {
            this.writeComments(hyperLink);
        }
        this.endCell();
    }

    protected void writeComments(HyperlinkDef linkDef) {
        String toolTip = linkDef.getToolTip();
        this.writer.openTag("Comment");
        this.writer.openTag("ss:Data");
        this.writer.attribute("xmlns", "http://www.w3.org/TR/REC-html40");
        this.writer.openTag("Font");
        this.writer.text(toolTip);
        this.writer.closeTag("Font");
        this.writer.closeTag("ss:Data");
        this.writer.closeTag("Comment");
    }

    private void endCell() {
        this.writer.closeTag("Cell");
    }

    private void writeAlignment(String horizontal, String vertical, String direction, boolean wrapText) {
        this.writer.openTag("Alignment");
        if (this.isValid(horizontal)) {
            this.writer.attribute("ss:Horizontal", horizontal);
        }
        if (this.isValid(vertical)) {
            this.writer.attribute("ss:Vertical", vertical);
        }
        if (this.isValid(direction)) {
            if ("rtl".equals(direction)) {
                this.writer.attribute("ss:ReadingOrder", "RightToLeft");
            } else {
                this.writer.attribute("ss:ReadingOrder", "LeftToRight");
            }
        }
        if (wrapText) {
            this.writer.attribute("ss:WrapText", "1");
        }
        this.writer.closeTag("Alignment");
    }

    private void writeBorder(String position, String lineStyle, String weight, Color color) {
        this.writer.openTag("Border");
        this.writer.attribute("ss:Position", position);
        if (this.isValid(lineStyle)) {
            this.writer.attribute("ss:LineStyle", lineStyle);
        }
        if (this.isValid(weight)) {
            this.writer.attribute("ss:Weight", weight);
        }
        if (color != null) {
            this.writer.attribute("ss:Color", this.toString(color));
        }
        this.writer.closeTag("Border");
    }

    private void writeFont(String fontName, Integer size, Boolean bold, Boolean italic, Boolean strikeThrough, Boolean underline, Color color) {
        this.writer.openTag("Font");
        if (this.isValid(fontName)) {
            this.writer.attribute("ss:FontName", fontName);
        }
        if (size != null) {
            this.writer.attribute("ss:Size", size);
        }
        if (bold != null && bold.booleanValue()) {
            this.writer.attribute("ss:Bold", 1);
        }
        if (italic != null && italic.booleanValue()) {
            this.writer.attribute("ss:Italic", 1);
        }
        if (strikeThrough != null && strikeThrough.booleanValue()) {
            this.writer.attribute("ss:StrikeThrough", 1);
        }
        if (underline != null && underline.booleanValue()) {
            this.writer.attribute("ss:Underline", "Single");
        }
        if (color != null) {
            this.writer.attribute("ss:Color", this.toString(color));
        }
        this.writer.closeTag("Font");
    }

    private void writeBackGroudColor(StyleEntry style) {
        Color bgColor = (Color)style.getProperty(6);
        if (bgColor != null) {
            this.writer.openTag("Interior");
            this.writer.attribute("ss:Color", this.toString(bgColor));
            this.writer.attribute("ss:Pattern", "Solid");
            this.writer.closeTag("Interior");
        }
    }

    private boolean isValid(String value) {
        return !StyleEntry.isNull(value);
    }

    private void declareStyle(StyleEntry style, int id) {
        boolean wrapText = this.context.getWrappingText();
        String whiteSpace = (String)style.getProperty(28);
        if ("nowrap".equals(whiteSpace)) {
            wrapText = false;
        }
        this.writer.openTag("Style");
        this.writer.attribute("ss:ID", id);
        if (style.getName() == "Hyperlink") {
            this.writer.attribute("ss:Parent", "HyperlinkId");
        }
        if (id >= 20) {
            String direction = (String)style.getProperty(27);
            String horizontalAlign = (String)style.getProperty(8);
            String verticalAlign = (String)style.getProperty(9);
            this.writeAlignment(horizontalAlign, verticalAlign, direction, wrapText);
            this.writer.openTag("Borders");
            Color bottomColor = (Color)style.getProperty(10);
            String bottomLineStyle = (String)style.getProperty(11);
            String bottomWeight = (String)style.getProperty(12);
            this.writeBorder("Bottom", bottomLineStyle, bottomWeight, bottomColor);
            Color topColor = (Color)style.getProperty(13);
            String topLineStyle = (String)style.getProperty(14);
            String topWeight = (String)style.getProperty(15);
            this.writeBorder("Top", topLineStyle, topWeight, topColor);
            Color leftColor = (Color)style.getProperty(16);
            String leftLineStyle = (String)style.getProperty(17);
            String leftWeight = (String)style.getProperty(18);
            this.writeBorder("Left", leftLineStyle, leftWeight, leftColor);
            Color rightColor = (Color)style.getProperty(19);
            String rightLineStyle = (String)style.getProperty(20);
            String rightWeight = (String)style.getProperty(21);
            this.writeBorder("Right", rightLineStyle, rightWeight, rightColor);
            Color diagonalColor = (Color)style.getProperty(29);
            String diagonalStyle = (String)style.getProperty(30);
            String diagonalWidth = (String)style.getProperty(31);
            this.writeBorder("DiagonalLeft", diagonalStyle, diagonalWidth, diagonalColor);
            this.writer.closeTag("Borders");
            String fontName = (String)style.getProperty(0);
            Integer size = (Integer)style.getProperty(1);
            Boolean fontStyle = (Boolean)style.getProperty(2);
            Boolean fontWeight = (Boolean)style.getProperty(3);
            Boolean strikeThrough = (Boolean)style.getProperty(4);
            Boolean underline = (Boolean)style.getProperty(5);
            Color color = (Color)style.getProperty(7);
            this.writeFont(fontName, size, fontWeight, fontStyle, strikeThrough, underline, color);
            this.writeBackGroudColor(style);
        }
        this.writeDataFormat(style);
        this.writer.closeTag("Style");
    }

    private String toString(Color color) {
        if (color == null) {
            return null;
        }
        return "#" + ExcelXmlWriter.toHexString(color.getRed()) + ExcelXmlWriter.toHexString(color.getGreen()) + ExcelXmlWriter.toHexString(color.getBlue());
    }

    private static String toHexString(int c) {
        String result = Integer.toHexString(c);
        if (result.length() < 2) {
            result = "0" + result;
        }
        return result;
    }

    private void writeDataFormat(StyleEntry style) {
        Integer type = (Integer)style.getProperty(25);
        if (type == null) {
            return;
        }
        if (type == 0 && style.getProperty(22) != null) {
            this.writer.openTag("NumberFormat");
            this.writer.attribute("ss:Format", style.getProperty(22));
            this.writer.closeTag("NumberFormat");
        } else if (type == 1 && style.getProperty(23) != null) {
            this.writer.openTag("NumberFormat");
            String numberStyle = (String)style.getProperty(23);
            this.writer.attribute("ss:Format", numberStyle);
            this.writer.closeTag("NumberFormat");
        }
    }

    private void writeDeclarations() {
        this.writer.startWriter();
        this.writer.println();
        this.writer.println("<?mso-application progid=\"Excel.Sheet\"?>");
        this.writer.openTag("Workbook");
        this.writer.attribute("xmlns", "urn:schemas-microsoft-com:office:spreadsheet");
        this.writer.attribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        this.writer.attribute("xmlns:x", "urn:schemas-microsoft-com:office:excel");
        this.writer.attribute("xmlns:ss", "urn:schemas-microsoft-com:office:spreadsheet");
        this.writer.attribute("xmlns:html", "http://www.w3.org/TR/REC-html40");
    }

    private void declareStyles(Map<StyleEntry, Integer> style2id) {
        this.writer.openTag("Styles");
        this.declareHyperlinkStyle();
        Set<Map.Entry<StyleEntry, Integer>> entrySet = style2id.entrySet();
        for (Map.Entry<StyleEntry, Integer> entry : entrySet) {
            this.declareStyle(entry.getKey(), entry.getValue());
        }
        this.writer.closeTag("Styles");
    }

    private void declareHyperlinkStyle() {
        this.writer.openTag("Style");
        this.writer.attribute("ss:ID", "HyperlinkId");
        this.writer.attribute("ss:Name", "Hyperlink");
        this.writer.openTag("Font");
        this.writer.attribute("ss:Color", "#0000ff");
        this.writer.closeTag("Font");
        this.writer.closeTag("Style");
    }

    private void defineNames(Map.Entry<String, BookmarkDef> bookmarkEntry) {
        BookmarkDef bookmark = bookmarkEntry.getValue();
        String name = bookmark.getValidName();
        String refer = this.getRefer(bookmark.getSheetIndex(), bookmark);
        this.defineName(name, refer);
    }

    private String getRefer(int sheetIndex, BookmarkDef bookmark) {
        StringBuffer sb = new StringBuffer("=Sheet");
        sb.append(sheetIndex);
        sb.append("!R");
        sb.append(bookmark.getRowNo());
        sb.append("C");
        sb.append(bookmark.getColumnNo());
        return sb.toString();
    }

    private void defineName(String name, String refer) {
        this.writer.openTag("NamedRange");
        this.writer.attribute("ss:Name", name);
        this.writer.attribute("ss:RefersTo", refer);
        this.writer.closeTag("NamedRange");
    }

    @Override
    public void startSheet(String name) {
        this.startSheet(name, null);
    }

    public void startSheet(String name, int[] coordinates) {
        this.writer.openTag("Worksheet");
        this.writer.attribute("ss:Name", name);
        if (this.isRTLSheet) {
            this.writer.attribute("ss:RightToLeft", 1);
        }
        this.outputColumns(coordinates);
    }

    public void closeSheet() {
        this.writer.closeTag("Worksheet");
        this.writer.endWriter();
    }

    public void outputColumns(int[] width) {
        this.writer.openTag("ss:Table");
        if (width == null) {
            return;
        }
        int i = 0;
        while (i < width.length) {
            this.writer.openTag("ss:Column");
            this.writer.attribute("ss:Width", width[i] / 1000);
            this.writer.attribute("ss:AutoFitWidth", 0);
            this.writer.closeTag("ss:Column");
            ++i;
        }
    }

    public void endTable() {
        this.writer.closeTag("ss:Table");
    }

    public void insertHorizontalMargin(int height, int span) {
        this.writer.openTag("Row");
        this.writer.attribute("ss:AutoFitHeight", 0);
        this.writer.attribute("ss:Height", height);
        this.writer.openTag("Cell");
        this.writer.attribute(" ss:MergeAcross", span);
        this.writer.closeTag("Cell");
        this.writer.closeTag("Row");
    }

    public void insertVerticalMargin(int start, int end, int length) {
        this.writer.openTag("Row");
        this.writer.attribute("ss:AutoFitHeight", 0);
        this.writer.attribute("ss:Height", 1);
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", start);
        this.writer.attribute(" ss:MergeDown", length);
        this.writer.closeTag("Cell");
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", end);
        this.writer.attribute(" ss:MergeDown", length);
        this.writer.closeTag("Cell");
        this.writer.closeTag("Row");
    }

    private void declareWorkSheetOptions(String orientation, int pageWidth, int pageHeight) {
        this.writer.openTag("WorksheetOptions");
        this.writer.attribute("xmlns", "urn:schemas-microsoft-com:office:excel");
        this.writer.openTag("PageSetup");
        if (orientation != null) {
            this.writer.openTag("Layout");
            this.writer.attribute("x:Orientation", orientation);
            this.writer.closeTag("Layout");
        }
        if (this.pageHeader != null) {
            this.writer.openTag("Header");
            this.writer.attribute("x:Data", this.pageHeader);
            this.writer.closeTag("Header");
        }
        if (this.pageFooter != null) {
            this.writer.openTag("Footer");
            this.writer.attribute("x:Data", this.pageFooter);
            this.writer.closeTag("Footer");
        }
        this.writer.closeTag("PageSetup");
        this.writer.openTag("Print");
        this.writer.openTag("PaperSizeIndex");
        int index = ExcelUtil.getPageSizeIndex(pageWidth / 1000, pageHeight / 1000);
        this.writer.text(String.valueOf(index));
        this.writer.closeTag("PaperSizeIndex");
        this.writer.closeTag("Print");
        this.writer.closeTag("WorksheetOptions");
    }

    @Override
    public void startSheet(int[] coordinates, String pageHeader, String pageFooter, String name) {
        this.pageHeader = pageHeader;
        this.pageFooter = pageFooter;
        this.startSheet(name, coordinates);
        ++this.sheetIndex;
    }

    @Override
    public void endSheet(String orientation, int pageWidth, int pageHeight) {
        this.endTable();
        this.declareWorkSheetOptions(orientation, pageWidth, pageHeight);
        this.closeSheet();
    }

    @Override
    public void start(IReportContent report, Map<StyleEntry, Integer> styles, HashMap<String, BookmarkDef> bookmarkList) {
        this.writeDeclarations();
        this.writeDocumentProperties(report);
        this.declareStyles(styles);
        this.outputBookmarks(bookmarkList);
    }

    private void outputBookmarks(HashMap<String, BookmarkDef> bookmarkList) {
        if (!bookmarkList.isEmpty()) {
            this.writer.openTag("Names");
            Set<Map.Entry<String, BookmarkDef>> bookmarkEntry = bookmarkList.entrySet();
            for (Map.Entry<String, BookmarkDef> bookmark : bookmarkEntry) {
                this.defineNames(bookmark);
            }
            this.writer.closeTag("Names");
        }
    }

    @Override
    public void end() {
        this.writer.closeTag("Workbook");
        this.close();
    }

    public void close() {
        this.writer.endWriter();
        this.writer.close();
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    @Override
    public void endSheet() {
        this.endSheet(null, 0, 0);
    }

    @Override
    public void startRow() {
        this.startRow(-1.0);
    }

    @Override
    public String defineName(String cells) {
        return null;
    }

    static class XLSEncodeUtil
    extends XMLEncodeUtil {
        protected static final char[] XLS_TEXT_ENCODE = new char[]{'&', '<', '\r', '\n'};

        XLSEncodeUtil() {
        }

        static String encodeXLSText(String s) {
            char[] chars = s.toCharArray();
            int length = chars.length;
            int index = XLSEncodeUtil.testEscape((char[])chars, (char[])XLS_TEXT_ENCODE);
            if (index >= length) {
                return s;
            }
            StringBuilder sb = new StringBuilder(2 * length);
            sb.append(chars, 0, index);
            while (index < length) {
                char c;
                if (Character.isHighSurrogate(c = chars[index++])) {
                    index += XLSEncodeUtil.decodeSurrogate((char)c, (char[])chars, (int)index, (StringBuilder)sb);
                    continue;
                }
                if (XLSEncodeUtil.isValidCodePoint((int)c)) {
                    if (c == '&') {
                        sb.append("&amp;");
                        continue;
                    }
                    if (c == '<') {
                        sb.append("&lt;");
                        continue;
                    }
                    if (c == '\r') {
                        char nc;
                        if (index < length && (nc = chars[index]) == '\n') {
                            ++index;
                        }
                        sb.append("&#10;");
                        continue;
                    }
                    if (c == '\n') {
                        sb.append("&#10;");
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                logger.log(Level.WARNING, "Invalid XML character:0x{0}", c);
            }
            return sb.toString();
        }
    }

    public class XMLWriterXLS
    extends XMLWriter {
        protected String encodeText(String text) {
            return XLSEncodeUtil.encodeXLSText(text);
        }
    }
}

