/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class GroupInfo {
    private String name;
    private String[] columnExpressions;
    private List[] columns;
    private List subGroupInfos;
    private GroupInfo nextSibling;
    private static GroupInfo head = new GroupInfo();
    private static List positions = new ArrayList();

    private GroupInfo() {
    }

    public GroupInfo(String gname, String[] cn) {
        this.name = gname;
        this.subGroupInfos = new ArrayList();
        this.columnExpressions = cn;
        this.columns = new ArrayList[this.columnExpressions.length];
    }

    public boolean addPosition(int index, int c, int r) {
        if (index < 0 || index >= this.columns.length) {
            return false;
        }
        if (this.columns[index] == null) {
            this.columns[index] = new ArrayList();
        }
        this.columns[index].add(new Position(r, c));
        return true;
    }

    public void addSubGroupInfo(GroupInfo child) {
        if (this.subGroupInfos == null) {
            this.subGroupInfos = new ArrayList();
        }
        this.subGroupInfos.add(child);
    }

    public List getByGroup(String gname, String cname, int index) {
        GroupInfo g = this.findFirstGroupByName(gname);
        if (g.nextSibling == null) {
            this.threadGroupsByName(gname);
        }
        g = g.getGroupByIndex(index);
        positions.clear();
        g.getPositions(cname);
        return positions;
    }

    private GroupInfo getGroupByIndex(int index) {
        GroupInfo g = this;
        int i = 0;
        while (i < index && g.nextSibling != null) {
            g = g.nextSibling;
            ++i;
        }
        return g;
    }

    private GroupInfo findFirstGroupByName(String gname) {
        GroupInfo g = this;
        while (!g.name.equals(gname) && g.subGroupInfos.size() > 0) {
            g = (GroupInfo)g.subGroupInfos.get(0);
        }
        return g;
    }

    private void threadGroupsByName(String gname) {
        if (this.name.equals(gname)) {
            GroupInfo.head.nextSibling = this;
            head = this;
        } else {
            int i = 0;
            while (i < this.subGroupInfos.size()) {
                ((GroupInfo)this.subGroupInfos.get(i)).threadGroupsByName(gname);
                ++i;
            }
        }
    }

    private void getPositions(String exp) {
        if (this.subGroupInfos.size() == 0) {
            positions.addAll(this.getPsByColExp(exp));
        } else {
            int i = 0;
            while (i < this.subGroupInfos.size()) {
                ((GroupInfo)this.subGroupInfos.get(i)).getPositions(exp);
                ++i;
            }
        }
    }

    private List getPsByColExp(String exp) {
        List x = this.columns[this.getIndex(exp)];
        if (x == null) {
            return new ArrayList();
        }
        return this.columns[this.getIndex(exp)];
    }

    private int getIndex(String exp) {
        int i = 0;
        while (i < this.columnExpressions.length) {
            if (this.columnExpressions[i].equals(exp)) {
                return i;
            }
            ++i;
        }
        throw new NoSuchElementException("No such expression in TableBinding");
    }

    public String[] getColExps() {
        return this.columnExpressions;
    }

    protected static class Position {
        int row;
        int column;

        public Position(int r, int c) {
            this.row = r;
            this.column = c;
        }
    }
}

