/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.emitter.excel.StyleBuilder;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.ContainerSizeInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelLayoutEngine;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsContainer;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleEngine {
    public static final int DEFAULT_DATE_STYLE = 1;
    public static final int RESERVE_STYLE_ID = 20;
    private int styleID = 20;
    private HashMap<StyleEntry, Integer> style2id = new HashMap();
    private HashMap<Integer, StyleEntry> id2Style = new HashMap();
    private ExcelLayoutEngine engine;
    private Stack<StyleEntry> containerStyles = new Stack();

    public StyleEngine(ExcelLayoutEngine engine) {
        this.engine = engine;
        this.style2id.put(this.getDefaultEntry(1), new Integer(1));
    }

    public StyleEntry getDefaultEntry(int id) {
        StyleEntry entry = new StyleEntry();
        if (id == 1) {
            entry.setProperty(22, "yyyy-M-d HH:mm:ss AM/PM");
            entry.setProperty(25, 0);
        }
        return entry;
    }

    public StyleEntry createEntry(ContainerSizeInfo sizeInfo, IStyle style, StyleEntry parent) {
        if (style == null) {
            return StyleBuilder.createEmptyStyleEntry();
        }
        StyleEntry entry = this.initStyle(style, sizeInfo, parent);
        return entry;
    }

    public StyleEntry createCellEntry(ContainerSizeInfo sizeInfo, IStyle style, String diagonalLineColor, String diagonalLineStyle, int diagonalLineWidth, StyleEntry parent) {
        StyleEntry entry = style == null ? StyleBuilder.createEmptyStyleEntry() : this.initStyle(style, sizeInfo, parent);
        StyleBuilder.applyDiagonalLine(entry, PropertyUtil.getColor((String)diagonalLineColor), diagonalLineStyle, diagonalLineWidth);
        return entry;
    }

    public StyleEntry createHorizontalStyle(ContainerSizeInfo rule) {
        StyleEntry entry = StyleBuilder.createEmptyStyleEntry();
        if (this.engine.getContainers().size() > 0) {
            XlsContainer container = this.engine.getCurrentContainer();
            ContainerSizeInfo crule = container.getSizeInfo();
            StyleEntry cEntry = container.getStyle();
            StyleBuilder.mergeInheritableProp(cEntry, entry);
            if (rule.getStartCoordinate() == crule.getStartCoordinate()) {
                StyleBuilder.applyLeftBorder(cEntry, entry);
            }
            if (rule.getEndCoordinate() == crule.getEndCoordinate()) {
                StyleBuilder.applyRightBorder(cEntry, entry);
            }
        }
        return entry;
    }

    public StyleEntry getStyle(IStyle style, ContainerSizeInfo rule, StyleEntry parent) {
        return this.initStyle(style, null, rule, parent);
    }

    public StyleEntry getStyle(IStyle style, ContainerSizeInfo childSizeInfo, ContainerSizeInfo parentSizeInfo, StyleEntry parent) {
        return this.initStyle(style, childSizeInfo, parentSizeInfo, parent);
    }

    private StyleEntry initStyle(IStyle style, ContainerSizeInfo childSizeInfo, ContainerSizeInfo parentSizeInfo, StyleEntry parent) {
        StyleEntry entry = StyleBuilder.createStyleEntry(style, parent);
        if (!this.containerStyles.isEmpty()) {
            StyleEntry centry = this.containerStyles.peek();
            StyleBuilder.mergeInheritableProp(centry, entry);
        }
        if (this.engine.getContainers().size() > 0) {
            XlsContainer container = this.engine.getCurrentContainer();
            StyleEntry cEntry = container.getStyle();
            StyleBuilder.mergeInheritableProp(cEntry, entry);
            if (childSizeInfo == null) {
                childSizeInfo = container.getSizeInfo();
            }
            this.applyHBorders(cEntry, entry, childSizeInfo, parentSizeInfo);
            this.applyTopBorderStyle(entry);
        }
        return entry;
    }

    private void applyTopBorderStyle(StyleEntry childStyle) {
        XlsContainer container = this.engine.getCurrentContainer();
        int rowIndex = container.getRowIndex();
        XlsContainer parent = container;
        while (parent != null && parent.getStartRowId() == rowIndex) {
            StyleBuilder.applyTopBorder(parent.getStyle(), childStyle);
            parent = parent.getParent();
        }
    }

    public int getStyleId(StyleEntry entry) {
        if (entry == null) {
            return 0;
        }
        int styleId = 0;
        Integer id = this.style2id.get(entry);
        if (id != null) {
            styleId = id;
        } else {
            styleId = this.styleID++;
            this.style2id.put(entry, new Integer(styleId));
            this.id2Style.put(new Integer(styleId), entry);
        }
        return styleId;
    }

    public Map<StyleEntry, Integer> getStyleIDMap() {
        return this.style2id;
    }

    private void applyHBorders(StyleEntry centry, StyleEntry entry, ContainerSizeInfo crule, ContainerSizeInfo rule) {
        if (crule == null || rule == null) {
            return;
        }
        if (crule.getStartCoordinate() == rule.getStartCoordinate()) {
            StyleBuilder.applyLeftBorder(centry, entry);
        }
        if (crule.getEndCoordinate() == rule.getEndCoordinate()) {
            StyleBuilder.applyRightBorder(centry, entry);
        }
    }

    private StyleEntry initStyle(IStyle style, ContainerSizeInfo rule, StyleEntry parent) {
        return this.initStyle(style, null, rule, parent);
    }

    public void addContainderStyle(IStyle computedStyle, StyleEntry parent) {
        StyleEntry entry = StyleBuilder.createStyleEntry(computedStyle, parent);
        if (!this.containerStyles.isEmpty()) {
            StyleEntry centry = this.containerStyles.peek();
            StyleBuilder.mergeInheritableProp(centry, entry);
        }
        this.containerStyles.add(entry);
    }

    public void removeForeignContainerStyle() {
        if (!this.containerStyles.isEmpty()) {
            this.containerStyles.pop();
        }
    }

    public void applyContainerBottomStyle() {
        this.applyContainerBottomStyle(this.engine.getCurrentContainer());
    }

    public void applyContainerBottomStyle(XlsContainer container) {
        ContainerSizeInfo rule = container.getSizeInfo();
        StyleEntry entry = container.getStyle();
        int start = rule.getStartCoordinate();
        int col = this.engine.getAxis().getColumnIndexByCoordinate(start);
        int span = this.engine.getAxis().getColumnIndexByCoordinate(rule.getEndCoordinate());
        int i = col;
        while (i < span) {
            StyleEntry originalStyle;
            StyleEntry newStyle;
            boolean isChanged;
            int styleId;
            SheetData data = this.engine.getColumnLastData(i);
            if (data != null && (styleId = data.getStyleId()) != -1 && (isChanged = StyleBuilder.applyBottomBorder(entry, newStyle = new StyleEntry(originalStyle = this.getStyle(styleId))))) {
                data.setStyleId(this.getStyleId(newStyle));
            }
            ++i;
        }
    }

    public StyleEntry getStyle(int id) {
        return this.id2Style.get(id);
    }

    public static class ExcelArea {
        public int row;
        public int col;
        public int rowSpan;
        public int colSpan;

        public ExcelArea(int row, int col, int rowSpan, int colSpan) {
            this.row = row;
            this.col = col;
            this.rowSpan = rowSpan;
            this.colSpan = colSpan;
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + this.row;
            result = 31 * result + this.col;
            result = 31 * result + this.rowSpan;
            result = 31 * result + this.colSpan;
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ExcelArea)) {
                return false;
            }
            ExcelArea area = (ExcelArea)obj;
            return this.row == area.row && this.col == area.col && this.rowSpan == area.rowSpan && this.colSpan == area.colSpan;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExcelRange {
        private Set<ExcelArea> areas = new HashSet<ExcelArea>();

        public void addArea(ExcelArea area) {
            this.areas.add(area);
        }

        public Set<ExcelArea> getAreas() {
            return Collections.unmodifiableSet(this.areas);
        }
    }
}

