/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.layout;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.layout.ColumnsInfo;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.layout.emitter.Image;

public class LayoutUtil {
    private static final Logger log = Logger.getLogger(LayoutUtil.class.getName());

    public static ColumnsInfo createTable(int col, int width) {
        return new ColumnsInfo(col, width);
    }

    public static ColumnsInfo createTable(IListContent list, int width, int dpi) {
        width = LayoutUtil.getElementWidth((IContent)list, width, dpi);
        int[] column = new int[]{width};
        return new ColumnsInfo(column);
    }

    public static ColumnsInfo createChart(IForeignContent content, int width, int dpi) {
        ExtendedItemDesign design = (ExtendedItemDesign)content.getGenerateBy();
        DimensionType value = design.getWidth();
        if (value != null) {
            width = LayoutUtil.getElementWidth(value, width, dpi);
        }
        int[] column = new int[]{width};
        return new ColumnsInfo(column);
    }

    public static ColumnsInfo createImage(IImageContent image, int width, int imageWidthDpi) {
        width = LayoutUtil.getImageWidth(image, width, imageWidthDpi);
        int[] column = new int[]{width};
        return new ColumnsInfo(column);
    }

    public static int getImageWidth(IImageContent image, int width, int imageWidthDpi) {
        int dpi = imageWidthDpi;
        DimensionType value = image.getWidth();
        if (value != null) {
            width = LayoutUtil.getElementWidth(value, width, dpi);
        } else {
            try {
                Image imageInfo = EmitterUtil.parseImage((IImageContent)image, (int)image.getImageSource(), (String)image.getURI(), (String)image.getMIMEType(), (String)image.getExtension());
                width = (int)((float)imageInfo.getWidth() * 72.0f / (float)dpi * 1000.0f);
            }
            catch (IOException e1) {
                log.log(Level.WARNING, e1.getLocalizedMessage());
            }
        }
        return width;
    }

    public static int getElementWidth(IContent content, int width, int dpi) {
        DimensionType value = content.getWidth();
        if (value != null) {
            return LayoutUtil.getElementWidth(value, width, dpi);
        }
        return width;
    }

    private static int getElementWidth(DimensionType contentWidth, int width, int dpi) {
        try {
            width = Math.min(ExcelUtil.convertDimensionType(contentWidth, width, dpi), width);
        }
        catch (Exception exception) {}
        return width;
    }

    public static int[] createFixedTable(ITableContent table, int tableWidth, int dpi) {
        int columnCount = table.getColumnCount();
        int[] columns = new int[columnCount];
        int unassignedCount = 0;
        int totalAssigned = 0;
        int i = 0;
        while (i < columnCount) {
            DimensionType value = table.getColumn(i).getWidth();
            if (value == null) {
                columns[i] = -1;
                ++unassignedCount;
            } else {
                columns[i] = ExcelUtil.convertDimensionType(value, tableWidth, dpi);
                totalAssigned += columns[i];
            }
            ++i;
        }
        if (table.getWidth() == null && unassignedCount == 0) {
            return columns;
        }
        return EmitterUtil.resizeTableColumn((int)tableWidth, (int[])columns, (int)unassignedCount, (int)totalAssigned);
    }

    public static ColumnsInfo createTable(ITableContent table, int width, int dpi) {
        int tableWidth = LayoutUtil.getElementWidth((IContent)table, width, dpi);
        int columnCount = table.getColumnCount();
        if (columnCount == 0) {
            return null;
        }
        int[] columns = new int[columnCount];
        int unassignedCount = 0;
        int totalAssigned = 0;
        int i = 0;
        while (i < columnCount) {
            DimensionType value = table.getColumn(i).getWidth();
            if (value == null) {
                columns[i] = -1;
                ++unassignedCount;
            } else {
                columns[i] = ExcelUtil.convertDimensionType(value, tableWidth, dpi);
                totalAssigned += columns[i];
            }
            ++i;
        }
        int leftWidth = tableWidth - totalAssigned;
        if (leftWidth != 0 && unassignedCount == 0) {
            int totalResized = 0;
            int i2 = 0;
            while (i2 < columnCount - 1) {
                columns[i2] = LayoutUtil.resize(columns[i2], totalAssigned, leftWidth);
                totalResized += columns[i2];
                ++i2;
            }
            columns[columnCount - 1] = tableWidth - totalResized;
        } else if (leftWidth < 0 && unassignedCount > 0) {
            int totalResized = 0;
            int lastAssignedIndex = 0;
            int i3 = 0;
            while (i3 < columnCount) {
                if (columns[i3] == -1) {
                    columns[i3] = 0;
                } else {
                    columns[i3] = LayoutUtil.resize(columns[i3], totalAssigned, leftWidth);
                    lastAssignedIndex = i3;
                }
                totalResized += columns[i3];
                ++i3;
            }
            int n = lastAssignedIndex;
            columns[n] = columns[n] + (tableWidth - totalResized);
        } else if (leftWidth >= 0 && unassignedCount > 0) {
            int per = leftWidth / unassignedCount;
            int index = 0;
            int i4 = 0;
            while (i4 < columns.length) {
                if (columns[i4] == -1) {
                    columns[i4] = per;
                    index = i4;
                }
                ++i4;
            }
            columns[index] = leftWidth - per * (unassignedCount - 1);
        }
        return new ColumnsInfo(columns);
    }

    private static int resize(int width, int total, int left) {
        return Math.round((float)width + (float)width / (float)total * (float)left);
    }
}

