/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.provider.DiffTree;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.CVSWorkspaceSubscriber;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.PruneFolderVisitor;
import org.eclipse.team.internal.ccvs.core.mapping.CVSActiveChangeSetCollector;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.mappings.CVSSubscriberMergeContext;
import org.eclipse.team.internal.ccvs.ui.operations.CacheBaseContentsOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CacheRemoteContentsOperation;
import org.eclipse.team.internal.core.mapping.GroupProgressMonitor;
import org.eclipse.team.internal.core.subscribers.SubscriberDiffTreeEventHandler;

public class WorkspaceSubscriberContext
extends CVSSubscriberMergeContext {
    private final int type;
    static /* synthetic */ Class class$0;

    public static SubscriberScopeManager createWorkspaceScopeManager(ResourceMapping[] mappings, boolean consultModels, boolean consultChangeSets) {
        return new ChangeSetSubscriberScopeManager(CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().getName(), mappings, (Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber(), consultModels, consultChangeSets);
    }

    public static SubscriberScopeManager createUpdateScopeManager(ResourceMapping[] mappings, boolean consultModels) {
        return new SubscriberScopeManager(CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().getName(), mappings, (Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber(), consultModels);
    }

    public static WorkspaceSubscriberContext createContext(ISynchronizationScopeManager manager, int type) {
        CVSWorkspaceSubscriber subscriber = CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
        WorkspaceSubscriberContext mergeContext = new WorkspaceSubscriberContext(subscriber, manager, type);
        mergeContext.initialize();
        return mergeContext;
    }

    protected WorkspaceSubscriberContext(CVSWorkspaceSubscriber subscriber, ISynchronizationScopeManager manager, int type) {
        super((Subscriber)subscriber, manager);
        this.type = type;
    }

    public void markAsMerged(IDiff[] nodes, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        if (this.getType() == 2) {
            DiffTree tree = (DiffTree)this.getDiffTree();
            try {
                tree.beginInput();
                int i = 0;
                while (i < nodes.length) {
                    IDiff diff = nodes[i];
                    tree.remove(diff.getPath());
                    ++i;
                }
            }
            finally {
                tree.endInput(monitor);
            }
        } else {
            super.markAsMerged(nodes, inSyncHint, monitor);
        }
    }

    public void markAsMerged(final IDiff diff, final boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        this.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IResource resource = WorkspaceSubscriberContext.this.getDiffTree().getResource(diff);
                if (resource.getType() != 1) {
                    if (diff instanceof IThreeWayDiff) {
                        SyncInfo info;
                        IThreeWayDiff twd = (IThreeWayDiff)diff;
                        if (resource.getType() == 2 && twd.getKind() == 1 && twd.getDirection() == 512 && resource.exists() && (info = WorkspaceSubscriberContext.this.getSyncInfo(resource)) instanceof CVSSyncInfo) {
                            CVSSyncInfo cvsInfo = (CVSSyncInfo)info;
                            cvsInfo.makeInSync();
                        }
                    }
                    return;
                }
                if (WorkspaceSubscriberContext.this.getType() == 2) {
                    ((DiffTree)WorkspaceSubscriberContext.this.getDiffTree()).remove(diff.getPath());
                } else {
                    SyncInfo info = WorkspaceSubscriberContext.this.getSyncInfo(resource);
                    WorkspaceSubscriberContext.this.ensureRemotesMatch(resource, diff, info);
                    if (info instanceof CVSSyncInfo) {
                        CVSSyncInfo cvsInfo = (CVSSyncInfo)info;
                        monitor.beginTask(null, 50 + (inSyncHint ? 100 : 0));
                        cvsInfo.makeOutgoing(Policy.subMonitorFor(monitor, 50));
                        if (inSyncHint) {
                            SyncInfoFilter.ContentComparisonSyncInfoFilter comparator = new SyncInfoFilter.ContentComparisonSyncInfoFilter(false);
                            if (resource.getType() == 1 && info.getRemote() != null && comparator.compareContents((IFile)resource, info.getRemote(), Policy.subMonitorFor(monitor, 100))) {
                                ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)resource));
                                cvsFile.checkedIn(null, false);
                            }
                        }
                        monitor.done();
                    }
                }
            }
        }, this.getMergeRule(diff), 0, monitor);
    }

    protected void makeInSync(final IDiff diff, IProgressMonitor monitor) throws CoreException {
        this.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IResource resource = WorkspaceSubscriberContext.this.getDiffTree().getResource(diff);
                if (resource.getType() != 1) {
                    return;
                }
                SyncInfo info = WorkspaceSubscriberContext.this.getSyncInfo(resource);
                WorkspaceSubscriberContext.this.ensureRemotesMatch(resource, diff, info);
                IResourceVariant remote = info.getRemote();
                RemoteFile file = (RemoteFile)remote;
                if (file != null) {
                    remote = file.getCachedHandle();
                }
                if (info instanceof CVSSyncInfo) {
                    CVSSyncInfo cvsInfo = (CVSSyncInfo)info;
                    cvsInfo.makeOutgoing(monitor);
                    if (resource.getType() == 1 && info.getRemote() != null) {
                        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)resource));
                        if (remote != null && remote instanceof RemoteFile) {
                            cvsFile.setExecutable(((RemoteFile)remote).isExecutable());
                            cvsFile.setTimeStamp(((RemoteFile)remote).getTimeStamp());
                            cvsFile.setReadOnly(WorkspaceSubscriberContext.this.getReadOnly(cvsFile));
                        }
                        cvsFile.checkedIn(null, false);
                    }
                }
            }
        }, this.getMergeRule(diff), 0, monitor);
    }

    protected boolean getReadOnly(ICVSFile cvsFile) {
        IResource resource = cvsFile.getIResource();
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject());
        if (provider instanceof CVSTeamProvider) {
            CVSTeamProvider ctp = (CVSTeamProvider)provider;
            try {
                return ctp.isWatchEditEnabled();
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        return false;
    }

    protected void ensureRemotesMatch(IResource resource, IDiff node, SyncInfo info) throws CVSException {
        String ci2;
        String ci1;
        IResourceVariant variant = info.getRemote();
        IFileRevision remote = this.getRemote(node);
        if (variant != null && remote != null && remote instanceof IFileRevision && !(ci1 = variant.getContentIdentifier()).equals(ci2 = remote.getContentIdentifier())) {
            throw new CVSException(NLS.bind((String)CVSUIMessages.WorkspaceSubscriberContext_0, (Object)resource.getFullPath().toString()));
        }
    }

    private IFileRevision getRemote(IDiff node) {
        if (node == null) {
            return null;
        }
        if (node instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)node;
            return this.getRemote((IDiff)twd.getRemoteChange());
        }
        if (node instanceof IResourceDiff) {
            IResourceDiff rd = (IResourceDiff)node;
            return rd.getAfterState();
        }
        return null;
    }

    public IStatus merge(IDiff delta, boolean force, IProgressMonitor monitor) throws CoreException {
        IThreeWayDiff currentDiff;
        if (this.getMergeType() == 2) {
            force = true;
        }
        if ((currentDiff = (IThreeWayDiff)this.getSubscriber().getDiff(this.getDiffTree().getResource(delta))) == null || currentDiff.getKind() == 0 || currentDiff.getDirection() == 256 && !force) {
            return Status.OK_STATUS;
        }
        if (!this.equals(currentDiff, (IThreeWayDiff)delta)) {
            throw new CVSException(NLS.bind((String)CVSUIMessages.CVSMergeContext_1, (Object)delta.getPath()));
        }
        try {
            monitor.beginTask(null, 100);
            IStatus status = super.merge(delta, force, Policy.subMonitorFor(monitor, 99));
            if (status.isOK()) {
                IResource resource = this.getDiffTree().getResource(delta);
                if (resource.getType() == 1 && !resource.exists()) {
                    ICVSResource localResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                    localResource.unmanage(Policy.subMonitorFor(monitor, 1));
                }
                this.pruneEmptyParents(new IDiff[]{delta});
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private boolean equals(IThreeWayDiff currentDiff, IThreeWayDiff otherDiff) {
        return currentDiff.getKind() == otherDiff.getKind() && currentDiff.getDirection() == otherDiff.getDirection();
    }

    private void pruneEmptyParents(IDiff[] deltas) throws CVSException {
        if (!CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
            return;
        }
        ICVSResource[] cvsResources = new ICVSResource[deltas.length];
        int i = 0;
        while (i < cvsResources.length) {
            cvsResources[i] = CVSWorkspaceRoot.getCVSResourceFor((IResource)this.getDiffTree().getResource(deltas[i]));
            ++i;
        }
        new PruneFolderVisitor().visit(CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot()), cvsResources);
    }

    public int getMergeType() {
        return this.type;
    }

    public void refresh(final ResourceTraversal[] traversals, int flags, IProgressMonitor monitor) throws CoreException {
        SubscriberDiffTreeEventHandler handler = this.getHandler();
        if (handler != null) {
            GroupProgressMonitor group = this.getGroup(monitor);
            if (group != null) {
                handler.setProgressGroupHint(group.getGroup(), group.getTicks());
            }
            handler.initializeIfNeeded();
            ((CVSWorkspaceSubscriber)this.getSubscriber()).refreshWithContentFetch(traversals, monitor);
            this.runInBackground(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    WorkspaceSubscriberContext.this.cacheContents(traversals, WorkspaceSubscriberContext.this.getDiffTree(), true, monitor);
                }
            });
        } else {
            super.refresh(traversals, flags, monitor);
            this.runInBackground(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    WorkspaceSubscriberContext.this.cacheContents(traversals, WorkspaceSubscriberContext.this.getDiffTree(), false, monitor);
                }
            });
        }
    }

    private SubscriberDiffTreeEventHandler getHandler() {
        Object o;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.internal.core.subscribers.SubscriberDiffTreeEventHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = this.getAdapter(clazz)) instanceof SubscriberDiffTreeEventHandler) {
            return (SubscriberDiffTreeEventHandler)o;
        }
        return null;
    }

    private GroupProgressMonitor getGroup(IProgressMonitor monitor) {
        if (monitor instanceof GroupProgressMonitor) {
            return (GroupProgressMonitor)monitor;
        }
        if (monitor instanceof ProgressMonitorWrapper) {
            ProgressMonitorWrapper wrapper = (ProgressMonitorWrapper)monitor;
            return this.getGroup(wrapper.getWrappedProgressMonitor());
        }
        return null;
    }

    protected void cacheContents(final ResourceTraversal[] traversals, IResourceDiffTree tree, boolean baseOnly, IProgressMonitor monitor) throws CVSException {
        ResourceMapping[] mappings = new ResourceMapping[]{new ResourceMapping(){

            public Object getModelObject() {
                return WorkspaceSubscriberContext.this;
            }

            public IProject[] getProjects() {
                return ResourcesPlugin.getWorkspace().getRoot().getProjects();
            }

            public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
                return traversals;
            }

            public boolean contains(ResourceMapping mapping) {
                return false;
            }

            public String getModelProviderId() {
                return "org.eclipse.core.resources.modelProvider";
            }
        }};
        try {
            try {
                monitor.beginTask(null, 50);
                new CacheBaseContentsOperation(null, mappings, tree, true).run(Policy.subMonitorFor(monitor, 25));
                if (!baseOnly) {
                    new CacheRemoteContentsOperation(null, mappings, tree).run(Policy.subMonitorFor(monitor, 25));
                }
            }
            catch (InvocationTargetException e) {
                throw CVSException.wrapException((Exception)e);
            }
            catch (InterruptedException interruptedException) {
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public IStatus merge(IDiff[] deltas, boolean force, IProgressMonitor monitor) throws CoreException {
        try {
            if (deltas.length == 0) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            String taskName = this.getMergeTaskName(deltas, force);
            monitor.beginTask(taskName, 100);
            monitor.setTaskName(taskName);
            this.cacheContents(this.getTraversals(deltas), this.getDiffTree(deltas), false, Policy.subMonitorFor(monitor, 30));
            IStatus iStatus = super.merge(deltas, force, Policy.subMonitorFor(monitor, 70));
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private String getMergeTaskName(IDiff[] deltas, boolean force) {
        if (force) {
            if (deltas.length == 1) {
                return NLS.bind((String)CVSUIMessages.WorkspaceSubscriberContext_1, (Object)this.getDiffTree().getResource(deltas[0]).getFullPath());
            }
            return NLS.bind((String)CVSUIMessages.WorkspaceSubscriberContext_2, (Object)new Integer(deltas.length));
        }
        if (deltas.length == 1) {
            return NLS.bind((String)CVSUIMessages.WorkspaceSubscriberContext_3, (Object)this.getDiffTree().getResource(deltas[0]).getFullPath());
        }
        return NLS.bind((String)CVSUIMessages.WorkspaceSubscriberContext_4, (Object)new Integer(deltas.length));
    }

    private ResourceTraversal[] getTraversals(IDiff[] deltas) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < deltas.length) {
            IDiff diff = deltas[i];
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource != null) {
                result.add(resource);
            }
            ++i;
        }
        return new ResourceTraversal[]{new ResourceTraversal(result.toArray(new IResource[result.size()]), 0, 0)};
    }

    private IResourceDiffTree getDiffTree(IDiff[] deltas) {
        ResourceDiffTree tree = new ResourceDiffTree();
        int i = 0;
        while (i < deltas.length) {
            IDiff diff = deltas[i];
            tree.add(diff);
            ++i;
        }
        return tree;
    }

    protected void performReplace(IDiff diff, IProgressMonitor monitor) throws CoreException {
        IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
        if (resource.getType() == 1) {
            IFile file = (IFile)resource;
            ICVSFile mFile = CVSWorkspaceRoot.getCVSFileFor((IFile)file);
            try {
                if (mFile.isReadOnly()) {
                    mFile.setReadOnly(false);
                }
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
            }
        }
        super.performReplace(diff, monitor);
    }

    public static final class ChangeSetSubscriberScopeManager
    extends SubscriberScopeManager {
        private final boolean consultSets;

        private ChangeSetSubscriberScopeManager(String name, ResourceMapping[] mappings, Subscriber subscriber, boolean consultModels, boolean consultSets) {
            super(name, mappings, subscriber, consultModels);
            this.consultSets = consultSets;
        }

        protected ResourceTraversal[] adjustInputTraversals(ResourceTraversal[] traversals) {
            if (this.isConsultSets()) {
                return ((CVSActiveChangeSetCollector)CVSUIPlugin.getPlugin().getChangeSetManager()).adjustInputTraversals(traversals);
            }
            return super.adjustInputTraversals(traversals);
        }

        public boolean isConsultSets() {
            return this.consultSets;
        }
    }
}

