/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.platform.generic;

import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.ui.internal.JpaMappingImageHelper;
import org.eclipse.jpt.ui.internal.JptUiIcons;
import org.eclipse.jpt.ui.internal.jface.AbstractItemLabelProvider;
import org.eclipse.jpt.ui.jface.DelegatingContentAndLabelProvider;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentAttributeItemLabelProvider
extends AbstractItemLabelProvider {
    public PersistentAttributeItemLabelProvider(PersistentAttribute persistentAttribute, DelegatingContentAndLabelProvider labelProvider) {
        super((Model)persistentAttribute, labelProvider);
    }

    @Override
    protected PropertyValueModel<Image> buildImageModel() {
        return new PropertyAspectAdapter<PersistentAttribute, Image>(new String[]{"defaultMapping", "specifiedMapping"}, (PersistentAttribute)this.model()){

            protected Image buildValue_() {
                Image image = JpaMappingImageHelper.imageForAttributeMapping(((PersistentAttribute)this.subject).getMappingKey());
                if (((PersistentAttribute)PersistentAttributeItemLabelProvider.this.model()).isVirtual()) {
                    return JptUiIcons.ghost(image);
                }
                return image;
            }
        };
    }

    @Override
    protected PropertyValueModel<String> buildTextModel() {
        return new PropertyAspectAdapter<PersistentAttribute, String>("name", (PersistentAttribute)this.model()){

            protected String buildValue_() {
                return ((PersistentAttribute)this.subject).getName();
            }
        };
    }

    @Override
    protected PropertyValueModel<String> buildDescriptionModel() {
        return new PropertyAspectAdapter<PersistentAttribute, String>("name", (PersistentAttribute)this.model()){

            protected String buildValue_() {
                StringBuilder sb = new StringBuilder();
                sb.append(((PersistentAttribute)this.subject).getPersistenceUnit().getName());
                sb.append('/');
                sb.append(((PersistentAttribute)this.subject).getPersistentType().getName());
                sb.append('/');
                sb.append(((PersistentAttribute)this.subject).getName());
                IResource resource = ((PersistentAttribute)this.subject).getResource();
                if (resource != null) {
                    sb.append(" - ");
                    sb.append(resource.getFullPath().makeRelative());
                }
                return sb.toString();
            }
        };
    }
}

