/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec;

import org.eclipse.datatools.connectivity.oda.spec.ValueExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.ColumnIdentifier;
import org.eclipse.datatools.connectivity.oda.spec.valueexpr.ColumnValueExpression;
import org.eclipse.datatools.connectivity.oda.spec.valueexpr.SimpleValueExpression;

public class ExpressionVariable {
    public static final String ALIAS_SEPARATOR = "_";
    private String m_alias;
    private ValueExpression m_valueExpr;

    public ExpressionVariable(String variableIdentfier) {
        this(variableIdentfier, VariableType.RESULT_SET_COLUMN);
    }

    public ExpressionVariable(String variableIdentfier, VariableType varType) {
        switch (varType) {
            case RESULT_SET_COLUMN: {
                this.setColumnExpression(new ColumnIdentifier(variableIdentfier));
                break;
            }
            default: {
                this.setValueExpression(new SimpleValueExpression(variableIdentfier));
            }
        }
    }

    public ExpressionVariable(ColumnIdentifier columnIdentifier) {
        this.setColumnExpression(columnIdentifier);
    }

    public ExpressionVariable(ValueExpression valueExpr) {
        this.setValueExpression(valueExpr);
    }

    private void setColumnExpression(ColumnIdentifier columnIdentifier) {
        this.setValueExpression(new ColumnValueExpression(columnIdentifier));
    }

    private void setValueExpression(ValueExpression valueExpr) {
        this.m_valueExpr = valueExpr;
    }

    public ValueExpression getValueExpression() {
        return this.m_valueExpr;
    }

    public String getIdentifier() {
        return this.m_valueExpr != null ? this.m_valueExpr.getName() : this.m_alias;
    }

    public String getAlias() {
        return this.m_alias != null ? this.m_alias : this.getIdentifier();
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public VariableType getType() {
        if (this.m_valueExpr != null) {
            return this.m_valueExpr.getVariableType();
        }
        return VariableType.QUERY_EXPRESSION;
    }

    public void setType(VariableType type) {
    }

    public Integer getNativeDataType() {
        return null;
    }

    public void setNativeDataType(Integer nativeDataTypeCode) {
    }

    public Integer getOdaDataType() {
        if (this.m_valueExpr != null) {
            return this.m_valueExpr.getOdaDataType();
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(String.valueOf(this.getClass().getSimpleName()) + " alias= " + this.m_alias);
        buffer.append(", valueExpression = [");
        buffer.append(this.m_valueExpr);
        buffer.append("]");
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VariableType {
        RESULT_SET_COLUMN,
        INSTANCE_OF,
        QUERY_EXPRESSION;

    }
}

