/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.BorderInfomation;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BorderDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IToggleDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.swt.graphics.RGB;

public class BorderToggleDescriptorProvider
extends BorderDescriptorProvider
implements IToggleDescriptorProvider {
    private String property;

    public String getPosition() {
        if (this.property.equals("borderLeftStyle")) {
            return "left";
        }
        if (this.property.equals("borderRightStyle")) {
            return "right";
        }
        if (this.property.equals("borderTopStyle")) {
            return "top";
        }
        if (this.property.equals("borderBottomStyle")) {
            return "bottom";
        }
        return null;
    }

    public BorderToggleDescriptorProvider(String property) {
        this.property = property;
    }

    public String getImageName() {
        if (this.property.equals("borderLeftStyle")) {
            return "BORDER_LEFT";
        }
        if (this.property.equals("borderRightStyle")) {
            return "BORDER_RIGHT";
        }
        if (this.property.equals("borderTopStyle")) {
            return "BORDER_TOP";
        }
        if (this.property.equals("borderBottomStyle")) {
            return "BORDER_BOTTOM";
        }
        return "";
    }

    public String getToogleValue() {
        return null;
    }

    public String getTooltipText() {
        if (this.property.equals("borderLeftStyle")) {
            return Messages.getString((String)"BordersPage.Tooltip.Left");
        }
        if (this.property.equals("borderRightStyle")) {
            return Messages.getString((String)"BordersPage.Tooltip.Right");
        }
        if (this.property.equals("borderTopStyle")) {
            return Messages.getString((String)"BordersPage.Tooltip.Top");
        }
        if (this.property.equals("borderBottomStyle")) {
            return Messages.getString((String)"BordersPage.Tooltip.Bottom");
        }
        return "";
    }

    public String getDisplayName() {
        return null;
    }

    private RGB convertToRGB(String color) {
        int[] rgbValues = ColorUtil.getRGBs((String)color);
        if (rgbValues == null) {
            return null;
        }
        return new RGB(rgbValues[0], rgbValues[1], rgbValues[2]);
    }

    public Object load() {
        BorderInfomation info = new BorderInfomation();
        if (this.property.equals("borderLeftStyle")) {
            info.setPosition("left");
            info.setStyle(this.getLocalStringValue("borderLeftStyle"));
            info.setWidth(this.getLocalStringValue("borderLeftWidth"));
            info.setColor(this.convertToRGB(this.getLocalStringValue("borderLeftColor")));
        } else if (this.property.equals("borderRightStyle")) {
            info.setPosition("right");
            info.setStyle(this.getLocalStringValue("borderRightStyle"));
            info.setWidth(this.getLocalStringValue("borderRightWidth"));
            info.setColor(this.convertToRGB(this.getLocalStringValue("borderRightColor")));
        } else if (this.property.equals("borderTopStyle")) {
            info.setPosition("top");
            info.setStyle(this.getLocalStringValue("borderTopStyle"));
            info.setWidth(this.getLocalStringValue("borderTopWidth"));
            info.setColor(this.convertToRGB(this.getLocalStringValue("borderTopColor")));
        } else if (this.property.equals("borderBottomStyle")) {
            info.setPosition("bottom");
            info.setStyle(this.getLocalStringValue("borderBottomStyle"));
            info.setWidth(this.getLocalStringValue("borderBottomWidth"));
            info.setColor(this.convertToRGB(this.getLocalStringValue("borderBottomColor")));
        }
        return info;
    }

    public void save(Object value) throws SemanticException {
        String color;
        BorderInfomation info = (BorderInfomation)value;
        RGB rgb = info.getColor();
        int colorValue = -1;
        if (rgb != null) {
            colorValue = ColorUtil.formRGB((int)rgb.red, (int)rgb.green, (int)rgb.blue);
            color = ColorUtil.format((int)colorValue, (int)0);
        } else {
            color = null;
        }
        if (info.getPosition().equals("top")) {
            this.save("borderTopStyle", info.getStyle());
            this.save("borderTopColor", color);
            this.save("borderTopWidth", info.getWidth());
        } else if (info.getPosition().equals("bottom")) {
            this.save("borderBottomStyle", info.getStyle());
            this.save("borderBottomColor", color);
            this.save("borderBottomWidth", info.getWidth());
        } else if (info.getPosition().equals("left")) {
            this.save("borderLeftStyle", info.getStyle());
            this.save("borderLeftColor", color);
            this.save("borderLeftWidth", info.getWidth());
        } else if (info.getPosition().equals("right")) {
            this.save("borderRightStyle", info.getStyle());
            this.save("borderRightColor", color);
            this.save("borderRightWidth", info.getWidth());
        }
    }

    void handleModifyEvent() {
    }

    public void reset() throws SemanticException {
        if (this.getPosition().equals("top")) {
            this.save("borderTopStyle", null);
            this.save("borderTopColor", null);
            this.save("borderTopWidth", null);
        } else if (this.getPosition().equals("bottom")) {
            this.save("borderBottomStyle", null);
            this.save("borderBottomColor", null);
            this.save("borderBottomWidth", null);
        } else if (this.getPosition().equals("left")) {
            this.save("borderLeftStyle", null);
            this.save("borderLeftColor", null);
            this.save("borderLeftWidth", null);
        } else if (this.getPosition().equals("right")) {
            this.save("borderRightStyle", null);
            this.save("borderRightColor", null);
            this.save("borderRightWidth", null);
        }
    }

    public String getProperty() {
        return this.property;
    }
}

