/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PreviewPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.HighlightRuleBuilder;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.HighlightHandleProvider;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class HighlightDescriptorProvider
extends HighlightHandleProvider
implements PreviewPropertyDescriptorProvider {
    private static final HighlightRuleHandle[] EMPTY = new HighlightRuleHandle[0];
    protected Object input;
    private boolean canReset = false;

    public HighlightDescriptorProvider() {
    }

    public HighlightDescriptorProvider(int expressionType) {
        super(expressionType);
    }

    public String getColumnText(Object element, int columnIndex) {
        HighlightRuleHandle handle = (HighlightRuleHandle)element;
        switch (columnIndex) {
            case 0: {
                return String.valueOf(Messages.getString((String)"HighlightHandleProvider.text.Preview")) + DEUtil.getFontSize((String)handle.getFontSize().getStringValue()) + ")";
            }
            case 1: {
                String exp = String.valueOf(this.resolveNull(handle.getTestExpression())) + " " + HighlightRuleBuilder.getNameForOperator((String)handle.getOperator());
                int vv = HighlightRuleBuilder.determineValueVisible((String)handle.getOperator());
                if (vv == 1) {
                    exp = String.valueOf(exp) + " " + this.resolveNull(handle.getValue1());
                } else if (vv == 2) {
                    exp = String.valueOf(exp) + " " + this.resolveNull(handle.getValue1()) + " , " + this.resolveNull(handle.getValue2());
                } else if (vv == 3) {
                    exp = String.valueOf(exp) + " ";
                    int count = handle.getValue1List().size();
                    int i = 0;
                    while (i < count) {
                        exp = i == 0 ? String.valueOf(exp) + handle.getValue1List().get(i).toString() : String.valueOf(exp) + "; " + handle.getValue1List().get(i).toString();
                        ++i;
                    }
                }
                return exp;
            }
        }
        return "";
    }

    private String resolveNull(String src) {
        if (src == null) {
            return "";
        }
        return src;
    }

    public boolean doSwapItem(int pos, int direction) throws PropertyValueException {
        PropertyHandle phandle = this.getDesignElementHandle().getPropertyHandle("highlightRules");
        if (direction < 0) {
            phandle.moveItem(pos, pos - 1);
        } else {
            phandle.moveItem(pos, pos + 1);
        }
        return true;
    }

    public IStructuredContentProvider getContentProvider(IModelEventProcessor listener) {
        return new HighlightContentProvider(listener);
    }

    public LabelProvider getLabelProvider() {
        return new HighlightLabelProvider();
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            inputElement = ((List)inputElement).size() > 0 ? ((List)inputElement).get(0) : null;
        }
        if (inputElement instanceof DesignElementHandle) {
            this.elementHandle = (DesignElementHandle)inputElement;
            PropertyHandle highRules = this.elementHandle.getPropertyHandle("highlightRules");
            ArrayList list = new ArrayList();
            for (Object o : highRules) {
                list.add(o);
            }
            return list.toArray(new HighlightRuleHandle[0]);
        }
        return EMPTY;
    }

    public static String getFontFamily(String fontFamily) {
        String destFontName = (String)DesignerConstants.familyMap.get(fontFamily);
        if (destFontName == null) {
            destFontName = fontFamily;
        }
        return destFontName;
    }

    public StyleHandle getStyleHandle() {
        return this.getDesignElementHandle().getStyle();
    }

    public boolean doDeleteItem(int pos) throws PropertyValueException {
        PropertyHandle phandle = this.getDesignElementHandle().getPropertyHandle("highlightRules");
        phandle.removeItem(pos);
        return true;
    }

    public HighlightRuleHandle doAddItem(HighlightRule rule, int pos) {
        PropertyHandle phandle = this.getDesignElementHandle().getPropertyHandle("highlightRules");
        try {
            phandle.addItem((IStructure)rule);
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        StructureHandle handle = rule.getHandle((SimpleValueHandle)phandle, pos);
        return (HighlightRuleHandle)handle;
    }

    public boolean edit(Object input, int handleCount) {
        boolean result = false;
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"HighlightsPage.trans.Edit"));
            HighlightRuleBuilder builder = new HighlightRuleBuilder(UIUtil.getDefaultShell(), Messages.getString((String)"HighlightsPage.Dialog.EditHighlight"), (HighlightHandleProvider)this);
            HighlightRuleHandle handle = (HighlightRuleHandle)input;
            builder.updateHandle(handle, handleCount);
            builder.setDesignHandle(this.getDesignElementHandle());
            Object reportElement = this.getDesignElementHandle();
            while (reportElement instanceof RowHandle || reportElement instanceof ColumnHandle || reportElement instanceof CellHandle) {
                DesignElementHandle designElement = reportElement.getContainer();
                if ((reportElement = designElement instanceof ReportItemHandle ? (ReportItemHandle)designElement : (designElement instanceof GroupHandle ? (ReportItemHandle)((GroupHandle)designElement).getContainer() : designElement)) == null) break;
            }
            if (reportElement instanceof ReportItemHandle) {
                builder.setReportElement((ReportElementHandle)((ReportItemHandle)reportElement));
            } else if (reportElement instanceof GroupHandle) {
                builder.setReportElement((ReportElementHandle)((ReportItemHandle)((GroupHandle)reportElement).getContainer()));
            }
            if (builder.open() == 0) {
                result = true;
            }
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionUtil.handle((Throwable)e);
            result = false;
        }
        return result;
    }

    public boolean add(int handleCount) {
        boolean result = false;
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"HighlightsPage.trans.Add"));
            HighlightRuleBuilder dialog = this.createAddDialog(handleCount);
            if (dialog.open() == 0) {
                result = true;
            }
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionUtil.handle((Throwable)e);
            result = false;
        }
        return result;
    }

    protected HighlightRuleBuilder createAddDialog(int handleCount) {
        HighlightRuleBuilder builder = new HighlightRuleBuilder(UIUtil.getDefaultShell(), Messages.getString((String)"HighlightsPage.Dialog.NewHighlight"), (HighlightHandleProvider)this);
        builder.updateHandle(null, handleCount);
        builder.setDesignHandle(this.getDesignElementHandle());
        Object reportElement = this.getDesignElementHandle();
        while (reportElement instanceof RowHandle || reportElement instanceof ColumnHandle || reportElement instanceof CellHandle) {
            DesignElementHandle designElement = reportElement.getContainer();
            if ((reportElement = designElement instanceof ReportItemHandle ? (ReportItemHandle)designElement : (designElement instanceof GroupHandle ? (ReportItemHandle)((GroupHandle)designElement).getContainer() : designElement)) == null) break;
        }
        if (reportElement instanceof ReportItemHandle) {
            builder.setReportElement((ReportElementHandle)((ReportItemHandle)reportElement));
        } else if (reportElement instanceof GroupHandle) {
            builder.setReportElement((ReportElementHandle)((ReportItemHandle)((GroupHandle)reportElement).getContainer()));
        }
        return builder;
    }

    public boolean delete(int index) {
        boolean result = false;
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"HighlightsPage.trans.Delete"));
            this.doDeleteItem(index);
            stack.commit();
            result = true;
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionUtil.handle((Throwable)e);
            result = false;
        }
        return result;
    }

    public boolean moveUp(int index) {
        boolean result = false;
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"HighlightsPage.trans.MoveUp"));
            this.doSwapItem(index, -1);
            stack.commit();
            result = true;
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionUtil.handle((Throwable)e);
            result = false;
        }
        return result;
    }

    public boolean moveDown(int index) {
        boolean result = false;
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"HighlightsPage.trans.MoveDown"));
            this.doSwapItem(index, 1);
            stack.commit();
            result = true;
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionUtil.handle((Throwable)e);
            result = false;
        }
        return result;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public String getDisplayName() {
        return Messages.getString((String)"HighlightsPage.Label.Highlights");
    }

    public Object load() {
        return null;
    }

    public void save(Object value) throws SemanticException {
    }

    public String getFontFamily(Object object) {
        HighlightRuleHandle hrHandle = (HighlightRuleHandle)object;
        String rfm = DEUtil.removeQuote((String)hrHandle.getFontFamilyHandle().getStringValue());
        if (rfm == null || rfm.length() == 0) {
            rfm = this.getDesignElementHandle() != null ? this.getDesignElementHandle().getPrivateStyle().getFontFamilyHandle().getStringValue() : "serif";
        }
        return HighlightHandleProvider.getFontFamily((String)rfm);
    }

    public int getFontSize(Object object) {
        HighlightRuleHandle hrHandle = (HighlightRuleHandle)object;
        String rfs = hrHandle.getFontSize().getStringValue();
        if ((rfs == null || rfs.length() == 0) && this.getDesignElementHandle() != null) {
            rfs = this.getDesignElementHandle().getPrivateStyle().getFontSize().getStringValue();
        }
        return DEUtil.getFontSize((String)rfs);
    }

    public boolean isBold(Object object) {
        return "bold".equals(((HighlightRuleHandle)object).getFontWeight());
    }

    public boolean isItalic(Object object) {
        return "italic".equals(((HighlightRuleHandle)object).getFontStyle());
    }

    public boolean isUnderline(Object object) {
        return "underline".equals(((HighlightRuleHandle)object).getTextUnderline());
    }

    public boolean isLinethrough(Object object) {
        return "line-through".equals(((HighlightRuleHandle)object).getTextLineThrough());
    }

    public boolean isOverline(Object object) {
        return "overline".equals(((HighlightRuleHandle)object).getTextOverline());
    }

    public Color getColor(Object object) {
        return ColorManager.getColor((int)((HighlightRuleHandle)object).getColor().getRGB());
    }

    public Color getBackgroundColor(Object object) {
        return ColorManager.getColor((int)((HighlightRuleHandle)object).getBackgroundColor().getRGB());
    }

    public String getText(int key) {
        switch (key) {
            case 0: {
                return Messages.getString((String)"HighlightsPage.Label.Highlights");
            }
            case 1: {
                return Messages.getString((String)"HighlightsPage.Button.Add");
            }
            case 2: {
                return Messages.getString((String)"HighlightsPage.Button.Delete");
            }
            case 3: {
                return Messages.getString((String)"FormPage.Button.Up");
            }
            case 4: {
                return Messages.getString((String)"HighlightsPage.toolTipText.MoveUp");
            }
            case 5: {
                return Messages.getString((String)"FormPage.Button.Down");
            }
            case 6: {
                return Messages.getString((String)"HighlightsPage.toolTipText.MoveDown");
            }
            case 7: {
                return Messages.getString((String)"HighlightsPage.TableColumn.Preview");
            }
            case 8: {
                return Messages.getString((String)"HighlightsPage.TableColumn.Condition");
            }
            case 9: {
                return Messages.getString((String)"HighlightRuleBuilderDialog.text.PreviewContent");
            }
        }
        return "";
    }

    public boolean canReset() {
        return this.canReset;
    }

    public void enableReset(boolean canReset) {
        this.canReset = canReset;
    }

    public void reset() throws SemanticException {
        if (this.canReset()) {
            this.save(null);
        }
    }

    class HighlightContentProvider
    implements IStructuredContentProvider {
        private IModelEventProcessor listener;

        public HighlightContentProvider(IModelEventProcessor listener) {
            this.listener = listener;
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = HighlightDescriptorProvider.this.getElements(inputElement);
            this.deRegisterEventManager();
            this.registerEventManager();
            return elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
            this.deRegisterEventManager();
        }

        protected void deRegisterEventManager() {
            if (UIUtil.getModelEventManager() != null) {
                UIUtil.getModelEventManager().removeModelEventProcessor(this.listener);
            }
        }

        protected void registerEventManager() {
            if (UIUtil.getModelEventManager() != null) {
                UIUtil.getModelEventManager().addModelEventProcessor(this.listener);
            }
        }
    }

    class HighlightLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        HighlightLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return HighlightDescriptorProvider.this.getColumnText(element, 1);
        }
    }
}

