/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IFastConsumerProcessor;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.BorderCanvas;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.BorderInfomation;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.IComboProvider;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.StyleCombo;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BorderColorDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BorderStyleDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BorderToggleDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BorderWidthDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IToggleDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ColorBuilder;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.IPropertyDescriptor;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class BorderPropertyDescriptor
implements IPropertyDescriptor,
IFastConsumerProcessor,
Listener {
    private boolean isFormStyle;
    private BorderInfomation restoreInfo;
    private static final RGB autoColor = DEUtil.getRGBValue((int)ColorUtil.parsePredefinedColor((String)"black"));
    protected Object input;
    private BorderStyleDescriptorProvider styleProvider = null;
    private BorderColorDescriptorProvider colorProvider = null;
    private BorderWidthDescriptorProvider widthProvider = null;
    private Composite content;
    private int style = 2048;
    private StyleCombo styleCombo;
    private StyleCombo widthCombo;
    BorderToggleDescriptorProvider[] toggleProviders;
    private ColorBuilder builder;
    private Button[] toggles;
    private BorderCanvas previewCanvas;
    private Button allButton;

    public BorderPropertyDescriptor(boolean isFormStyle) {
        this.isFormStyle = isFormStyle;
    }

    public Control createControl(Composite parent) {
        this.content = new Composite(parent, 0);
        GridLayout layout = UIUtil.createGridLayoutWithoutMargin((int)2, (boolean)false);
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        layout.horizontalSpacing = 10;
        this.content.setLayout((Layout)layout);
        this.content.setLayoutData((Object)new GridData(1808));
        Composite choices = new Composite(this.content, 0);
        GridData data = new GridData(1808);
        choices.setLayoutData((Object)data);
        layout = WidgetUtil.createGridLayout(2);
        layout.marginHeight = 1;
        layout.marginWidth = 2;
        choices.setLayout((Layout)layout);
        Label styleLabel = FormWidgetFactory.getInstance().createLabel(choices, 16384, this.isFormStyle);
        styleLabel.setText(this.styleProvider.getDisplayName());
        styleLabel.setLayoutData((Object)new GridData());
        this.styleCombo = this.isFormStyle ? FormWidgetFactory.getInstance().createStyleCombo(choices, (IComboProvider)this.styleProvider) : new StyleCombo(choices, this.style, (IComboProvider)this.styleProvider);
        data = new GridData();
        data.widthHint = 200;
        this.styleCombo.setLayoutData((Object)data);
        this.styleCombo.setItems(this.styleProvider.getDisplayItems());
        this.styleProvider.setIndex(this.styleProvider.getDisplayItems()[0].toString());
        Label colorLabel = FormWidgetFactory.getInstance().createLabel(choices, 16384, this.isFormStyle);
        colorLabel.setText(this.colorProvider.getDisplayName());
        colorLabel.setLayoutData((Object)new GridData());
        this.builder = new ColorBuilder(choices, 0, this.isFormStyle);
        this.builder.setChoiceSet(this.colorProvider.getElementChoiceSet());
        this.colorProvider.setIndex("black");
        data = new GridData();
        data.widthHint = 200;
        data.heightHint = this.builder.computeSize((int)-1, (int)-1).y;
        this.builder.setLayoutData(data);
        Label widthLabel = FormWidgetFactory.getInstance().createLabel(choices, 16384, this.isFormStyle);
        widthLabel.setText(this.widthProvider.getDisplayName());
        widthLabel.setLayoutData((Object)new GridData());
        this.widthCombo = this.isFormStyle ? FormWidgetFactory.getInstance().createStyleCombo(choices, (IComboProvider)this.widthProvider) : new StyleCombo(choices, this.style, (IComboProvider)this.widthProvider);
        data = new GridData();
        data.widthHint = 200;
        this.widthCombo.setLayoutData((Object)data);
        this.widthCombo.setItems(this.widthProvider.getDisplayItems());
        this.widthProvider.setIndex(this.widthProvider.getDisplayItems()[1].toString());
        Composite composite = new Composite(choices, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 7;
        layout.numColumns = this.toggleProviders.length + 1;
        composite.setLayout((Layout)layout);
        data = new GridData();
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        this.toggles = new Button[this.toggleProviders.length];
        int i = 0;
        while (i < this.toggleProviders.length) {
            Button button;
            this.toggles[i] = button = new Button(composite, 2);
            button.setLayoutData((Object)new GridData());
            button.setToolTipText(this.toggleProviders[i].getTooltipText());
            button.setImage(ReportPlatformUIImages.getImage((String)this.toggleProviders[i].getImageName()));
            final BorderToggleDescriptorProvider provider = this.toggleProviders[i];
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.widget;
                    if (button.getSelection()) {
                        BorderPropertyDescriptor.this.handleBorderSelection(provider);
                    } else {
                        BorderPropertyDescriptor.this.handleBorderDeselection(provider, button);
                    }
                    BorderPropertyDescriptor.this.previewCanvas.redraw();
                }
            });
            button.setData((Object)provider);
            ++i;
        }
        this.allButton = new Button(composite, 2);
        this.allButton.setImage(ReportPlatformUIImages.getImage((String)"BORDER_FRAME"));
        this.allButton.setToolTipText(Messages.getString((String)"BordersPage.Tooltip.All"));
        this.allButton.setLayoutData((Object)new GridData());
        this.allButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RGB selectedColor = null;
                RGB oldColor = null;
                if (((Button)e.widget).getSelection()) {
                    CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
                    stack.startTrans(Messages.getString((String)"BordersPage.Trans.SelectAllborders"));
                    selectedColor = BorderPropertyDescriptor.this.builder.getRGB();
                    if (selectedColor == null) {
                        selectedColor = autoColor;
                    }
                    int i = 0;
                    while (i < BorderPropertyDescriptor.this.toggleProviders.length) {
                        BorderInfomation information = new BorderInfomation();
                        information.setPosition(BorderPropertyDescriptor.this.toggleProviders[i].getPosition());
                        information.setColor(selectedColor);
                        information.setStyle((String)BorderPropertyDescriptor.this.styleProvider.getItems()[BorderPropertyDescriptor.this.styleCombo.getSelectionIndex()]);
                        information.setWidth((String)BorderPropertyDescriptor.this.widthProvider.getItems()[BorderPropertyDescriptor.this.widthCombo.getSelectionIndex()]);
                        BorderPropertyDescriptor.this.toggles[i].setSelection(true);
                        BorderPropertyDescriptor.this.previewCanvas.setBorderInfomation(information);
                        BorderPropertyDescriptor.this.restoreInfo = information;
                        try {
                            BorderPropertyDescriptor.this.toggleProviders[i].save(information);
                        }
                        catch (Exception e1) {
                            ExceptionUtil.handle((Throwable)e1);
                        }
                        ++i;
                    }
                    stack.commit();
                } else {
                    boolean reset = true;
                    int i = 0;
                    while (i < BorderPropertyDescriptor.this.toggleProviders.length) {
                        BorderInfomation info = (BorderInfomation)BorderPropertyDescriptor.this.toggleProviders[i].load();
                        oldColor = info.getColor();
                        selectedColor = BorderPropertyDescriptor.this.builder.getRGB();
                        if (oldColor == null) {
                            oldColor = autoColor;
                        }
                        if (selectedColor == null) {
                            selectedColor = autoColor;
                        }
                        if (!(info.getStyle().equals((String)BorderPropertyDescriptor.this.styleProvider.getItems()[BorderPropertyDescriptor.this.styleCombo.getSelectionIndex()]) && oldColor.equals((Object)selectedColor) && info.getWidth().equals((String)BorderPropertyDescriptor.this.widthProvider.getItems()[BorderPropertyDescriptor.this.widthCombo.getSelectionIndex()]))) {
                            reset = false;
                            break;
                        }
                        ++i;
                    }
                    if (reset) {
                        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
                        stack.startTrans(Messages.getString((String)"BordersPage.Trans.UnSelectAllborders"));
                        int i2 = 0;
                        while (i2 < BorderPropertyDescriptor.this.toggleProviders.length) {
                            BorderPropertyDescriptor.this.previewCanvas.removeBorderInfomation(BorderPropertyDescriptor.this.toggleProviders[i2].getPosition());
                            BorderPropertyDescriptor.this.toggles[i2].setSelection(false);
                            try {
                                BorderPropertyDescriptor.this.toggleProviders[i2].reset();
                            }
                            catch (Exception e1) {
                                ExceptionUtil.handle((Throwable)e1);
                            }
                            ++i2;
                        }
                        stack.commit();
                    } else {
                        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
                        stack.startTrans(Messages.getString((String)"BordersPage.Trans.SelectAllborders"));
                        int i3 = 0;
                        while (i3 < BorderPropertyDescriptor.this.toggleProviders.length) {
                            BorderInfomation information = new BorderInfomation();
                            information.setPosition(BorderPropertyDescriptor.this.toggleProviders[i3].getPosition());
                            if (BorderPropertyDescriptor.this.builder.getRGB() == null) {
                                information.setColor(autoColor);
                            } else {
                                information.setColor(BorderPropertyDescriptor.this.builder.getRGB());
                            }
                            information.setStyle((String)BorderPropertyDescriptor.this.styleProvider.getItems()[BorderPropertyDescriptor.this.styleCombo.getSelectionIndex()]);
                            information.setWidth((String)BorderPropertyDescriptor.this.widthProvider.getItems()[BorderPropertyDescriptor.this.widthCombo.getSelectionIndex()]);
                            BorderPropertyDescriptor.this.previewCanvas.setBorderInfomation(information);
                            BorderPropertyDescriptor.this.restoreInfo = information;
                            try {
                                BorderPropertyDescriptor.this.toggleProviders[i3].save(information);
                            }
                            catch (Exception e1) {
                                ExceptionUtil.handle((Throwable)e1);
                            }
                            ++i3;
                        }
                        ((Button)e.widget).setSelection(true);
                        stack.commit();
                    }
                }
                BorderPropertyDescriptor.this.previewCanvas.redraw();
            }
        });
        Composite previewContainer = new Composite(this.content, 0);
        data = new GridData(1808);
        previewContainer.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 1;
        layout.marginWidth = 10;
        previewContainer.setLayout((Layout)layout);
        Label previewLabel = FormWidgetFactory.getInstance().createLabel(previewContainer, 16384, this.isFormStyle);
        data = new GridData(2);
        previewLabel.setLayoutData((Object)data);
        previewLabel.setText(Messages.getString((String)"BordersPage.text.Preview"));
        this.previewCanvas = new BorderCanvas(previewContainer, 0);
        data = new GridData();
        data.widthHint = 130;
        data.heightHint = 130;
        this.previewCanvas.setLayoutData((Object)data);
        this.previewCanvas.setListener((Listener)this);
        return this.content;
    }

    public Control getControl() {
        return this.content;
    }

    public void setInput(Object input) {
        this.input = input;
        this.styleProvider.setInput(input);
        this.colorProvider.setInput(input);
        this.widthProvider.setInput(input);
        int i = 0;
        while (i < this.toggleProviders.length) {
            this.toggleProviders[i].setInput(input);
            ++i;
        }
    }

    void refreshStyle(String value) {
        this.styleCombo.setSelectedItem((Object)value);
    }

    void refreshWidth(String value) {
        this.widthCombo.setSelectedItem((Object)value);
    }

    public void refreshColor(RGB rgb) {
        if (rgb != null) {
            this.builder.setColorValue(ColorUtil.format((int)ColorUtil.formRGB((int)rgb.red, (int)rgb.green, (int)rgb.blue), (int)3));
        }
    }

    public void load() {
        int i = 0;
        while (i < this.toggleProviders.length) {
            BorderInfomation info = (BorderInfomation)this.toggleProviders[i].load();
            this.previewCanvas.setBorderInfomation(info);
            if (!info.getStyle().equals("")) {
                this.toggles[i].setSelection(true);
            } else {
                this.toggles[i].setSelection(false);
            }
            ++i;
        }
        this.previewCanvas.redraw();
        if (this.restoreInfo == null) {
            if (this.styleCombo.getSelectedItem() == null) {
                String borderStyle = this.styleProvider.load().toString();
                this.refreshStyle(borderStyle);
            }
            if (this.widthCombo.getSelectedItem() == null) {
                String borderWidth = this.widthProvider.load().toString();
                this.refreshWidth(borderWidth);
            }
            if (this.builder.getRGB() == null) {
                String borderColor = this.colorProvider.load().toString();
                this.refreshColor(borderColor);
            }
        } else {
            this.refreshStyle(this.restoreInfo.getStyle());
            this.refreshWidth(this.restoreInfo.getWidth());
            this.refreshColor(this.restoreInfo.getColor());
        }
        this.checkToggleButtons();
    }

    public void refreshColor(String value) {
        boolean stateFlag;
        boolean bl = stateFlag = value == null == this.builder.getEnabled();
        if (stateFlag) {
            this.builder.setEnabled(value != null);
        }
        this.builder.setColorValue(value);
    }

    public void save(Object obj) throws SemanticException {
    }

    public void setStyleProvider(IDescriptorProvider provider) {
        if (provider instanceof BorderStyleDescriptorProvider) {
            this.styleProvider = (BorderStyleDescriptorProvider)provider;
        }
    }

    public void setColorProvider(IDescriptorProvider provider) {
        if (provider instanceof BorderColorDescriptorProvider) {
            this.colorProvider = (BorderColorDescriptorProvider)provider;
        }
    }

    public void setWidthProvider(IDescriptorProvider provider) {
        if (provider instanceof BorderWidthDescriptorProvider) {
            this.widthProvider = (BorderWidthDescriptorProvider)provider;
        }
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.content, isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.content.setVisible(isVisible);
    }

    public IToggleDescriptorProvider[] getToggleProviders() {
        return this.toggleProviders;
    }

    public void setToggleProviders(BorderToggleDescriptorProvider[] toggleProviders) {
        this.toggleProviders = toggleProviders;
    }

    private void checkToggleButtons() {
        boolean allSelected = true;
        int i = 0;
        while (i < this.toggles.length) {
            if (!this.toggles[i].getSelection()) {
                allSelected = false;
                break;
            }
            ++i;
        }
        if (allSelected) {
            this.allButton.setSelection(true);
        } else {
            this.allButton.setSelection(false);
        }
    }

    public void addElementEvent(DesignElementHandle focus, NotificationEvent ev) {
    }

    public void clear() {
    }

    public boolean isOverdued() {
        return this.content == null || this.content.isDisposed();
    }

    public void postElementEvent() {
        this.load();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    private void handleBorderSelection(BorderToggleDescriptorProvider provider) {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(Messages.getString((String)"BordersPage.Trans.SelectBorder"));
        BorderInfomation information = new BorderInfomation();
        information.setPosition(provider.getPosition());
        information.setColor(this.builder.getRGB());
        information.setStyle((String)this.styleProvider.getItems()[this.styleCombo.getSelectionIndex()]);
        information.setWidth((String)this.widthProvider.getItems()[this.widthCombo.getSelectionIndex()]);
        this.previewCanvas.setBorderInfomation(information);
        this.restoreInfo = information;
        try {
            provider.save(information);
        }
        catch (Exception e1) {
            ExceptionUtil.handle((Throwable)e1);
        }
        this.checkToggleButtons();
        stack.commit();
    }

    private void handleBorderDeselection(BorderToggleDescriptorProvider provider, Button button) {
        BorderInfomation oldInfo = (BorderInfomation)provider.load();
        RGB oldColor = oldInfo.getColor();
        RGB selectedColor = this.builder.getRGB();
        if (oldColor == null) {
            oldColor = autoColor;
        }
        if (selectedColor == null) {
            selectedColor = autoColor;
        }
        if (!(oldInfo.getStyle().equals((String)this.styleProvider.getItems()[this.styleCombo.getSelectionIndex()]) && oldColor.equals((Object)selectedColor) && oldInfo.getWidth().equals((String)this.widthProvider.getItems()[this.widthCombo.getSelectionIndex()]))) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(Messages.getString((String)"BordersPage.Trans.SelectBorder"));
            BorderInfomation information = new BorderInfomation();
            information.setPosition(provider.getPosition());
            information.setColor(selectedColor);
            information.setStyle((String)this.styleProvider.getItems()[this.styleCombo.getSelectionIndex()]);
            information.setWidth((String)this.widthProvider.getItems()[this.widthCombo.getSelectionIndex()]);
            this.previewCanvas.setBorderInfomation(information);
            this.restoreInfo = information;
            try {
                provider.save(information);
            }
            catch (Exception e1) {
                ExceptionUtil.handle((Throwable)e1);
            }
            button.setSelection(true);
            stack.commit();
        } else {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(Messages.getString((String)"BordersPage.Trans.UnSelectBorder"));
            this.previewCanvas.removeBorderInfomation(provider.getPosition());
            if (this.allButton.getSelection()) {
                this.allButton.setSelection(false);
            }
            try {
                provider.reset();
            }
            catch (Exception e1) {
                ExceptionUtil.handle((Throwable)e1);
            }
            stack.commit();
        }
    }

    public void handleEvent(Event event) {
        String property = null;
        switch (event.detail) {
            case 128: {
                property = "borderTopStyle";
                break;
            }
            case 1024: {
                property = "borderBottomStyle";
                break;
            }
            case 16384: {
                property = "borderLeftStyle";
                break;
            }
            case 131072: {
                property = "borderRightStyle";
            }
        }
        int i = 0;
        while (i < this.toggleProviders.length) {
            if (this.toggleProviders[i].getProperty().equals(property)) {
                BorderToggleDescriptorProvider provider = this.toggleProviders[i];
                int j = 0;
                while (j < this.toggles.length) {
                    if (this.toggles[j].getData() != null && this.toggles[j].getData() == provider) {
                        Button button = this.toggles[j];
                        if (button.getSelection()) {
                            button.setSelection(false);
                            this.handleBorderDeselection(provider, button);
                        } else {
                            button.setSelection(true);
                            this.handleBorderSelection(provider);
                        }
                        this.previewCanvas.redraw();
                        return;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void reset() {
        int i = 0;
        while (i < this.toggleProviders.length) {
            if (this.toggleProviders[i] != null && this.toggleProviders[i].canReset()) {
                try {
                    this.toggleProviders[i].reset();
                }
                catch (Exception e1) {
                    ExceptionUtil.handle((Throwable)e1);
                }
            }
            ++i;
        }
    }
}

