/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FontSizePropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FontSizeBuilder;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FontSizePropertyDescriptor
extends PropertyDescriptor {
    private FontSizeBuilder builder;
    private String oldValue;

    public FontSizePropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    void refresh(String value) {
        boolean stateFlag;
        String strValue = this.getDescriptorProvider().load().toString();
        boolean bl = stateFlag = strValue == null == this.builder.getEnabled();
        if (stateFlag) {
            this.builder.setEnabled(strValue != null);
        }
        if (this.getDescriptorProvider() instanceof FontSizePropertyDescriptorProvider && ((FontSizePropertyDescriptorProvider)this.getDescriptorProvider()).isReadOnly()) {
            this.builder.setEnabled(false);
        }
        this.builder.setFontSizeValue(strValue);
    }

    public Control getControl() {
        return this.builder;
    }

    public Control createControl(Composite parent) {
        this.builder = new FontSizeBuilder(parent, 0, this.isFormStyle());
        this.builder.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FontSizePropertyDescriptor.this.handleBuilderModifyEvent();
            }
        });
        return this.builder;
    }

    private void handleBuilderModifyEvent() {
        if (this.getDescriptorProvider() instanceof FontSizePropertyDescriptorProvider) {
            this.builder.setDefaultUnit(((FontSizePropertyDescriptorProvider)this.getDescriptorProvider()).getDefaultUnit());
        }
        String oldValue = this.getDescriptorProvider().load().toString();
        String sizeValue = this.builder.getFontSizeValue();
        try {
            this.save(sizeValue);
        }
        catch (SemanticException e) {
            WidgetUtil.processError(this.builder.getShell(), (Exception)((Object)e));
            this.builder.setFontSizeValue(oldValue);
            return;
        }
    }

    public void save(Object value) throws SemanticException {
        this.descriptorProvider.save(value);
    }

    public String getFontSizeValue() {
        return this.builder.getFontSizeValue();
    }

    public void setFontSizeValue(String value) {
        this.builder.setFontSizeValue(value);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.builder, isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.builder.setVisible(isVisible);
    }

    public void load() {
        this.oldValue = this.getDescriptorProvider().load().toString();
        this.refresh(this.oldValue);
    }

    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }
}

