/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.outline.EmbeddedImageNode;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertEmbeddedImageAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.gef.Request;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;

public class EmbeddedImageNodeProvider
extends DefaultNodeProvider {
    public String getIconName(Object model) {
        assert (model instanceof EmbeddedImageHandle);
        EmbeddedImageHandle image = (EmbeddedImageHandle)model;
        if (image.isLibReference()) {
            return "Image_LINK";
        }
        return "Image";
    }

    public String getNodeDisplayName(Object model) {
        return ((EmbeddedImageHandle)model).getQualifiedName();
    }

    public Object getParent(Object model) {
        return new EmbeddedImageNode(SessionHandleAdapter.getInstance().getReportDesignHandle());
    }

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        menu.add((IAction)new InsertEmbeddedImageAction(object, Messages.getString((String)"EmbeddedImageNodeProvider.action.New")));
        super.createContextMenu(sourceViewer, object, menu);
    }

    public boolean performRequest(Object model, Request request) throws Exception {
        if (request.getType().equals("insert")) {
            return ProviderFactory.createProvider((Object)this.getParent(model)).performRequest(model, request);
        }
        return false;
    }
}

