/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import java.util.Map;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.TreeViewer;

public class RowProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        menu.add((IAction)new InsertAction(object, Messages.getString((String)"RowProvider.action.text.above"), "Row", "above"));
        menu.add((IAction)new InsertAction(object, Messages.getString((String)"RowProvider.action.text.below"), "Row", "below"));
        super.createContextMenu(sourceViewer, object, menu);
    }

    public Object[] getChildren(Object model) {
        RowHandle tableRow = (RowHandle)model;
        return this.getChildrenBySlotHandle(tableRow.getCells());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean performInsert(Object model, SlotHandle slotHandle, String type, String position, Map extendedData) throws Exception {
        Assert.isLegal((boolean)"Row".equals(type));
        TableHandleAdapter adapter = HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getRoot(model));
        if (position != "current") {
            int rowNumber = HandleAdapterFactory.getInstance().getRowHandleAdapter(model).getRowNumber();
            if (position == "above") {
                adapter.insertRow(-1, rowNumber);
                return true;
            } else {
                if (position != "below") return false;
                adapter.insertRow(1, rowNumber);
            }
            return true;
        } else {
            adapter.insertRowInSlotHandle(slotHandle.getSlotID());
        }
        return true;
    }

    protected boolean performDelete(DesignElementHandle handle) throws SemanticException {
        int rowNumber = HandleAdapterFactory.getInstance().getRowHandleAdapter((Object)handle).getRowNumber();
        TableHandleAdapter adapter = HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getRoot(handle));
        adapter.deleteRow(rowNumber);
        return true;
    }

    private Object getRoot(Object model) {
        DesignElementHandle handle = ((DesignElementHandle)model).getContainer();
        if (handle instanceof GroupHandle) {
            return this.getRoot(handle);
        }
        return handle;
    }
}

