/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.BubbleSeries;
import org.eclipse.birt.chart.model.type.impl.BubbleSeriesImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class BubbleSeriesAttributeComposite
extends Composite
implements SelectionListener,
Listener {
    private transient Button btnCurve = null;
    private transient Button btnPalette = null;
    private transient FillChooserComposite fccShadow = null;
    private transient Group grpLine = null;
    private transient LineAttributesComposite liacLine = null;
    private transient Group grpAccLine = null;
    private transient LineAttributesComposite liacAccLine = null;
    private transient Label lblOrientation = null;
    private transient Combo cmbOrientation;
    private transient Series series = null;
    private transient Label lblShadow = null;
    ChartWizardContext context;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public BubbleSeriesAttributeComposite(Composite parent, int style, ChartWizardContext context, Series series) {
        super(parent, style);
        if (!(series instanceof BubbleSeriesImpl)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 30, "BubbleSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = series;
        this.context = context;
        this.init();
        this.placeComponents();
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatBubbleChartYSeries_ID");
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout(3, true);
        glContent.marginHeight = 2;
        glContent.marginWidth = 2;
        this.setLayout((Layout)glContent);
        this.grpAccLine = new Group((Composite)this, 0);
        GridData gdGRPAccLine = new GridData(768);
        GridLayout glGRPAccline = new GridLayout(2, false);
        glGRPAccline.verticalSpacing = 0;
        this.grpAccLine.setLayout((Layout)glGRPAccline);
        this.grpAccLine.setLayoutData((Object)gdGRPAccLine);
        this.grpAccLine.setText(Messages.getString("BubbleSeriesAttributeComposite.Lbl.AccLine"));
        this.liacAccLine = new LineAttributesComposite((Composite)this.grpAccLine, 0, this.context, ((BubbleSeries)this.series).getAccLineAttributes(), true, true, true);
        GridData gdLIACAccLine = new GridData(1808);
        gdLIACAccLine.horizontalSpan = 2;
        this.liacAccLine.setLayoutData(gdLIACAccLine);
        this.liacAccLine.addListener(this);
        Composite cmpOrientation = new Composite((Composite)this.grpAccLine, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginBottom = 0;
        gl.verticalSpacing = 0;
        cmpOrientation.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        cmpOrientation.setLayoutData((Object)gd);
        this.lblOrientation = new Label(cmpOrientation, 0);
        this.lblOrientation.setText(Messages.getString("BubbleSeriesAttributeComposite.Lbl.Orientation"));
        this.cmbOrientation = new Combo(cmpOrientation, 12);
        GridData gdCMBOrientation = new GridData(768);
        this.cmbOrientation.setLayoutData((Object)gdCMBOrientation);
        this.cmbOrientation.addSelectionListener((SelectionListener)this);
        this.grpLine = new Group((Composite)this, 0);
        GridData gdGRPLine = new GridData(768);
        gdGRPLine.horizontalSpan = 2;
        this.grpLine.setLayoutData((Object)gdGRPLine);
        GridLayout glLine = new GridLayout(2, false);
        glLine.horizontalSpacing = 0;
        this.grpLine.setLayout((Layout)glLine);
        this.grpLine.setText(Messages.getString("BubbleSeriesAttributeComposite.Lbl.Line"));
        Composite cmpLine = new Composite((Composite)this.grpLine, 0);
        GridLayout gl2 = new GridLayout(2, false);
        gl2.marginHeight = 0;
        gl2.marginWidth = 0;
        gl2.horizontalSpacing = 0;
        gl2.verticalSpacing = 0;
        cmpLine.setLayout((Layout)gl2);
        cmpLine.setLayoutData((Object)new GridData(1808));
        this.liacLine = new LineAttributesComposite(cmpLine, 0, this.context, ((BubbleSeries)this.series).getLineAttributes(), true, true, true);
        GridData gdLIACLine = new GridData(768);
        gdLIACLine.horizontalSpan = 2;
        this.liacLine.setLayoutData(gdLIACLine);
        this.liacLine.addListener(this);
        Composite cmpShadow = new Composite(cmpLine, 0);
        GridLayout gl3 = new GridLayout(2, false);
        gl3.marginHeight = 0;
        gl3.marginBottom = 0;
        gl3.verticalSpacing = 0;
        cmpShadow.setLayout((Layout)gl3);
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 2;
        cmpShadow.setLayoutData((Object)gd2);
        this.lblShadow = new Label(cmpShadow, 0);
        this.lblShadow.setText(Messages.getString("BubbleSeriesAttributeComposite.Lbl.ShadowColor"));
        this.fccShadow = new FillChooserComposite(cmpShadow, 0, this.context, (Fill)((BubbleSeries)this.series).getShadowColor(), false, false);
        GridData gdFCCShadow = new GridData(768);
        this.fccShadow.setLayoutData(gdFCCShadow);
        this.fccShadow.addListener(this);
        Composite cmp = new Composite((Composite)this.grpLine, 0);
        cmp.setLayout((Layout)new GridLayout());
        this.btnPalette = new Button(cmp, 32);
        this.btnPalette.setText(Messages.getString("BubbleSeriesAttributeComposite.Lbl.LinePalette"));
        this.btnPalette.setSelection(((BubbleSeries)this.series).isPaletteLineColor());
        this.btnPalette.addSelectionListener((SelectionListener)this);
        this.btnCurve = new Button(cmp, 32);
        this.btnCurve.setText(Messages.getString("BubbleSeriesAttributeComposite.Lbl.ShowLinesAsCurves"));
        this.btnCurve.setSelection(((BubbleSeries)this.series).isCurve());
        this.btnCurve.addSelectionListener((SelectionListener)this);
        this.enableLineSettings(((BubbleSeries)this.series).getLineAttributes().isVisible());
        this.enableAccLineSettings(((BubbleSeries)this.series).getAccLineAttributes().isVisible());
        this.populateLists();
    }

    private void populateLists() {
        NameSet ns = LiteralHelper.orientationSet;
        this.cmbOrientation.setItems(ns.getDisplayNames());
        this.cmbOrientation.select(ns.getSafeNameIndex(((BubbleSeries)this.series).getAccOrientation().getName()));
    }

    public Point getPreferredSize() {
        return new Point(400, 200);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnCurve)) {
            ((BubbleSeries)this.series).setCurve(this.btnCurve.getSelection());
        } else if (e.getSource().equals(this.btnPalette)) {
            ((BubbleSeries)this.series).setPaletteLineColor(this.btnPalette.getSelection());
        } else if (e.getSource().equals(this.cmbOrientation)) {
            ((BubbleSeries)this.series).setAccOrientation(Orientation.getByName((String)LiteralHelper.orientationSet.getNameByDisplayName(this.cmbOrientation.getText())));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.liacLine)) {
            if (event.type == 4) {
                ((BubbleSeries)this.series).getLineAttributes().setVisible(((Boolean)event.data).booleanValue());
                this.enableLineSettings(((BubbleSeries)this.series).getLineAttributes().isVisible());
            } else if (event.type == 1) {
                ((BubbleSeries)this.series).getLineAttributes().setStyle((LineStyle)event.data);
            } else if (event.type == 2) {
                ((BubbleSeries)this.series).getLineAttributes().setThickness(((Integer)event.data).intValue());
            } else if (event.type == 3) {
                ((BubbleSeries)this.series).getLineAttributes().setColor((ColorDefinition)event.data);
            }
        } else if (event.widget.equals((Object)this.liacAccLine)) {
            if (event.type == 4) {
                ((BubbleSeries)this.series).getAccLineAttributes().setVisible(((Boolean)event.data).booleanValue());
                this.enableAccLineSettings(((BubbleSeries)this.series).getAccLineAttributes().isVisible());
            } else if (event.type == 1) {
                ((BubbleSeries)this.series).getAccLineAttributes().setStyle((LineStyle)event.data);
            } else if (event.type == 2) {
                ((BubbleSeries)this.series).getAccLineAttributes().setThickness(((Integer)event.data).intValue());
            } else if (event.type == 3) {
                ((BubbleSeries)this.series).getAccLineAttributes().setColor((ColorDefinition)event.data);
            }
        } else if (event.widget.equals((Object)this.fccShadow)) {
            ((BubbleSeries)this.series).setShadowColor((ColorDefinition)event.data);
        }
    }

    private void enableLineSettings(boolean isEnabled) {
        if (this.lblShadow != null) {
            this.lblShadow.setEnabled(isEnabled);
        }
        if (this.fccShadow != null) {
            this.fccShadow.setEnabled(isEnabled);
        }
        if (this.btnPalette != null) {
            this.btnPalette.setEnabled(isEnabled);
        }
        this.btnCurve.setEnabled(isEnabled);
    }

    private void enableAccLineSettings(boolean isEnabled) {
        if (this.cmbOrientation != null) {
            this.cmbOrientation.setEnabled(isEnabled);
        }
        if (this.lblOrientation != null) {
            this.lblOrientation.setEnabled(isEnabled);
        }
    }
}

