/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.impl.Angle3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.Rotation3DImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.AxisImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.DefaultChartSubTypeImpl;
import org.eclipse.birt.chart.ui.swt.DefaultChartTypeImpl;
import org.eclipse.birt.chart.ui.swt.HelpContentImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IHelpContent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.DefaultBaseSeriesComponent;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineChart
extends DefaultChartTypeImpl {
    public static final String TYPE_LITERAL = "Line Chart";
    protected static final String STACKED_SUBTYPE_LITERAL = "Stacked";
    protected static final String PERCENTSTACKED_SUBTYPE_LITERAL = "Percent Stacked";
    protected static final String OVERLAY_SUBTYPE_LITERAL = "Overlay";

    public LineChart() {
        this.chartTitle = Messages.getString("LineChart.Txt.DefaultLineChartTitle");
    }

    public String getName() {
        return TYPE_LITERAL;
    }

    public Image getImage() {
        return UIHelper.getImage((String)"icons/obj16/linecharticon.gif");
    }

    protected Image getImageForSubtype(String sDimension, Orientation orientation, String subtype) {
        String imagePath = null;
        if (sDimension.equals(TWO_DIMENSION_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            if (subtype.equals(OVERLAY_SUBTYPE_LITERAL)) {
                imagePath = orientation == Orientation.VERTICAL_LITERAL ? "icons/wizban/sidebysidelinechartimage.gif" : "icons/wizban/horizontalsidebysidelinechartimage.gif";
            } else if (subtype.equals(STACKED_SUBTYPE_LITERAL)) {
                imagePath = orientation == Orientation.VERTICAL_LITERAL ? "icons/wizban/stackedlinechartimage.gif" : "icons/wizban/horizontalstackedlinechartimage.gif";
            } else if (subtype.equals(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                imagePath = orientation == Orientation.VERTICAL_LITERAL ? "icons/wizban/percentstackedlinechartimage.gif" : "icons/wizban/horizontalpercentstackedlinechartimage.gif";
            }
        } else if (sDimension.equals(THREE_DIMENSION_TYPE) || sDimension.equals(ChartDimension.THREE_DIMENSIONAL_LITERAL.getName())) {
            imagePath = "icons/wizban/sidebysidelinechart3dimage.gif";
        }
        if (imagePath != null) {
            return UIHelper.getImage((String)imagePath);
        }
        return null;
    }

    protected String getDescriptionForSubtype(String subtypeLiteral) {
        if (OVERLAY_SUBTYPE_LITERAL.equals(subtypeLiteral)) {
            return Messages.getString("LineChart.Txt.OverlayDescription");
        }
        if (STACKED_SUBTYPE_LITERAL.equals(subtypeLiteral)) {
            return Messages.getString("LineChart.Txt.StackedDescription");
        }
        if (PERCENTSTACKED_SUBTYPE_LITERAL.equals(subtypeLiteral)) {
            return Messages.getString("LineChart.Txt.PercentStackedDescription");
        }
        return null;
    }

    public IHelpContent getHelp() {
        return new HelpContentImpl(TYPE_LITERAL, Messages.getString("LineChart.Txt.HelpText"));
    }

    public Collection<IChartSubType> getChartSubtypes(String sDimension, Orientation orientation) {
        Vector<IChartSubType> vSubTypes = new Vector<IChartSubType>();
        if (sDimension.equals(TWO_DIMENSION_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(OVERLAY_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension, orientation, OVERLAY_SUBTYPE_LITERAL), this.getDescriptionForSubtype(OVERLAY_SUBTYPE_LITERAL), Messages.getString("LineChart.SubType.Overlay")));
            if (this.isStackedSupported()) {
                vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(STACKED_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension, orientation, STACKED_SUBTYPE_LITERAL), this.getDescriptionForSubtype(STACKED_SUBTYPE_LITERAL), Messages.getString("LineChart.SubType.Stacked")));
            }
            if (this.isPercentStackedSupported()) {
                vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(PERCENTSTACKED_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension, orientation, PERCENTSTACKED_SUBTYPE_LITERAL), this.getDescriptionForSubtype(PERCENTSTACKED_SUBTYPE_LITERAL), Messages.getString("LineChart.SubType.PercentStacked")));
            }
        } else if (sDimension.equals(THREE_DIMENSION_TYPE) || sDimension.equals(ChartDimension.THREE_DIMENSIONAL_LITERAL.getName())) {
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(OVERLAY_SUBTYPE_LITERAL, this.getImageForSubtype(sDimension, orientation, OVERLAY_SUBTYPE_LITERAL), this.getDescriptionForSubtype(OVERLAY_SUBTYPE_LITERAL), Messages.getString("LineChart.SubType.Overlay")));
        }
        return vSubTypes;
    }

    public Chart getModel(String sSubType, Orientation orientation, String sDimension, Chart currentChart) {
        Series valueSeries;
        SeriesDefinition sdY;
        ChartWithAxes newChart = null;
        if (currentChart != null && (newChart = (ChartWithAxes)this.getConvertedChart(currentChart, sSubType, orientation, sDimension)) != null) {
            return newChart;
        }
        newChart = ChartWithAxesImpl.create();
        newChart.setType(TYPE_LITERAL);
        newChart.setSubType(sSubType);
        newChart.setOrientation(orientation);
        newChart.setDimension(ChartUIUtil.getDimensionType((String)sDimension));
        newChart.setUnits("Points");
        ((Axis)newChart.getAxes().get(0)).setOrientation(Orientation.HORIZONTAL_LITERAL);
        ((Axis)newChart.getAxes().get(0)).setType(AxisType.TEXT_LITERAL);
        ((Axis)newChart.getAxes().get(0)).setCategoryAxis(true);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        Series categorySeries = SeriesImpl.create();
        sdX.getSeries().add((Object)categorySeries);
        sdX.getSeriesPalette().shift(0);
        ((Axis)newChart.getAxes().get(0)).getSeriesDefinitions().add((Object)sdX);
        newChart.getTitle().getLabel().getCaption().setValue(this.getDefaultTitle());
        if (sSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL)) {
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
            sdY = SeriesDefinitionImpl.create();
            sdY.getSeriesPalette().shift(0);
            valueSeries = this.getSeries();
            valueSeries.setStacked(true);
            sdY.getSeries().add((Object)valueSeries);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().add((Object)sdY);
        } else if (sSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setPercent(true);
            sdY = SeriesDefinitionImpl.create();
            sdY.getSeriesPalette().shift(0);
            valueSeries = this.getSeries();
            valueSeries.setStacked(true);
            sdY.getSeries().add((Object)valueSeries);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().add((Object)sdY);
        } else if (sSubType.equalsIgnoreCase(OVERLAY_SUBTYPE_LITERAL)) {
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
            sdY = SeriesDefinitionImpl.create();
            sdY.getSeriesPalette().shift(0);
            valueSeries = this.getSeries();
            valueSeries.setStacked(false);
            sdY.getSeries().add((Object)valueSeries);
            ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().add((Object)sdY);
        }
        if (sDimension.equals(THREE_DIMENSION_TYPE)) {
            newChart.setRotation(Rotation3DImpl.create((Angle3D[])new Angle3D[]{Angle3DImpl.create((double)-20.0, (double)45.0, (double)0.0)}));
            newChart.setUnitSpacing(50.0);
            newChart.getPrimaryBaseAxes()[0].getAncillaryAxes().clear();
            Axis zAxisAncillary = AxisImpl.create((int)3);
            zAxisAncillary.setTitlePosition(Position.BELOW_LITERAL);
            zAxisAncillary.getTitle().getCaption().setValue(Messages.getString("ChartWithAxesImpl.Z_Axis.title"));
            zAxisAncillary.getTitle().setVisible(true);
            zAxisAncillary.setPrimaryAxis(true);
            zAxisAncillary.setLabelPosition(Position.BELOW_LITERAL);
            zAxisAncillary.setOrientation(Orientation.HORIZONTAL_LITERAL);
            zAxisAncillary.getOrigin().setType(IntersectionType.MIN_LITERAL);
            zAxisAncillary.getOrigin().setValue((DataElement)NumberDataElementImpl.create((double)0.0));
            zAxisAncillary.getTitle().setVisible(false);
            zAxisAncillary.setType(AxisType.TEXT_LITERAL);
            newChart.getPrimaryBaseAxes()[0].getAncillaryAxes().add((Object)zAxisAncillary);
            newChart.getPrimaryOrthogonalAxis(newChart.getPrimaryBaseAxes()[0]).getTitle().getCaption().getFont().setRotation(0.0);
            SeriesDefinition sdZ = SeriesDefinitionImpl.create();
            sdZ.getSeriesPalette().shift(0);
            sdZ.getSeries().add((Object)SeriesImpl.create());
            zAxisAncillary.getSeriesDefinitions().add((Object)sdZ);
        }
        this.addSampleData((Chart)newChart);
        return newChart;
    }

    private void addSampleData(Chart newChart) {
        SampleData sd = DataFactory.eINSTANCE.createSampleData();
        sd.getBaseSampleData().clear();
        sd.getOrthogonalSampleData().clear();
        BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
        sdBase.setDataSetRepresentation("A, B, C");
        sd.getBaseSampleData().add((Object)sdBase);
        OrthogonalSampleData oSample = DataFactory.eINSTANCE.createOrthogonalSampleData();
        oSample.setDataSetRepresentation("5,-4,12");
        oSample.setSeriesDefinitionIndex(0);
        sd.getOrthogonalSampleData().add((Object)oSample);
        if (newChart.getDimension() == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            BaseSampleData sdAncillary = DataFactory.eINSTANCE.createBaseSampleData();
            sdAncillary.setDataSetRepresentation("Series 1");
            sd.getAncillarySampleData().add((Object)sdAncillary);
        }
        newChart.setSampleData(sd);
    }

    private Chart getConvertedChart(Chart currentChart, String sNewSubType, Orientation newOrientation, String sNewDimension) {
        Text title;
        Chart helperModel = currentChart.copyInstance();
        helperModel.eAdapters().addAll((Collection)currentChart.eAdapters());
        ChartDimension oldDimension = currentChart.getDimension();
        ChartCacheManager.getInstance().cacheSeries(ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)helperModel));
        IChartType oldType = ChartUIUtil.getChartType((String)currentChart.getType());
        if (currentChart instanceof ChartWithAxes) {
            if (currentChart.getType().equals(TYPE_LITERAL)) {
                currentChart.setSubType(sNewSubType);
                EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                int i = 0;
                int seriesIndex = 0;
                while (i < axes.size()) {
                    if (sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                        if (!ChartPreviewPainter.isLivePreviewActive() && !this.isNumbericAxis((Axis)axes.get(i))) {
                            ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                        }
                        ((Axis)axes.get(i)).setPercent(true);
                    } else {
                        ((Axis)axes.get(i)).setPercent(false);
                    }
                    EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                    Series firstSeries = ((SeriesDefinition)seriesdefinitions.get(0)).getDesignTimeSeries();
                    int j = 0;
                    while (j < seriesdefinitions.size()) {
                        Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                        if (sNewSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL) || sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                            if (j != 0) {
                                series = this.getConvertedSeriesAsFirst(series, seriesIndex, firstSeries);
                            }
                            ++seriesIndex;
                            if (!ChartPreviewPainter.isLivePreviewActive() && !this.isNumbericAxis((Axis)axes.get(i))) {
                                ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                            }
                            if (series.canBeStacked()) {
                                series.setStacked(true);
                            }
                            ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                            ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                        } else {
                            series.setStacked(false);
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                currentChart.setType(TYPE_LITERAL);
                currentChart.setSubType(sNewSubType);
                title = currentChart.getTitle().getLabel().getCaption();
                if (title.getValue() == null || title.getValue().trim().length() == 0 || title.getValue().trim().equals(oldType.getDefaultTitle().trim())) {
                    title.setValue(this.getDefaultTitle());
                }
                ArrayList<AxisType> axisTypes = new ArrayList<AxisType>();
                EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                int i = 0;
                int seriesIndex = 0;
                while (i < axes.size()) {
                    if (!ChartPreviewPainter.isLivePreviewActive() && !this.isNumbericAxis((Axis)axes.get(i))) {
                        ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                    }
                    ((Axis)axes.get(i)).setPercent(sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL));
                    EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                    int j = 0;
                    while (j < seriesdefinitions.size()) {
                        Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                        series = this.getConvertedSeries(series, seriesIndex++);
                        ((LineSeries)series).setPaletteLineColor(true);
                        if (!ChartPreviewPainter.isLivePreviewActive() && !this.isNumbericAxis((Axis)axes.get(i))) {
                            ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                        }
                        boolean isStacked = sNewSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL) || sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL);
                        series.setStacked(isStacked);
                        ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                        ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                        axisTypes.add(((Axis)axes.get(i)).getType());
                        ++j;
                    }
                    ++i;
                }
                currentChart.setSampleData(this.getConvertedSampleData(currentChart.getSampleData(), ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getType(), axisTypes));
            }
        } else {
            currentChart = ChartWithAxesImpl.create();
            currentChart.eAdapters().addAll((Collection)helperModel.eAdapters());
            currentChart.setType(TYPE_LITERAL);
            currentChart.setSubType(sNewSubType);
            ((ChartWithAxes)currentChart).setOrientation(newOrientation);
            currentChart.setDimension(ChartUIUtil.getDimensionType((String)sNewDimension));
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setOrientation(Orientation.HORIZONTAL_LITERAL);
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setType(AxisType.TEXT_LITERAL);
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setCategoryAxis(true);
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
            currentChart.setBlock(helperModel.getBlock());
            currentChart.setDescription(helperModel.getDescription());
            currentChart.setGridColumnCount(helperModel.getGridColumnCount());
            currentChart.setSampleData(helperModel.getSampleData());
            currentChart.setScript(helperModel.getScript());
            currentChart.setSeriesThickness(helperModel.getSeriesThickness());
            currentChart.setUnits(helperModel.getUnits());
            if (helperModel.getInteractivity() != null) {
                currentChart.getInteractivity().setEnable(helperModel.getInteractivity().isEnable());
                currentChart.getInteractivity().setLegendBehavior(helperModel.getInteractivity().getLegendBehavior());
            }
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().clear();
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().add((Object)((SeriesDefinition)((ChartWithoutAxes)helperModel).getSeriesDefinitions().get(0)));
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().clear();
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().addAll((Collection)((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeriesDefinitions());
            Series series = ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getDesignTimeSeries();
            ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeries().clear();
            ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeries().add((Object)series);
            EList seriesdefinitions = ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions();
            int j = 0;
            while (j < seriesdefinitions.size()) {
                series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                series = this.getConvertedSeries(series, j);
                series.getLabel().setVisible(false);
                ((LineSeries)series).setPaletteLineColor(true);
                if (sNewSubType.equalsIgnoreCase(STACKED_SUBTYPE_LITERAL) || sNewSubType.equalsIgnoreCase(PERCENTSTACKED_SUBTYPE_LITERAL)) {
                    series.setStacked(true);
                } else {
                    series.setStacked(false);
                }
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                ++j;
            }
            currentChart.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
            title = currentChart.getTitle().getLabel().getCaption();
            if (title.getValue() == null || title.getValue().trim().length() == 0 || title.getValue().trim().equals(oldType.getDefaultTitle().trim())) {
                title.setValue(this.getDefaultTitle());
            }
        }
        if (!((ChartWithAxes)currentChart).getOrientation().equals((Object)newOrientation)) {
            ((ChartWithAxes)currentChart).setOrientation(newOrientation);
        }
        if (!currentChart.getDimension().equals((Object)ChartUIUtil.getDimensionType((String)sNewDimension))) {
            currentChart.setDimension(ChartUIUtil.getDimensionType((String)sNewDimension));
        }
        if (sNewDimension.equals(THREE_DIMENSION_TYPE) && ChartUIUtil.getDimensionType((String)sNewDimension) != oldDimension) {
            ((ChartWithAxes)currentChart).setRotation(Rotation3DImpl.create((Angle3D[])new Angle3D[]{Angle3DImpl.create((double)-20.0, (double)45.0, (double)0.0)}));
            ((ChartWithAxes)currentChart).getPrimaryBaseAxes()[0].getAncillaryAxes().clear();
            Axis zAxisAncillary = AxisImpl.create((int)3);
            zAxisAncillary.setTitlePosition(Position.BELOW_LITERAL);
            zAxisAncillary.getTitle().getCaption().setValue(Messages.getString("ChartWithAxesImpl.Z_Axis.title"));
            zAxisAncillary.getTitle().setVisible(true);
            zAxisAncillary.setPrimaryAxis(true);
            zAxisAncillary.setLabelPosition(Position.BELOW_LITERAL);
            zAxisAncillary.setOrientation(Orientation.HORIZONTAL_LITERAL);
            zAxisAncillary.getOrigin().setType(IntersectionType.MIN_LITERAL);
            zAxisAncillary.getOrigin().setValue((DataElement)NumberDataElementImpl.create((double)0.0));
            zAxisAncillary.getTitle().setVisible(false);
            zAxisAncillary.setType(AxisType.TEXT_LITERAL);
            ((ChartWithAxes)currentChart).getPrimaryBaseAxes()[0].getAncillaryAxes().add((Object)zAxisAncillary);
            SeriesDefinition sdZ = SeriesDefinitionImpl.create();
            sdZ.getSeriesPalette().shift(0);
            sdZ.getSeries().add((Object)SeriesImpl.create());
            zAxisAncillary.getSeriesDefinitions().add((Object)sdZ);
            if (currentChart.getSampleData().getAncillarySampleData().isEmpty()) {
                BaseSampleData sdAncillary = DataFactory.eINSTANCE.createBaseSampleData();
                sdAncillary.setDataSetRepresentation("Series 1");
                currentChart.getSampleData().getAncillarySampleData().add((Object)sdAncillary);
            }
            EList seriesdefinitions = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)currentChart, (int)0);
            int j = 0;
            while (j < seriesdefinitions.size()) {
                Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                series.setStacked(false);
                ++j;
            }
        }
        ChartUIUtil.restoreLabelPositionFromCache((Chart)currentChart);
        return currentChart;
    }

    private boolean isNumbericAxis(Axis axis) {
        return axis.getType().getValue() == 0 || axis.getType().getValue() == 1;
    }

    private Series getConvertedSeries(Series series, int seriesIndex) {
        if (series.getClass().getName().equals(SeriesImpl.class.getName())) {
            return series;
        }
        LineSeries lineseries = (LineSeries)ChartCacheManager.getInstance().findSeries(LineSeriesImpl.class.getName(), seriesIndex);
        if (lineseries == null) {
            lineseries = (LineSeries)LineSeriesImpl.create();
        }
        ChartUIUtil.copyGeneralSeriesAttributes((Series)series, (Series)lineseries);
        return lineseries;
    }

    private SampleData getConvertedSampleData(SampleData currentSampleData, AxisType xAxisType, ArrayList axisTypes) {
        EList bsdList = currentSampleData.getBaseSampleData();
        Vector vNewBaseSampleData = this.getConvertedBaseSampleDataRepresentation(bsdList, xAxisType);
        currentSampleData.getBaseSampleData().clear();
        currentSampleData.getBaseSampleData().addAll((Collection)vNewBaseSampleData);
        EList osdList = currentSampleData.getOrthogonalSampleData();
        Vector vNewOrthogonalSampleData = this.getConvertedOrthogonalSampleDataRepresentation(osdList, axisTypes);
        currentSampleData.getOrthogonalSampleData().clear();
        currentSampleData.getOrthogonalSampleData().addAll((Collection)vNewOrthogonalSampleData);
        return currentSampleData;
    }

    private Vector getConvertedBaseSampleDataRepresentation(EList bsdList, AxisType xAxisType) {
        Vector<BaseSampleData> vNewBaseSampleData = new Vector<BaseSampleData>();
        int i = 0;
        while (i < bsdList.size()) {
            BaseSampleData bsd = (BaseSampleData)bsdList.get(i);
            bsd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)xAxisType, (String)bsd.getDataSetRepresentation(), (int)i));
            vNewBaseSampleData.add(bsd);
            ++i;
        }
        return vNewBaseSampleData;
    }

    private Vector getConvertedOrthogonalSampleDataRepresentation(EList osdList, ArrayList axisTypes) {
        Vector<OrthogonalSampleData> vNewOrthogonalSampleData = new Vector<OrthogonalSampleData>();
        int i = 0;
        while (i < osdList.size()) {
            OrthogonalSampleData osd = (OrthogonalSampleData)osdList.get(i);
            osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)((AxisType)axisTypes.get(i)), (String)osd.getDataSetRepresentation(), (int)i));
            vNewOrthogonalSampleData.add(osd);
            ++i;
        }
        return vNewOrthogonalSampleData;
    }

    public String[] getSupportedDimensions() {
        return new String[]{TWO_DIMENSION_TYPE, THREE_DIMENSION_TYPE};
    }

    public String getDefaultDimension() {
        return TWO_DIMENSION_TYPE;
    }

    public boolean supportsTransposition() {
        return true;
    }

    public boolean supportsTransposition(String dimension) {
        if (ChartUIUtil.getDimensionType((String)dimension) == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            return false;
        }
        return this.supportsTransposition();
    }

    public ISelectDataComponent getBaseUI(Chart chart, ISelectDataCustomizeUI selectDataUI, ChartWizardContext context, String sTitle) {
        return new DefaultBaseSeriesComponent((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)chart).get(0), context, sTitle);
    }

    public String getDisplayName() {
        return Messages.getString("LineChart.Txt.DisplayName");
    }

    public Series getSeries() {
        LineSeries series = (LineSeries)LineSeriesImpl.create();
        ((Marker)series.getMarkers().get(0)).setVisible(true);
        series.setPaletteLineColor(true);
        return series;
    }

    public boolean canCombine() {
        return true;
    }

    protected boolean isStackedSupported() {
        return true;
    }

    protected boolean isPercentStackedSupported() {
        return true;
    }
}

