/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.postscript.device;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.eclipse.birt.report.engine.emitter.postscript.PostscriptWriter;
import org.eclipse.birt.report.engine.layout.emitter.AbstractPage;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;

public class PostscriptPage
extends AbstractPage {
    private PostscriptWriter writer;
    private boolean isDisposed;

    public PostscriptPage(int pageWidth, int pageHeight, Color color, PostscriptWriter writer) {
        super(pageWidth, pageHeight);
        writer.startPage(this.pageWidth, this.pageHeight);
        writer.fillPage(color);
        this.writer = writer;
        this.isDisposed = false;
    }

    public void saveState() {
        this.writer.clipSave();
    }

    public void restoreState() {
        this.writer.clipRestore();
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.writer.endPage();
            this.isDisposed = true;
        }
    }

    protected void drawText(String text, float textX, float textY, float baseline, float width, float height, TextStyle fontStyle) {
        this.writer.drawString(text, textX, textY + baseline, fontStyle.getFontInfo(), this.convertToPoint(fontStyle.getLetterSpacing()), this.convertToPoint(fontStyle.getWordSpacing()), fontStyle.getColor(), fontStyle.isLinethrough(), fontStyle.isOverline(), fontStyle.isUnderline(), fontStyle.getAlign());
    }

    protected void drawImage(String imageId, InputStream input, float imageX, float imageY, float height, float width, String helpText) throws Exception {
        this.writer.drawImage(imageId, input, imageX, imageY, width, height);
    }

    protected void drawImage(String imageId, byte[] imageData, String extension, float imageX, float imageY, float height, float width, String helpText, Map params) throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream(imageData);
        this.drawImage(imageId, input, imageX, imageY, height, width, helpText);
    }

    protected void drawImage(String uri, String extension, float imageX, float imageY, float height, float width, String helpText, Map params) throws Exception {
        if (uri == null) {
            return;
        }
        this.drawImage(uri, new URL(uri).openStream(), imageX, imageY, height, width, helpText);
    }

    protected void drawLine(float startX, float startY, float endX, float endY, float width, Color color, int lineStyle) {
        this.writer.drawLine(startX, startY, endX, endY, width, color, lineStyle);
    }

    protected void drawBackgroundColor(Color color, float x, float y, float width, float height) {
        if (color != null) {
            this.writer.fillRect(x, y, width, height, color);
        }
    }

    protected void drawBackgroundImage(float x, float y, float width, float height, float imageWidth, float imageHeight, int repeat, String imageUrl, float absPosX, float absPosY) throws IOException {
        this.writer.drawBackgroundImage(imageUrl, x, y, width, height, imageWidth, imageHeight, absPosX, absPosY, repeat);
    }

    protected void clip(float startX, float startY, float width, float height) {
        this.writer.clipRect(startX, startY, width, height);
    }

    protected void drawBackgroundImage(float x, float y, float width, float height, int repeat, String imageUrl, float absPosX, float absPosY) throws IOException {
    }
}

