/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.action;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.CubeBuilder;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;

public class NewCubeAction
extends Action {
    public static final String ID = "org.eclipse.birt.report.designer.ui.actions.NewCubeAction";

    public NewCubeAction() {
        this.setId(ID);
    }

    public NewCubeAction(String text) {
        super(text);
        this.setId(ID);
    }

    public NewCubeAction(String text, int style) {
        super(text, style);
        this.setId(ID);
    }

    public NewCubeAction(String text, ImageDescriptor image) {
        super(text, image);
        this.setId(ID);
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("New cube action >> Run ...");
        }
        if (SessionHandleAdapter.getInstance().getReportDesignHandle() == null) {
            return;
        }
        List existingCubes = this.getCubes();
        CommandStack stack = this.getActionStack();
        stack.startPersistentTrans(Messages.getString("NewCubeAction.trans.cube.new"));
        TabularCubeHandle newCube = DesignElementFactory.getInstance().newTabularCube(Messages.getString("NewCubeAction.DataCube"));
        boolean isFailed = false;
        try {
            SessionHandleAdapter.getInstance().getReportDesignHandle().getCubes().add((DesignElementHandle)newCube);
            CubeBuilder builder = new CubeBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), newCube);
            String wizardTitle = Messages.getString("cube.new");
            builder.setTitle(wizardTitle);
            int result = builder.open();
            this.notifyResult(result == 0);
            if (result != 0) {
                stack.rollback();
                isFailed = true;
            }
        }
        catch (Exception e) {
            stack.rollback();
            isFailed = true;
            ExceptionUtil.handle((Throwable)e);
        }
        if (!isFailed) {
            stack.commit();
        }
        List newCubes = this.getCubes();
        CubeHandle cube = this.findNewCube(existingCubes, newCubes);
        ReportRequest request = new ReportRequest("create element");
        ArrayList<CubeHandle> selectionObjects = new ArrayList<CubeHandle>();
        selectionObjects.add(cube);
        request.setSelectionObject(selectionObjects);
        SessionHandleAdapter.getInstance().getMediator().notifyRequest(request);
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    private List getCubes() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle().getAllCubes();
    }

    private CubeHandle findNewCube(List existingCubes, List newCubes) {
        int i = 0;
        while (i < newCubes.size()) {
            if (!existingCubes.contains(newCubes.get(i))) {
                return (CubeHandle)newCubes.get(i);
            }
            ++i;
        }
        return null;
    }
}

