/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.page;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.FilterListDialog;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.GraphicalEditPartsFactory;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.GraphicalViewerKeyHandler;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.DatasetNodeEditPart;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.HierarchyNodeEditPart;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.CubeBuilder;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class LinkGroupsPage
extends AbstractDescriptionPropertyPage {
    private CubeHandle input;
    private CubeBuilder builder;
    private ScrollingGraphicalViewer viewer;
    private GraphicalEditPartsFactory factory;
    private Button filterButton;

    public LinkGroupsPage(CubeBuilder builder, CubeHandle model) {
        this.input = model;
        this.builder = builder;
    }

    public Control createContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginWidth = 10;
        layout.marginTop = 10;
        layout.numColumns = 2;
        contents.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        contents.setLayoutData((Object)data);
        this.createCubeArea(contents);
        this.filterButton = new Button(contents, 8);
        this.filterButton.setText(Messages.getString("DatasetPage.Button.Filter"));
        GridData gd = new GridData();
        gd.widthHint = Math.max(60, this.filterButton.computeSize((int)-1, (int)-1).x);
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 2;
        this.filterButton.setLayoutData((Object)gd);
        this.filterButton.setEnabled(false);
        this.filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPart editPart = (EditPart)LinkGroupsPage.this.viewer.getSelectedEditParts().get(0);
                CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
                stack.startTrans("");
                FilterHandleProvider provider = (FilterHandleProvider)ElementAdapterManager.getAdapter((Object)((Object)LinkGroupsPage.this.builder), FilterHandleProvider.class);
                if (provider == null) {
                    provider = new FilterHandleProvider();
                }
                FilterListDialog dialog = new FilterListDialog(provider);
                if (editPart instanceof DatasetNodeEditPart) {
                    dialog.setInput((ReportElementHandle)editPart.getParent().getModel());
                } else if (editPart instanceof HierarchyNodeEditPart) {
                    dialog.setInput((ReportElementHandle)editPart.getModel());
                }
                if (dialog.open() == 0) {
                    stack.commit();
                } else {
                    stack.rollback();
                }
            }
        });
        return contents;
    }

    private Composite createCubeArea(Composite parent) {
        Composite viewerContent = new Composite(parent, 2048);
        viewerContent.setLayoutData((Object)new GridData(1808));
        viewerContent.setLayout((Layout)new FillLayout());
        this.viewer = new ScrollingGraphicalViewer();
        EditDomain editDomain = new EditDomain();
        ScalableFreeformRootEditPart root = new ScalableFreeformRootEditPart();
        this.viewer.setRootEditPart((RootEditPart)root);
        this.viewer.setEditDomain(editDomain);
        this.viewer.createControl(viewerContent);
        this.viewer.getControl().setBackground(ColorConstants.listBackground);
        this.factory = new GraphicalEditPartsFactory();
        this.viewer.setEditPartFactory((EditPartFactory)this.factory);
        this.viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(this.viewer));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    if (selection.getFirstElement() instanceof HierarchyNodeEditPart || selection.getFirstElement() instanceof DatasetNodeEditPart) {
                        LinkGroupsPage.this.filterButton.setEnabled(true);
                    } else {
                        LinkGroupsPage.this.filterButton.setEnabled(false);
                    }
                } else {
                    LinkGroupsPage.this.filterButton.setEnabled(false);
                }
            }
        });
        this.load();
        return viewerContent;
    }

    public void pageActivated() {
        UIUtil.bindHelp((Control)this.builder.getShell(), (String)"org.eclipse.birt.cshelp.CubeBuilderLinkGroupsPage_ID");
        this.getContainer().setMessage(Messages.getString("LinkGroupsPage.Container.Title.Message"), 0);
        this.builder.setTitleTitle(Messages.getString("LinkGroupsPage.Title.Title"));
        this.builder.setErrorMessage(null);
        this.builder.setTitleMessage(Messages.getString("LinkGroupsPage.Title.Message"));
        this.load();
    }

    private void load() {
        if (this.input != null && ((TabularCubeHandle)this.input).getDataSet() != null) {
            this.viewer.setContents((Object)this.input);
        }
    }
}

