/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.provider;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.VirtualField;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class CubeContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        int pos;
        HierarchyHandle hierarchy;
        if (parentElement instanceof Object[]) {
            return (Object[])parentElement;
        }
        if (parentElement instanceof DimensionHandle) {
            HierarchyHandle hierarchy2 = (HierarchyHandle)((DimensionHandle)parentElement).getContent("hierarchies", 0);
            if (hierarchy2.getLevelCount() > 0) {
                return new Object[]{hierarchy2.getLevel(0)};
            }
            VirtualField virtualLevel = new VirtualField("level");
            virtualLevel.setModel(parentElement);
            return new Object[]{virtualLevel};
        }
        if (parentElement instanceof CubeHandle) {
            CubeHandle handle = (CubeHandle)parentElement;
            return new Object[]{handle.getPropertyHandle("dimensions"), handle.getPropertyHandle("measureGroups")};
        }
        if (parentElement instanceof PropertyHandle) {
            PropertyHandle property = (PropertyHandle)parentElement;
            String name = property.getPropertyDefn().getName();
            if (name.equals("dimensions")) {
                CubeHandle cube = (CubeHandle)property.getElementHandle();
                VirtualField virtualDimsnion = new VirtualField("dimension");
                virtualDimsnion.setModel(parentElement);
                ArrayList<VirtualField> dimensionList = new ArrayList<VirtualField>();
                if (cube.getContentCount("dimensions") > 0) {
                    dimensionList.addAll(cube.getContents("dimensions"));
                }
                dimensionList.add(0, virtualDimsnion);
                return dimensionList.toArray();
            }
            if (name.equals("measureGroups")) {
                CubeHandle cube = (CubeHandle)property.getElementHandle();
                VirtualField virtualMeasureGroup = new VirtualField("measureGroup");
                virtualMeasureGroup.setModel(parentElement);
                ArrayList<VirtualField> measureGroupList = new ArrayList<VirtualField>();
                if (cube.getContentCount("measureGroups") > 0) {
                    measureGroupList.addAll(cube.getContents("measureGroups"));
                }
                measureGroupList.add(0, virtualMeasureGroup);
                return measureGroupList.toArray();
            }
        }
        if (parentElement instanceof LevelHandle && (hierarchy = (HierarchyHandle)((LevelHandle)parentElement).getContainer()).getLevel((pos = ((LevelHandle)parentElement).getIndex()) + 1) != null) {
            return new Object[]{hierarchy.getLevel(pos + 1)};
        }
        if (parentElement instanceof MeasureGroupHandle) {
            Object[] measures = ((MeasureGroupHandle)parentElement).getContents("measures").toArray();
            if (measures == null || measures.length == 0) {
                VirtualField virtualMeasure = new VirtualField("measure");
                virtualMeasure.setModel(parentElement);
                return new Object[]{virtualMeasure};
            }
            return measures;
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        DimensionHandle dimension;
        MeasureGroupHandle measures;
        CubeHandle cube;
        if (element instanceof LevelHandle) {
            HierarchyHandle hierarchy = (HierarchyHandle)((LevelHandle)element).getContainer();
            LevelHandle level = (LevelHandle)element;
            if (hierarchy == null) {
                return null;
            }
            if (level.getIndex() > 0) {
                return hierarchy.getLevel(level.getIndex() - 1);
            }
            return hierarchy.getContainer();
        }
        if (element instanceof MeasureGroupHandle && (cube = (CubeHandle)(measures = (MeasureGroupHandle)element).getContainer()) != null) {
            return cube.getPropertyHandle("measureGroups");
        }
        if (element instanceof DimensionHandle && (cube = (CubeHandle)(dimension = (DimensionHandle)element).getContainer()) != null) {
            return cube.getPropertyHandle("dimensions");
        }
        if (element instanceof MeasureHandle) {
            return ((MeasureHandle)element).getContainer();
        }
        if (element instanceof PropertyHandle) {
            PropertyHandle property = (PropertyHandle)element;
            return property.getElementHandle();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Object[]) {
            return ((Object[])element).length > 0;
        }
        if (element instanceof DimensionHandle) {
            return true;
        }
        if (element instanceof LevelHandle) {
            int pos;
            HierarchyHandle hierarchy = (HierarchyHandle)((LevelHandle)element).getContainer();
            return hierarchy.getLevel((pos = ((LevelHandle)element).getIndex()) + 1) != null;
        }
        if (element instanceof MeasureGroupHandle) {
            return true;
        }
        if (element instanceof CubeHandle) {
            return true;
        }
        if (element instanceof PropertyHandle) {
            PropertyHandle property = (PropertyHandle)element;
            String name = property.getPropertyDefn().getName();
            if (name.equals("dimensions")) {
                return true;
            }
            if (name.equals("measureGroups")) {
                return true;
            }
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

