/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.designer.nls.Messages;

public class FormatNumberPattern {
    public static final String TEXT_CURRENCY_SYMBOL_NONE = Messages.getString("FormatNumberPage.currency.symbol.none");
    public static final String SYMBOL_POSITION_AFTER = Messages.getString("FormatNumberPage.symblePos.after");
    public static final String SYMBOL_POSITION_BEFORE = Messages.getString("FormatNumberPage.symblePos.before");
    private String category = "";
    private char type;
    protected String zeroIndicator = "'0'";
    protected String defaultDecs = "0000000000";
    protected String DEFAULT_CURRENCY_PATTERN = "#,##0.00";
    protected String DEFAULT_FIXED_PATTERN = "###0.00";
    protected String DEFAULT_PERCENT_PATTERN = "###0.00%";
    protected String DEFAULT_SCIENTIFIC_PATTERN = "0.00E00";

    public static String getPatternForCategory(String category, ULocale locale) {
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        String pattern = null;
        if ("Currency".equals(category)) {
            pattern = "\u00a4###,##0.00";
            Currency currency = Currency.getInstance((ULocale)locale);
            if (currency != null) {
                String symbol = currency.getSymbol();
                NumberFormat formater = NumberFormat.getCurrencyInstance((ULocale)locale);
                String result = formater.format(1L);
                if (result.endsWith(symbol)) {
                    pattern = "###,##0.00";
                    result = result.substring(0, result.indexOf(symbol));
                    int i = result.length() - 1;
                    while (i >= 0) {
                        if (result.charAt(i) != ' ') break;
                        pattern = String.valueOf(pattern) + " ";
                        --i;
                    }
                    pattern = String.valueOf(pattern) + "\u00a4";
                } else {
                    pattern = "\u00a4";
                    result = result.substring(result.indexOf(symbol) + symbol.length());
                    int i = 0;
                    while (i < result.length()) {
                        if (result.charAt(i) != ' ') break;
                        pattern = String.valueOf(pattern) + " ";
                        ++i;
                    }
                    pattern = String.valueOf(pattern) + "###,##0.00";
                }
            }
        } else if ("Fixed".equals(category)) {
            pattern = "#0.00";
        } else if ("Percent".equals(category)) {
            pattern = "0.00%";
            NumberFormat formater = NumberFormat.getPercentInstance((ULocale)locale);
            String result = formater.format(1L);
            if (result.endsWith("%")) {
                pattern = "0.00";
                result = result.substring(0, result.indexOf(37));
                int i = result.length() - 1;
                while (i >= 0) {
                    if (result.charAt(i) != ' ') break;
                    pattern = String.valueOf(pattern) + " ";
                    --i;
                }
                pattern = String.valueOf(pattern) + "%";
            } else {
                pattern = "%";
                result = result.substring(result.indexOf(37) + 1);
                int i = 0;
                while (i < result.length()) {
                    if (result.charAt(i) != ' ') break;
                    pattern = String.valueOf(pattern) + " ";
                    ++i;
                }
                pattern = String.valueOf(pattern) + "0.00";
            }
        } else {
            pattern = "Scientific".equals(category) ? "0.00E00" : "";
        }
        return pattern;
    }

    public FormatNumberPattern(String category) {
        this.category = category;
        this.setType('G');
    }

    public FormatNumberPattern() {
        this.category = "General Number";
        this.setType('G');
    }

    public String getCategory() {
        return this.category;
    }

    protected char getType() {
        return this.type;
    }

    protected void setType(char t) {
        this.type = t;
    }

    public String getPattern() {
        return this.category;
    }

    public void setPattern(String patternStr) {
        this.category = this.valPattern(patternStr);
    }

    protected String valPattern(String patternStr) {
        String patt = patternStr == null || this.getCategory().equals(patternStr) ? this.getDefaultPatt() : patternStr;
        return patt;
    }

    protected String getDefaultPatt() {
        return this.category;
    }
}

