/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.birt.core.archive.cache.CacheListener;
import org.eclipse.birt.core.archive.cache.Cacheable;
import org.eclipse.birt.core.archive.cache.SystemCacheManager;

public class FileCacheManager {
    private SystemCacheManager systemCache;
    private HashMap<Object, CacheEntry> lockedBlocks;
    private LinkedHashMap<Object, CacheEntry> freeBlocks;
    private int maxCacheSize;
    private CacheListener listener;

    public FileCacheManager() {
        this(null, 0);
    }

    public FileCacheManager(int maxCacheSize) {
        this(null, maxCacheSize);
    }

    public FileCacheManager(SystemCacheManager systemCache, int maxCacheSize) {
        this.systemCache = systemCache;
        this.maxCacheSize = maxCacheSize;
        this.lockedBlocks = new HashMap();
        this.freeBlocks = new LinkedHashMap();
    }

    public void setCacheListener(CacheListener listener) {
        this.listener = listener;
    }

    public synchronized void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.releaseFreeCaches();
    }

    public int getUsedCacheSize() {
        return this.lockedBlocks.size() + this.freeBlocks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSystemCacheManager(SystemCacheManager manager) {
        if (this.systemCache != manager) {
            SystemCacheManager systemCacheManager;
            if (this.systemCache != null) {
                systemCacheManager = this.systemCache;
                synchronized (systemCacheManager) {
                    this.systemCache.increaseUsedCacheSize(-this.lockedBlocks.size() - this.freeBlocks.size());
                    this.systemCache.clearCaches(this);
                }
            }
            if (manager != null) {
                systemCacheManager = manager;
                synchronized (systemCacheManager) {
                    manager.increaseUsedCacheSize(this.lockedBlocks.size() + this.freeBlocks.size());
                }
            }
            this.systemCache = manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseFreeCaches() {
        if (this.freeBlocks.isEmpty()) {
            return;
        }
        int releasedCacheSize = this.freeBlocks.size() + this.lockedBlocks.size() - this.maxCacheSize;
        if (releasedCacheSize > 0) {
            releasedCacheSize = Math.min(releasedCacheSize, this.freeBlocks.size());
            Cacheable[] caches = new Cacheable[releasedCacheSize];
            Iterator<CacheEntry> iter = this.freeBlocks.values().iterator();
            int i = 0;
            while (i < releasedCacheSize) {
                if (iter.hasNext()) {
                    caches[i] = iter.next().cache;
                    iter.remove();
                }
                ++i;
            }
            if (this.listener != null) {
                Cacheable[] cacheableArray = caches;
                int n = caches.length;
                int n2 = 0;
                while (n2 < n) {
                    Cacheable cache = cacheableArray[n2];
                    this.listener.onCacheRelease(cache);
                    ++n2;
                }
            }
            if (this.systemCache != null) {
                SystemCacheManager systemCacheManager = this.systemCache;
                synchronized (systemCacheManager) {
                    this.systemCache.increaseUsedCacheSize(-releasedCacheSize);
                    this.systemCache.addCaches(this, caches);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        if (this.systemCache != null) {
            SystemCacheManager systemCacheManager = this.systemCache;
            synchronized (systemCacheManager) {
                this.systemCache.increaseUsedCacheSize(-this.lockedBlocks.size() - this.freeBlocks.size());
                this.systemCache.clearCaches(this);
            }
        }
        if (this.listener != null) {
            for (CacheEntry cacheEntry : this.lockedBlocks.values()) {
                this.listener.onCacheRelease(cacheEntry.cache);
            }
            for (CacheEntry cacheEntry : this.freeBlocks.values()) {
                this.listener.onCacheRelease(cacheEntry.cache);
            }
        }
        this.lockedBlocks.clear();
        this.freeBlocks.clear();
    }

    public synchronized void touchAllCaches(CacheListener listener) {
        assert (listener != null);
        for (CacheEntry cacheEntry : this.lockedBlocks.values()) {
            listener.onCacheRelease(cacheEntry.cache);
        }
        for (CacheEntry cacheEntry : this.freeBlocks.values()) {
            listener.onCacheRelease(cacheEntry.cache);
        }
    }

    public void releaseCache(Cacheable cache) {
        Object cacheKey = cache.getCacheKey();
        CacheEntry cacheEntry = this.lockedBlocks.get(cacheKey);
        if (cacheEntry != null) {
            --cacheEntry.lock;
            if (cacheEntry.lock <= 0) {
                this.lockedBlocks.remove(cacheKey);
                if (this.maxCacheSize > 0) {
                    this.freeBlocks.put(cacheKey, cacheEntry);
                    this.releaseFreeCaches();
                } else if (this.listener != null) {
                    this.listener.onCacheRelease(cache);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cacheable getCache(Object cacheKey) {
        CacheEntry cacheEntry = this.lockedBlocks.get(cacheKey);
        if (cacheEntry == null) {
            cacheEntry = (CacheEntry)this.freeBlocks.remove(cacheKey);
            if (cacheEntry != null) {
                cacheEntry.lock = 0;
                this.lockedBlocks.put(cacheKey, cacheEntry);
            } else {
                if (this.systemCache == null) {
                    return null;
                }
                SystemCacheManager systemCacheManager = this.systemCache;
                synchronized (systemCacheManager) {
                    Cacheable cache;
                    block8: {
                        cache = this.systemCache.getCache(this, cacheKey);
                        if (cache != null) break block8;
                        return null;
                    }
                    cacheEntry = new CacheEntry(cache);
                    this.lockedBlocks.put(cacheKey, cacheEntry);
                    this.systemCache.increaseUsedCacheSize(1);
                    this.releaseFreeCaches();
                }
            }
        }
        ++cacheEntry.lock;
        return cacheEntry.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCache(Cacheable cache) {
        Object cacheKey = cache.getCacheKey();
        CacheEntry cacheEntry = new CacheEntry(cache);
        ++cacheEntry.lock;
        this.lockedBlocks.put(cacheKey, cacheEntry);
        if (this.systemCache != null) {
            SystemCacheManager systemCacheManager = this.systemCache;
            synchronized (systemCacheManager) {
                this.systemCache.increaseUsedCacheSize(1);
            }
        }
        this.releaseFreeCaches();
    }

    private static class CacheEntry {
        int lock;
        Cacheable cache;

        CacheEntry(Cacheable cache) {
            this.cache = cache;
        }
    }
}

