/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryV1;
import org.eclipse.birt.core.archive.compound.IArchiveFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveFileV1
implements IArchiveFile {
    String archiveName;
    RandomAccessFile rf;
    private HashMap<String, ArchiveEntryV1> lookupMap = new HashMap();

    public ArchiveFileV1(String archiveName, RandomAccessFile rf) throws IOException {
        this.archiveName = archiveName;
        this.rf = rf;
        try {
            if (this.rf == null) {
                this.rf = new RandomAccessFile(archiveName, "r");
            }
            this.readFileTable();
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public ArchiveFileV1(String archiveName) throws IOException {
        this(archiveName, null);
    }

    protected void readFileTable() throws IOException {
        this.rf.seek(0L);
        long streamSectionPos = this.rf.readLong();
        long entryNumber = this.rf.readLong();
        long i = 0L;
        while (i < entryNumber) {
            String name = this.rf.readUTF();
            long start = this.rf.readLong() + streamSectionPos;
            long length = this.rf.readLong();
            this.lookupMap.put(name, new ArchiveEntryV1(this, name, start, length));
            ++i;
        }
    }

    @Override
    public String getName() {
        return this.archiveName;
    }

    @Override
    public String getDependId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.rf != null) {
            this.rf.close();
            this.rf = null;
        }
    }

    @Override
    public void setCacheSize(int cacheSize) {
    }

    @Override
    public int getUsedCache() {
        return 0;
    }

    @Override
    public synchronized ArchiveEntry createEntry(String name) throws IOException {
        throw new IOException("read only archive");
    }

    @Override
    public boolean exists(String name) {
        return this.lookupMap.containsKey(name);
    }

    @Override
    public void flush() throws IOException {
        throw new IOException("read only archive");
    }

    @Override
    public ArchiveEntry openEntry(String name) throws IOException {
        ArchiveEntryV1 entry = this.lookupMap.get(name);
        if (entry != null) {
            return entry;
        }
        throw new FileNotFoundException(name);
    }

    @Override
    public List<String> listEntries(String namePattern) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : this.lookupMap.keySet()) {
            if (namePattern != null && !name.startsWith(namePattern)) continue;
            list.add(name);
        }
        return list;
    }

    @Override
    public synchronized void refresh() throws IOException {
    }

    @Override
    public synchronized boolean removeEntry(String name) throws IOException {
        throw new IOException("read only archive");
    }

    @Override
    public Object lockEntry(String stream) throws IOException {
        ArchiveEntryV1 entry = this.lookupMap.get(stream);
        if (entry != null) {
            return entry;
        }
        throw new FileNotFoundException("not exist stream " + stream);
    }

    @Override
    public void unlockEntry(Object locker) throws IOException {
        if (!(locker instanceof ArchiveEntryV1)) {
            throw new IOException("Invalide lock type:" + locker);
        }
    }

    synchronized int read(long pos, byte[] b, int off, int len) throws IOException {
        this.rf.seek(pos);
        return this.rf.read(b, off, len);
    }

    synchronized void write(long pos, byte[] b, int off, int len) throws IOException {
        throw new IOException("read only archive");
    }

    @Override
    public synchronized void save() throws IOException {
        throw new IOException("read only archive");
    }
}

