/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound.v3;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.birt.core.archive.compound.v3.Ext2Constants;

public class Ext2Node
implements Ext2Constants {
    static final int STATUS_UNUSED = 0;
    static final int STATUS_USED = 1;
    static final int NODE_SIZE = 64;
    static final int DIRECT_BLOCK_COUNT = 9;
    static final int INDIRECT_BLOCK_COUNT = 3;
    protected int nodeId;
    protected int status;
    protected long length;
    protected int blockCount;
    protected int[] directBlocks = new int[9];
    protected int[] indirectBlocks = new int[3];

    Ext2Node() {
        this(-1);
    }

    Ext2Node(int id) {
        this.nodeId = id;
        int i = 0;
        while (i < 9) {
            this.directBlocks[i] = -1;
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.indirectBlocks[i] = -1;
            ++i;
        }
    }

    public void reset() {
        this.status = 0;
        this.blockCount = 0;
        this.length = 0L;
        int i = 0;
        while (i < 9) {
            this.directBlocks[i] = -1;
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.indirectBlocks[i] = -1;
            ++i;
        }
    }

    public Ext2Node copyFreeNode() {
        Ext2Node freeNode = new Ext2Node();
        freeNode.blockCount = this.blockCount;
        int i = 0;
        while (i < 9) {
            freeNode.directBlocks[i] = this.directBlocks[i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            freeNode.indirectBlocks[i] = this.indirectBlocks[i];
            ++i;
        }
        return freeNode;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    int getStatus() {
        return this.status;
    }

    void setStatus(int status) {
        this.status = status;
    }

    public long getLength() {
        return this.length;
    }

    void setLength(long length) {
        this.length = length;
    }

    int getBlockCount() {
        return this.blockCount;
    }

    void setBlockCount(int blockCount) {
        this.blockCount = blockCount;
    }

    void read(DataInput in) throws IOException {
        this.status = in.readInt();
        this.length = in.readLong();
        this.blockCount = in.readInt();
        int i = 0;
        while (i < 9) {
            this.directBlocks[i] = in.readInt();
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.indirectBlocks[i] = in.readInt();
            ++i;
        }
    }

    void write(DataOutput out) throws IOException {
        out.writeInt(this.status);
        out.writeLong(this.length);
        out.writeInt(this.blockCount);
        int i = 0;
        while (i < 9) {
            out.writeInt(this.directBlocks[i]);
            ++i;
        }
        i = 0;
        while (i < 3) {
            out.writeInt(this.indirectBlocks[i]);
            ++i;
        }
    }

    int getDirectBlock(int index) {
        assert (index < 9);
        return this.directBlocks[index];
    }

    void setDirectBlock(int index, int blockId) {
        assert (index < 9);
        this.directBlocks[index] = blockId;
    }

    int getIndirectBlock(int index) {
        assert (index < 3);
        return this.indirectBlocks[index];
    }

    void setIndirectBlock(int index, int blockId) {
        assert (index < 3);
        this.indirectBlocks[index] = blockId;
    }
}

