/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound.v3;

import java.io.IOException;
import org.eclipse.birt.core.archive.compound.v3.Ext2FileSystem;
import org.eclipse.birt.core.archive.compound.v3.Ext2Node;
import org.eclipse.birt.core.archive.compound.v3.FatBlock;
import org.eclipse.birt.core.archive.compound.v3.FatBlockList;

public class FreeBlockList
extends FatBlockList {
    FreeBlockList(Ext2FileSystem fs, Ext2Node node) {
        super(fs, node);
    }

    int removeLastBlock() throws IOException {
        int blockId;
        int level = 2;
        while (level >= 0) {
            blockId = this.node.getIndirectBlock(level);
            if (blockId != -1) {
                FatBlock fatBlock = this.getCachedBlock(level, blockId);
                int nextBlockId = this.getLastBlock(level, fatBlock);
                if (nextBlockId > 0) {
                    nextBlockId = blockId;
                }
                --this.node.blockCount;
                return nextBlockId;
            }
            --level;
        }
        int i = 8;
        while (i >= 0) {
            blockId = this.node.getDirectBlock(i);
            if (blockId > 0) {
                this.node.setDirectBlock(i, 0);
                --this.node.blockCount;
                return blockId;
            }
            --i;
        }
        assert (this.node.getBlockCount() == 0);
        return -1;
    }

    protected int getLastBlock(int level, FatBlock fatBlock) throws IOException {
        int index = 1023;
        while (index >= 0) {
            int blockId = fatBlock.getBlock(index);
            if (blockId > 0) {
                FatBlock nextFatBlock;
                int nextBlockId;
                if (level == 0) {
                    fatBlock.setBlock(index, 0);
                    return blockId;
                }
                if ((nextBlockId = this.getLastBlock(level--, nextFatBlock = this.getCachedBlock(level, blockId))) > 0) {
                    return nextBlockId;
                }
                fatBlock.setBlock(index, 0);
                return blockId;
            }
            --index;
        }
        return -1;
    }
}

