/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatPage;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public abstract class FormatLayoutPeer
implements IFormatPage {
    private static final String PREVIEW_TEXT_INVALID_FORMAT_CODE = Messages.getString((String)"FormatNumberPage.preview.invalidFormatCode");
    private static final String LABEL_FORMAT_CATEGORY = Messages.getString((String)"FormatNumberPage.label.format.number.page");
    private static final String LABEL_FORMAT_LOCALE = Messages.getString((String)"FormatNumberPage.label.format.number.locale");
    private static final String LABEL_FORMAT_CODE = Messages.getString((String)"FormatNumberPage.label.format.code");
    private static final String LABEL_CUSTOM_SETTINGS_GROUP = Messages.getString((String)"FormatNumberPage.label.custom.settings");
    private static final String LABEL_CUSTOM_SETTINGS_LABEL = Messages.getString((String)"FormatNumberPage.label.custom.settings.lable");
    private static final String LABEL_CUSTOM_PREVIEW_GROUP = Messages.getString((String)"FormatNumberPage.label.custom.preview.group");
    private static final String LABEL_CUSTOM_PREVIEW_LABEL = Messages.getString((String)"FormatNumberPage.label.custom.preview.label");
    protected static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_NAME = Messages.getString((String)"FormatDateTimePage.label.table.column.format.name");
    protected static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT = Messages.getString((String)"FormatDateTimePage.label.table.column.format.result");
    protected static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE = Messages.getString((String)"FormatDateTimePage.label.table.column.format.code");
    protected static final int DEFAULT_CATEGORY_CONTAINER_WIDTH = 220;
    private List<IFormatChangeListener> listeners = new ArrayList<IFormatChangeListener>();
    protected int pageAlignment;
    protected String pattern = null;
    protected String category = null;
    protected String locale = null;
    protected String oldCategory = null;
    protected String oldPattern = null;
    protected String oldLocale = null;
    private Composite content;
    private Composite infoComp;
    private Composite formatCodeComp;
    private Composite generalFormatCodePage;
    private Composite customFormatCodePage;
    protected XCombo typeChoicer;
    protected XCombo localeChoicer;
    protected Composite generalPage;
    protected Composite customPage;
    protected Text customPreviewTextBox;
    protected Text customFormatCodeTextBox;
    protected Label customPreviewLabel;
    protected Table customFormatTable;
    protected Label customGuideLabel;
    protected HashMap<String, Control> categoryPageMaps;
    protected boolean hasLoaded = false;
    protected String previewText = null;
    protected FormatAdapter formatAdapter;
    private boolean isDirty = false;
    private boolean showLocale = true;
    protected boolean isFormStyle = false;

    protected FormatLayoutPeer(int pageAlignment, boolean isFormStyle, boolean showLocale) {
        this.isFormStyle = isFormStyle;
        this.showLocale = showLocale;
        this.pageAlignment = pageAlignment;
    }

    public Control createLayout(Composite parent) {
        this.content = new Composite(parent, 0);
        this.formatAdapter.initChoiceArray();
        this.formatAdapter.getFormatTypes(null);
        if (this.pageAlignment == 1) {
            this.createContentsHorizontally();
        } else {
            this.createContentsVirtically();
        }
        return this.content;
    }

    private void createContentsVirtically() {
        this.content.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        Composite topContainer = new Composite(this.content, 0);
        topContainer.setLayoutData((Object)new GridData(768));
        topContainer.setLayout((Layout)new GridLayout(2, false));
        FormWidgetFactory.getInstance().createLabel(topContainer, this.isFormStyle).setText(LABEL_FORMAT_CATEGORY);
        this.typeChoicer = new XCombo(topContainer, true, this.isFormStyle);
        this.typeChoicer.setLayoutData(new GridData(768));
        this.typeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatLayoutPeer.this.reLayoutSubPages();
                FormatLayoutPeer.this.updateTextByLocale();
                FormatLayoutPeer.this.updatePreview();
                FormatLayoutPeer.this.notifyFormatChange();
            }
        });
        this.typeChoicer.setItems(this.formatAdapter.getFormatTypes(null));
        Label localeLabel = FormWidgetFactory.getInstance().createLabel(topContainer, this.isFormStyle);
        localeLabel.setText(LABEL_FORMAT_LOCALE);
        this.localeChoicer = new XCombo(topContainer, true, this.isFormStyle);
        this.localeChoicer.setLayoutData(new GridData(768));
        this.localeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatLayoutPeer.this.updateDefaultsByLocale();
                FormatLayoutPeer.this.updateTextByLocale();
                FormatLayoutPeer.this.updatePreview();
                FormatLayoutPeer.this.notifyFormatChange();
            }
        });
        this.localeChoicer.setItems(FormatAdapter.getLocaleDisplayNames());
        if (this.localeChoicer.getItemCount() > 0) {
            this.localeChoicer.select(0);
        }
        WidgetUtil.setExcludeGridData((Control)localeLabel, !this.showLocale);
        WidgetUtil.setExcludeGridData(this.localeChoicer.getControl(), !this.showLocale);
        this.infoComp = new Composite(this.content, 0);
        this.infoComp.setLayoutData((Object)new GridData(768));
        this.infoComp.setLayout((Layout)new StackLayout());
        this.createCategoryPages(this.infoComp);
        this.createCategoryPatterns();
        this.setInput(null, null);
        this.setPreviewText(this.getDefaultPreviewText());
    }

    private void createContentsHorizontally() {
        this.content.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        Composite container = new Composite(this.content, 0);
        GridData data = new GridData();
        data.widthHint = 220;
        container.setLayoutData((Object)data);
        container.setLayout((Layout)new GridLayout(1, false));
        FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle).setText(LABEL_FORMAT_CATEGORY);
        this.typeChoicer = new XCombo(container, true, this.isFormStyle);
        this.typeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatLayoutPeer.this.reLayoutSubPages();
                FormatLayoutPeer.this.updateTextByLocale();
                FormatLayoutPeer.this.updatePreview();
                FormatLayoutPeer.this.notifyFormatChange();
            }
        });
        this.typeChoicer.setItems(this.formatAdapter.getFormatTypes(null));
        Label localeLabel = FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle);
        localeLabel.setText(LABEL_FORMAT_LOCALE);
        this.localeChoicer = new XCombo(container, true, this.isFormStyle);
        this.localeChoicer.setLayoutData(new GridData(768));
        this.localeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatLayoutPeer.this.updateDefaultsByLocale();
                FormatLayoutPeer.this.updateTextByLocale();
                FormatLayoutPeer.this.updatePreview();
                FormatLayoutPeer.this.notifyFormatChange();
            }
        });
        this.localeChoicer.setItems(FormatAdapter.getLocaleDisplayNames());
        if (this.localeChoicer.getItemCount() > 0) {
            this.localeChoicer.select(0);
        }
        WidgetUtil.setExcludeGridData((Control)localeLabel, !this.showLocale);
        WidgetUtil.setExcludeGridData(this.localeChoicer.getControl(), !this.showLocale);
        this.infoComp = new Composite(this.content, 0);
        data = new GridData(1808);
        data.verticalSpan = 2;
        this.infoComp.setLayoutData((Object)data);
        this.infoComp.setLayout((Layout)new StackLayout());
        this.createCategoryPages(this.infoComp);
        this.formatCodeComp = new Composite(this.content, 0);
        data = new GridData(1040);
        data.widthHint = 220;
        this.formatCodeComp.setLayoutData((Object)data);
        this.formatCodeComp.setLayout((Layout)new StackLayout());
        this.createFormatCodePages(this.formatCodeComp);
        this.createCategoryPatterns();
        this.setInput(null, null);
        this.setPreviewText(this.getDefaultPreviewText());
    }

    protected abstract void createCategoryPages(Composite var1);

    protected void createCategoryPatterns() {
    }

    private void createFormatCodePages(Composite parent) {
        this.createHorizontalGeneralFormatCodePage(parent);
        this.createHorizontalCustomFormatCodePage(parent);
    }

    private Composite createHorizontalGeneralFormatCodePage(Composite parent) {
        if (this.generalFormatCodePage == null) {
            this.generalFormatCodePage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            this.generalFormatCodePage.setLayout((Layout)layout);
            Label l = FormWidgetFactory.getInstance().createLabel(this.generalFormatCodePage, 258, this.isFormStyle);
            l.setLayoutData((Object)new GridData(768));
        }
        return this.generalFormatCodePage;
    }

    private Composite createHorizontalCustomFormatCodePage(Composite parent) {
        if (this.customFormatCodePage == null) {
            this.customFormatCodePage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            this.customFormatCodePage.setLayout((Layout)layout);
            Label l = FormWidgetFactory.getInstance().createLabel(this.customFormatCodePage, 258, this.isFormStyle);
            l.setLayoutData((Object)new GridData(768));
            Composite container = new Composite(this.customFormatCodePage, 0);
            container.setLayoutData((Object)new GridData(768));
            container.setLayout((Layout)new GridLayout(2, false));
            FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle).setText(LABEL_FORMAT_CODE);
            this.customFormatCodeTextBox = this.isFormStyle ? FormWidgetFactory.getInstance().createText(container, "", 4) : new Text(container, 2052);
            this.customFormatCodeTextBox.setLayoutData((Object)new GridData(768));
            this.customFormatCodeTextBox.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (FormatLayoutPeer.this.hasLoaded) {
                        FormatLayoutPeer.this.updatePreview();
                    }
                }
            });
            this.customFormatCodeTextBox.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    FormatLayoutPeer.this.notifyFormatChange();
                }

                public void focusGained(FocusEvent e) {
                }
            });
        }
        return this.customFormatCodePage;
    }

    protected final void notifyFormatChange() {
        if (this.hasLoaded) {
            this.fireFormatChanged(this.getCategory(), this.getPattern(), this.locale);
        }
    }

    public void setInput(String formatString) {
        if (formatString == null) {
            this.setInput(null, null);
            return;
        }
        String fmtStr = formatString;
        int pos = fmtStr.indexOf(":");
        if (StringUtil.isBlank((String)fmtStr)) {
            this.setInput(null, null);
            return;
        }
        if (pos == -1) {
            this.setInput(fmtStr, fmtStr);
            return;
        }
        String category = fmtStr.substring(0, pos);
        String patternStr = fmtStr.substring(pos + 1);
        this.setInput(category, patternStr, null);
    }

    public void setInput(String categoryStr, String patternStr) {
        this.setInput(categoryStr, patternStr, null);
    }

    public void setInput(String categoryStr, String patternStr, ULocale locale) {
        this.hasLoaded = false;
        String localeStr = FormatAdapter.getLocaleDisplayName(locale);
        this.initiatePageLayout(categoryStr, patternStr, localeStr);
        this.reLayoutSubPages();
        this.updateTextByLocale();
        this.updatePreview();
        this.oldCategory = categoryStr;
        this.oldPattern = patternStr;
        this.oldLocale = localeStr;
        this.hasLoaded = true;
    }

    protected abstract void initiatePageLayout(String var1, String var2, String var3);

    protected abstract void reLayoutSubPages();

    protected void updateDefaultsByLocale() {
    }

    protected abstract void updateTextByLocale();

    protected abstract void updatePreview();

    protected final void initiatePageLayout(String customCategoryName, String categoryStr, String patternStr, String localeStr) {
        if (localeStr != null) {
            this.localeChoicer.setText(localeStr);
        } else {
            this.localeChoicer.select(0);
        }
        if (categoryStr == null) {
            this.typeChoicer.select(0);
        } else {
            if (categoryStr.equals(customCategoryName)) {
                this.customFormatCodeTextBox.setText(patternStr == null ? "" : patternStr);
            }
            this.typeChoicer.select(this.formatAdapter.getIndexOfCategory(categoryStr));
        }
    }

    protected final void reLayoutSubPages(String customCategoryName) {
        Control control;
        String category = this.formatAdapter.getCategory4DisplayName(this.typeChoicer.getText());
        ((StackLayout)this.infoComp.getLayout()).topControl = control = this.categoryPageMaps.get(category);
        this.infoComp.layout();
        if (this.formatCodeComp != null) {
            ((StackLayout)this.formatCodeComp.getLayout()).topControl = category.equals(customCategoryName) ? this.createHorizontalCustomFormatCodePage(this.formatCodeComp) : this.createHorizontalGeneralFormatCodePage(this.formatCodeComp);
            this.formatCodeComp.layout();
        }
    }

    protected final Composite getCustomPage(Composite parent, boolean needGuideLabel, String customPreviewLabelText) {
        if (this.customPage == null) {
            this.customPage = new Composite(parent, 0);
            this.customPage.setLayout((Layout)this.createGridLayout4Page());
            this.createCustomSettingsPart(this.customPage);
            if (this.pageAlignment == 0) {
                Composite container = new Composite(this.customPage, 0);
                container.setLayoutData((Object)new GridData(768));
                container.setLayout((Layout)new GridLayout(2, false));
                FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle).setText(LABEL_FORMAT_CODE);
                this.customFormatCodeTextBox = this.isFormStyle ? FormWidgetFactory.getInstance().createText(container, "", 4) : new Text(container, 2052);
                this.customFormatCodeTextBox.setLayoutData((Object)new GridData(768));
                this.customFormatCodeTextBox.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (FormatLayoutPeer.this.hasLoaded) {
                            FormatLayoutPeer.this.updatePreview();
                        }
                    }
                });
                this.customFormatCodeTextBox.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                        FormatLayoutPeer.this.notifyFormatChange();
                    }

                    public void focusGained(FocusEvent e) {
                    }
                });
            }
            this.createCustomPreviewPart(this.customPage, needGuideLabel, customPreviewLabelText);
        }
        return this.customPage;
    }

    private void createCustomSettingsPart(Composite parent) {
        Group group = this.isFormStyle ? FormWidgetFactory.getInstance().createGroup(parent, "") : new Group(parent, 0);
        group.setText(LABEL_CUSTOM_SETTINGS_GROUP);
        group.setLayoutData((Object)this.createGridData4Part());
        group.setLayout((Layout)new GridLayout(1, false));
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle);
        label.setText(LABEL_CUSTOM_SETTINGS_LABEL);
        label.setLayoutData((Object)new GridData());
        this.createTable((Composite)group);
    }

    private void createCustomPreviewPart(Composite parent, boolean needGuideLabel, String customPreviewLabelText) {
        Group group = this.isFormStyle ? FormWidgetFactory.getInstance().createGroup(parent, "") : new Group(parent, 0);
        group.setText(LABEL_CUSTOM_PREVIEW_GROUP);
        if (this.pageAlignment == 1) {
            group.setLayoutData((Object)new GridData(1808));
            group.setLayout((Layout)new GridLayout(1, false));
        } else {
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)new GridLayout(2, false));
        }
        FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle).setText(customPreviewLabelText);
        this.customPreviewTextBox = this.isFormStyle ? FormWidgetFactory.getInstance().createText((Composite)group, "", 4) : new Text((Composite)group, 2052);
        this.customPreviewTextBox.setText(this.getDefaultPreviewText());
        GridData data = new GridData(768);
        if (this.pageAlignment == 1) {
            data.horizontalIndent = 10;
        }
        this.customPreviewTextBox.setLayoutData((Object)data);
        this.customPreviewTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormatLayoutPeer.this.setDefaultPreviewText(FormatLayoutPeer.this.customPreviewTextBox.getText());
                if (FormatLayoutPeer.this.hasLoaded) {
                    FormatLayoutPeer.this.updatePreview();
                }
                if (FormatLayoutPeer.this.customGuideLabel != null) {
                    if (StringUtil.isBlank((String)FormatLayoutPeer.this.customPreviewTextBox.getText())) {
                        FormatLayoutPeer.this.customGuideLabel.setText("");
                    } else {
                        FormatLayoutPeer.this.customGuideLabel.setText(FormatLayoutPeer.this.getCustomGuideText());
                    }
                }
            }
        });
        if (needGuideLabel) {
            if (this.pageAlignment == 0) {
                FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle);
            }
            this.customGuideLabel = FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle);
            this.customGuideLabel.setText("");
            Font font = JFaceResources.getDialogFont();
            FontData fData = font.getFontData()[0];
            fData.setHeight(fData.getHeight() - 1);
            this.customGuideLabel.setFont(FontManager.getFont((FontData)fData));
            data = new GridData(768);
            data.horizontalIndent = 10;
            this.customGuideLabel.setLayoutData((Object)data);
        }
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle);
        label.setText(LABEL_CUSTOM_PREVIEW_LABEL);
        label.setLayoutData((Object)new GridData());
        this.customPreviewLabel = FormWidgetFactory.getInstance().createLabel((Composite)group, 0x11000100, this.isFormStyle);
        this.customPreviewLabel.setText("");
        data = new GridData(1808);
        data.horizontalSpan = 1;
        this.customPreviewLabel.setLayoutData((Object)data);
    }

    protected void createTable(Composite parent) {
        this.customFormatTable = this.isFormStyle ? FormWidgetFactory.getInstance().createTable(parent, 98304) : new Table(parent, 100352);
        this.customFormatTable.setLayoutData((Object)new GridData(1808));
        this.customFormatTable.setLinesVisible(true);
        this.customFormatTable.setHeaderVisible(true);
    }

    public Control getControl() {
        return this.content;
    }

    public String getCategory() {
        return this.category;
    }

    public String getPattern() {
        return this.pattern;
    }

    public ULocale getLocale() {
        return this.getLocaleByDisplayName(this.locale);
    }

    protected final ULocale getLocaleByDisplayName(String name) {
        return FormatAdapter.getLocaleByDisplayName(name);
    }

    public boolean isFormatModified() {
        String c = this.getCategory();
        String p = this.getPattern();
        String l = this.locale;
        if (this.oldCategory == null ? c != null : !this.oldCategory.equals(c)) {
            return true;
        }
        if (this.oldPattern == null ? p != null : !this.oldPattern.equals(p)) {
            return true;
        }
        return this.oldLocale == null ? l != null : !this.oldLocale.equals(l);
    }

    protected final void markDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setEnabled(boolean enabled) {
        if (this.content.isEnabled() != enabled) {
            this.content.setEnabled(enabled);
        }
        this.setControlsEnabled(enabled);
    }

    protected abstract void setControlsEnabled(boolean var1);

    protected abstract String getDefaultPreviewText();

    protected abstract void setDefaultPreviewText(String var1);

    protected String getCustomGuideText() {
        return null;
    }

    protected final String getPreviewText() {
        return this.previewText;
    }

    protected final void setPattern(String pattern) {
        this.pattern = pattern;
    }

    protected final void setCategory(String category) {
        this.category = category;
    }

    protected final void setLocale(String locale) {
        this.locale = locale;
    }

    protected final String validatedFmtStr(String fmtStr) {
        String text = fmtStr;
        if (text == null) {
            text = PREVIEW_TEXT_INVALID_FORMAT_CODE;
        }
        return text;
    }

    protected final GridLayout createGridLayout4Page() {
        GridLayout layout;
        if (this.pageAlignment == 1) {
            layout = new GridLayout(2, false);
            layout.marginHeight = 0;
        } else {
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
        }
        return layout;
    }

    protected final GridData createGridData4Part() {
        GridData data = this.pageAlignment == 1 ? new GridData(1040) : new GridData(768);
        return data;
    }

    public void addFormatChangeListener(IFormatChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    protected abstract void fireFormatChanged(String var1, String var2, String var3);

    protected final void fireFormatChanged(String formatType, String newCategory, String newPattern, String newLocale) {
        if (this.listeners.isEmpty()) {
            return;
        }
        FormatChangeEvent event = new FormatChangeEvent(this, formatType, newCategory, newPattern, newLocale);
        for (IFormatChangeListener listener : this.listeners) {
            if (listener == null) continue;
            listener.formatChange(event);
        }
    }

    protected static class XCombo {
        private Combo cba;
        private CCombo cbb;

        protected XCombo(Composite parent, boolean isReadonly, boolean isFormStyle) {
            if (isFormStyle) {
                int style = 0x800000;
                if (isReadonly) {
                    style |= 8;
                }
                this.cbb = FormWidgetFactory.getInstance().createCCombo(parent, style);
            } else {
                int style = 2048;
                if (isReadonly) {
                    style |= 8;
                }
                this.cba = new Combo(parent, style);
                this.cba.setVisibleItemCount(30);
            }
        }

        public void addSelectionListener(SelectionListener listener) {
            if (this.cba != null) {
                this.cba.addSelectionListener(listener);
            } else {
                this.cbb.addSelectionListener(listener);
            }
        }

        public void addModifyListener(ModifyListener listener) {
            if (this.cba != null) {
                this.cba.addModifyListener(listener);
            } else {
                this.cbb.addModifyListener(listener);
            }
        }

        public void addFocusListener(FocusListener listener) {
            if (this.cba != null) {
                this.cba.addFocusListener(listener);
            } else {
                this.cbb.addFocusListener(listener);
            }
        }

        public void select(int index) {
            if (this.cba != null) {
                this.cba.select(index);
            } else {
                this.cbb.select(index);
            }
        }

        public void deselectAll() {
            if (this.cba != null) {
                this.cba.deselectAll();
            } else {
                this.cbb.deselectAll();
            }
        }

        public int getSelectionIndex() {
            return this.cba != null ? this.cba.getSelectionIndex() : this.cbb.getSelectionIndex();
        }

        public String getText() {
            return this.cba != null ? this.cba.getText() : this.cbb.getText();
        }

        public int getItemCount() {
            return this.cba != null ? this.cba.getItemCount() : this.cbb.getItemCount();
        }

        public void setText(String string) {
            if (this.cba != null) {
                this.cba.setText(string);
            } else {
                this.cbb.setText(string);
            }
        }

        public void setItems(String[] items) {
            if (this.cba != null) {
                this.cba.setItems(items);
            } else {
                this.cbb.setItems(items);
            }
        }

        public void setLayoutData(Object layoutData) {
            if (this.cba != null) {
                this.cba.setLayoutData(layoutData);
            } else {
                this.cbb.setLayoutData(layoutData);
            }
        }

        public boolean isEnabled() {
            return this.cba != null ? this.cba.isEnabled() : this.cbb.isEnabled();
        }

        public void setEnabled(boolean enabled) {
            if (this.cba != null) {
                this.cba.setEnabled(enabled);
            } else {
                this.cbb.setEnabled(enabled);
            }
        }

        Control getControl() {
            return this.cba == null ? this.cbb : this.cba;
        }
    }
}

