/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.IReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.layout.IFixLayoutHelper;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class ReportElementFigure
extends Figure
implements IReportElementFigure,
IFixLayoutHelper {
    private static final Rectangle PRIVATE_RECT = new Rectangle();
    private Image img;
    private int alignment;
    private Point position = new Point(-1, -1);
    private int repeat;
    private Insets margin = new Insets();
    private Dimension size = new Dimension();
    private Rectangle clip;
    private static final Rectangle OLD_CLIP = new Rectangle();

    public ReportElementFigure() {
        this(null, 2);
    }

    public ReportElementFigure(Image image) {
        this(image, 2);
    }

    public ReportElementFigure(Image image, int alignment) {
        this.setImage(image);
        this.setAlignment(alignment);
    }

    public Image getImage() {
        return this.img;
    }

    public void setPageClip(Rectangle clip) {
        this.clip = clip;
    }

    protected void paintBorder(Graphics graphics) {
        if (this.clip != null) {
            graphics.getClip(OLD_CLIP);
            graphics.setClip(this.getBounds().getCopy().intersect(this.clip));
        }
        super.paintBorder(graphics);
        if (this.clip != null) {
            graphics.setClip(OLD_CLIP);
        }
    }

    protected void paintFigure(Graphics graphics) {
        int y;
        int x;
        Image image;
        if (this.isOpaque()) {
            if (this.getBorder() instanceof BaseBorder) {
                graphics.fillRectangle(this.getBounds().getCopy().crop(((BaseBorder)this.getBorder()).getBorderInsets()));
            } else {
                graphics.fillRectangle(this.getBounds());
            }
        }
        if ((image = this.getImage()) == null) {
            return;
        }
        Rectangle area = this.getBounds();
        graphics.getClip(PRIVATE_RECT);
        if (this.position != null && this.position.x != -1) {
            x = area.x + this.position.x;
        } else {
            switch (this.alignment & 0x18) {
                case 16: {
                    x = area.x + area.width - this.size.width;
                    break;
                }
                case 8: {
                    x = area.x;
                    break;
                }
                default: {
                    x = (area.width - this.size.width) / 2 + area.x;
                }
            }
        }
        if (this.position != null && this.position.y != -1) {
            y = area.y + this.position.y;
        } else {
            switch (this.alignment & 5) {
                case 1: {
                    y = area.y;
                    break;
                }
                case 4: {
                    y = area.y + area.height - this.size.height;
                    break;
                }
                default: {
                    y = (area.height - this.size.height) / 2 + area.y;
                }
            }
        }
        ArrayList xyList = this.createImageList(x, y);
        Iterator iter = xyList.iterator();
        Dimension imageSize = new Rectangle(image.getBounds()).getSize();
        while (iter.hasNext()) {
            Point point = (Point)iter.next();
            graphics.drawImage(image, 0, 0, imageSize.width, imageSize.height, point.x, point.y, this.size.width, this.size.height);
        }
        xyList.clear();
        graphics.setClip(PRIVATE_RECT);
    }

    private ArrayList createImageList(int x, int y) {
        Rectangle area = this.getBounds();
        ArrayList<Point> yList = new ArrayList<Point>();
        if ((this.repeat & 2) == 0) {
            yList.add(new Point(x, y));
        } else {
            int i = 0;
            while (y + this.size.height * i + this.size.height > area.y) {
                yList.add(new Point(x, y + this.size.height * i));
                --i;
            }
            i = 1;
            while (y + this.size.height * i < area.y + area.height) {
                yList.add(new Point(x, y + this.size.height * i));
                ++i;
            }
        }
        ArrayList<Point> xyList = new ArrayList<Point>();
        for (Point point : yList) {
            if ((this.repeat & 1) == 0) {
                xyList.add(point);
                continue;
            }
            int i = 0;
            while (point.x + this.size.width * i + this.size.width > area.x) {
                xyList.add(new Point(point.x + this.size.width * i, point.y));
                --i;
            }
            i = 1;
            while (point.x + this.size.width * i < area.x + area.width) {
                xyList.add(new Point(point.x + this.size.width * i, point.y));
                ++i;
            }
        }
        yList.clear();
        return xyList;
    }

    public void setAlignment(int flag) {
        this.alignment = flag;
    }

    public void setPosition(Point point) {
        this.position = point;
    }

    public void setRepeat(int flag) {
        this.repeat = flag;
    }

    public void setImage(Image image) {
        if (this.img == image) {
            return;
        }
        this.img = image;
        this.size = this.img != null ? new Rectangle(image.getBounds()).getSize() : new Dimension();
        this.revalidate();
        this.repaint();
    }

    public void setMargin(Insets newMargin) {
        if (newMargin == null) {
            this.margin = new Insets();
        } else {
            this.margin = new Insets(newMargin);
            if (this.margin.left < 0) {
                this.margin.left = 0;
            }
            if (this.margin.right < 0) {
                this.margin.right = 0;
            }
            if (this.margin.top < 0) {
                this.margin.top = 0;
            }
            if (this.margin.bottom < 0) {
                this.margin.bottom = 0;
            }
        }
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void fireMoved() {
        super.fireMoved();
    }

    public Dimension getFixPreferredSize(int w, int h) {
        return this.getPreferredSize(w, h);
    }

    public Dimension getFixMinimumSize(int w, int h) {
        return this.getMinimumSize(w, h);
    }

    public void setBackGroundImageSize(int backGroundImageWidth, int backGroundImageHeight) {
        if (this.img == null) {
            return;
        }
        Dimension ori = new Rectangle(this.img.getBounds()).getSize();
        if (backGroundImageWidth <= 0 && backGroundImageHeight <= 0) {
            this.size = ori;
            return;
        }
        if (backGroundImageWidth <= 0) {
            backGroundImageWidth = (int)((double)ori.width * ((double)backGroundImageHeight / (double)ori.height));
        } else if (backGroundImageHeight <= 0) {
            backGroundImageHeight = (int)((double)ori.height * ((double)backGroundImageWidth / (double)ori.width));
        }
        if (backGroundImageWidth <= 0 || backGroundImageHeight <= 0) {
            return;
        }
        this.size.width = backGroundImageWidth;
        this.size.height = backGroundImageHeight;
    }
}

