/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.expressions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.expressions.DefaultExpressionContext;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionContext;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionContextFactory;
import org.eclipse.birt.report.designer.internal.ui.script.JSExpressionContext;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.expressions.IExpressionFilterSupport;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionContextFactoryImpl
implements IExpressionContextFactory {
    private Map<String, IExpressionContext> contexts;
    private List<ExpressionFilter> filters;

    public ExpressionContextFactoryImpl(Object contextObj, IExpressionProvider javaScriptExpressionProvider) {
        this.contexts = new HashMap<String, IExpressionContext>();
        this.contexts.put("javascript", new JSExpressionContext(javaScriptExpressionProvider, contextObj));
        if (javaScriptExpressionProvider instanceof IExpressionFilterSupport) {
            this.filters = ((IExpressionFilterSupport)((Object)javaScriptExpressionProvider)).getFilters();
        }
    }

    public ExpressionContextFactoryImpl(Map<String, IExpressionContext> contexts) {
        this.contexts = contexts;
    }

    @Override
    public IExpressionContext getContext(String expressionType, Object contextObj) {
        IExpressionContext cxt;
        IExpressionContextFactory factory = (IExpressionContextFactory)ElementAdapterManager.getAdapter(this, IExpressionContextFactory.class);
        if (factory != null && (cxt = factory.getContext(expressionType, contextObj)) != null) {
            if (cxt instanceof IExpressionFilterSupport) {
                ((IExpressionFilterSupport)((Object)cxt)).setFilters(this.filters);
            } else {
                return cxt;
            }
        }
        if ((cxt = this.contexts.get(expressionType)) == null) {
            DefaultExpressionContext defaultCxt = new DefaultExpressionContext(contextObj);
            defaultCxt.setFilters(this.filters);
            return defaultCxt;
        }
        return cxt;
    }
}

