/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.resourcelocator;

import org.eclipse.birt.report.designer.nls.Messages;

public class ResourceFilter {
    public static final String FILTER_CVS_RESOURCES = "cvs";
    public static final String FILTER_DATA_RESOURCES = "data";
    public static final String FILTER_DOT_RESOURCES = ".";
    public static final String FILTER_EMPTY_FOLDERS = "empty_folder";
    private String type = "";
    private String displayName = "";
    private boolean isEnabled;
    private String description = "";

    public ResourceFilter() {
    }

    public ResourceFilter(String type, String displayName, boolean isEnabled) {
        this.setType(type);
        this.setDisplayName(displayName);
        this.setEnabled(isEnabled);
    }

    public ResourceFilter(String type, String displayName, boolean isEnabled, String helpContent) {
        this.setType(type);
        this.setDisplayName(displayName);
        this.setEnabled(isEnabled);
        this.setDescription(helpContent);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public static ResourceFilter generateCVSFilter() {
        return new ResourceFilter(FILTER_CVS_RESOURCES, Messages.getString((String)"ResourceFilter.DisplayName.CVS"), true, Messages.getString((String)"ResourceFilter.Description.CVS"));
    }

    public static ResourceFilter generateDotResourceFilter() {
        return new ResourceFilter(FILTER_DOT_RESOURCES, Messages.getString((String)"ResourceFilter.DisplayName.Dot"), true, Messages.getString((String)"ResourceFilter.Description.Dot"));
    }

    public static ResourceFilter generateEmptyFolderFilter() {
        return new ResourceFilter(FILTER_EMPTY_FOLDERS, Messages.getString((String)"ResourceFilter.DisplayName.EmptyFolder"), false, Messages.getString((String)"ResourceFilter.Description.EmptyFolder"));
    }

    public static ResourceFilter generateDataResourceFilter() {
        return new ResourceFilter(FILTER_DATA_RESOURCES, Messages.getString((String)"ResourceFilter.DisplayName.Data"), true, Messages.getString((String)"ResourceFilter.Description.Data"));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }
}

