/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.DeclarationVisitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.internal.declaration.ASTBasedDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorType;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;

public class SourceParameterDeclarationImpl
extends ASTBasedDeclarationImpl
implements ParameterDeclaration {
    public SourceParameterDeclarationImpl(SingleVariableDeclaration astNode, IFile file, BaseProcessorEnv env) {
        super((ASTNode)astNode, file, env);
    }

    public void accept(DeclarationVisitor visitor) {
        visitor.visitParameterDeclaration(this);
    }

    public TypeMirror getType() {
        SingleVariableDeclaration astNode = this.getAstNode();
        Type type = astNode.getType();
        if (type == null) {
            return Factory.createErrorClassType("");
        }
        IVariableBinding varBinding = astNode.resolveBinding();
        if (varBinding == null) {
            String typeName = type.toString();
            if (astNode.isVarargs()) {
                return Factory.createErrorArrayType(typeName, 1);
            }
            return Factory.createErrorClassType(typeName);
        }
        ITypeBinding typeBinding = varBinding.getType();
        if (typeBinding == null) {
            String typeName = type.toString();
            if (astNode.isVarargs()) {
                return Factory.createErrorArrayType(typeName, 1);
            }
            return Factory.createErrorClassType(typeName);
        }
        EclipseMirrorType mirrorType = Factory.createTypeMirror(typeBinding, this._env);
        if (mirrorType == null) {
            return Factory.createErrorClassType(type.toString());
        }
        return mirrorType;
    }

    public String getSimpleName() {
        SimpleName nameNode = this.getAstNode().getName();
        return nameNode == null ? "" : nameNode.toString();
    }

    public String getDocComment() {
        return "";
    }

    SingleVariableDeclaration getAstNode() {
        return (SingleVariableDeclaration)this._astNode;
    }

    public EclipseMirrorObject.MirrorKind kind() {
        return EclipseMirrorObject.MirrorKind.FORMAL_PARAMETER;
    }

    public String toString() {
        return this._astNode.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SourceParameterDeclarationImpl) {
            SourceParameterDeclarationImpl otherParam = (SourceParameterDeclarationImpl)obj;
            return this._astNode == otherParam._astNode;
        }
        return false;
    }

    public int hashCode() {
        return this._astNode.hashCode();
    }
}

