/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.birt.data.engine.cache.ICachedObject;
import org.eclipse.birt.data.engine.cache.ICachedObjectCreator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBoundaryInfoCreator;

final class GroupBoundaryInfo
implements ICachedObject {
    private int startIndex;
    private int endIndex;
    private Object[] sortKeys;
    private boolean[] sortDirections;
    private boolean accept = true;
    private Collator[] comparator;

    public static ICachedObjectCreator getCreator() {
        return new GroupBoundaryInfoCreator();
    }

    GroupBoundaryInfo(int start, int end) {
        this.startIndex = start;
        this.endIndex = end;
        this.sortKeys = new Object[0];
    }

    public Object[] getFieldValues() {
        int i;
        ArrayList<Object> fields = new ArrayList<Object>();
        fields.add(new Integer(this.startIndex));
        fields.add(new Integer(this.endIndex));
        if (this.sortKeys != null) {
            fields.add(new Integer(this.sortKeys.length));
            i = 0;
            while (i < this.sortKeys.length) {
                fields.add(this.sortKeys[i]);
                ++i;
            }
        } else {
            fields.add(null);
        }
        if (this.sortDirections != null) {
            fields.add(new Integer(this.sortDirections.length));
            i = 0;
            while (i < this.sortDirections.length) {
                fields.add(new Boolean(this.sortDirections[i]));
                ++i;
            }
        } else {
            fields.add(null);
        }
        if (this.comparator != null) {
            fields.add(new Integer(this.comparator.length));
            i = 0;
            while (i < this.comparator.length) {
                fields.add(this.comparator[i] == null ? -1 : new Integer(this.comparator[i].getStrength()));
                ++i;
            }
            i = 0;
            while (i < this.comparator.length) {
                fields.add(this.comparator[i] == null ? null : this.comparator[i].getLocale(ULocale.ACTUAL_LOCALE).getBaseName());
                ++i;
            }
        } else {
            fields.add(null);
        }
        fields.add(new Boolean(this.accept));
        return fields.toArray();
    }

    int getStartIndex() {
        return this.startIndex;
    }

    int getEndIndex() {
        return this.endIndex;
    }

    boolean isInBoundary(GroupBoundaryInfo gbi) {
        return gbi.getStartIndex() >= this.getStartIndex() && gbi.getEndIndex() <= this.getEndIndex();
    }

    void setSortCondition(Object[] sortKeys, boolean[] sortOrderings, int[] sortStrength, ULocale[] sortLocale) {
        this.sortKeys = sortKeys;
        this.sortDirections = sortOrderings;
        this.comparator = new Collator[this.sortKeys.length];
        int i = 0;
        while (i < this.comparator.length) {
            this.comparator[i] = sortStrength[i] == -1 ? null : Collator.getInstance((ULocale)sortLocale[i]);
            ++i;
        }
    }

    Object[] getSortKeys() {
        return this.sortKeys;
    }

    boolean[] getSortDirection() {
        return this.sortDirections;
    }

    Comparator[] getCollarComparator() {
        return this.comparator;
    }

    void setAccepted(boolean accept) {
        this.accept = accept;
    }

    boolean isAccpted() {
        return this.accept;
    }
}

