/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ICompiledScript;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.NEvaluator;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

public class ExprEvaluateUtil {
    public static Object evaluateExpression(IBaseExpression dataExpr, IResultIterator odiResult, Scriptable scope, ScriptContext cx) throws BirtException {
        Object exprValue = null;
        if (dataExpr == null) {
            throw new DataException("data.engine.BadDataExpression");
        }
        Object handle = dataExpr.getHandle();
        if (handle instanceof ICompiledScript) {
            return cx.newContext((Object)scope).evaluate((ICompiledScript)handle);
        }
        if (handle instanceof CompiledExpression) {
            CompiledExpression expr = (CompiledExpression)handle;
            Object value = ExprEvaluateUtil.evaluateCompiledExpression(expr, odiResult, scope, cx);
            try {
                if (value instanceof BirtException) {
                    throw (BirtException)((Object)value);
                }
                exprValue = DataTypeUtil.convert((Object)value, (int)dataExpr.getDataType());
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        } else if (handle instanceof ConditionalExpression) {
            ConditionalExpression ce = (ConditionalExpression)handle;
            Object resultExpr = ExprEvaluateUtil.evaluateExpression(ce.getExpression(), odiResult, scope, cx);
            Object[] op1Value = new Object[]{};
            Object[] op2Value = new Object[]{};
            boolean isCombined = false;
            if (ce.getOperand1() != null) {
                if (ce.getOperand1() instanceof IScriptExpression) {
                    op1Value = new Object[]{ExprEvaluateUtil.evaluateExpression(ce.getOperand1(), odiResult, scope, cx)};
                } else if (ce.getOperand1() instanceof IExpressionCollection) {
                    isCombined = true;
                    Object[] exprs = ((IExpressionCollection)ce.getOperand1()).getExpressions().toArray();
                    int length = exprs.length;
                    Object[] result = new Object[length];
                    int i = 0;
                    while (i < length) {
                        result[i] = ExprEvaluateUtil.evaluateExpression((IBaseExpression)exprs[i], odiResult, scope, cx);
                        ++i;
                    }
                    op1Value = ExprEvaluateUtil.flatternMultipleValues(result);
                }
            }
            if (ce.getOperand2() != null && ce.getOperand2() instanceof IScriptExpression) {
                op2Value = new Object[]{ExprEvaluateUtil.evaluateExpression(ce.getOperand2(), odiResult, scope, cx)};
            }
            exprValue = isCombined ? ScriptEvalUtil.evalConditionalExpr(resultExpr, ce.getOperator(), op1Value) : ScriptEvalUtil.evalConditionalExpr(resultExpr, ce.getOperator(), op1Value.length > 0 ? op1Value[0] : null, op2Value.length > 0 ? op2Value[0] : null);
        } else {
            DataException e = new DataException("data.engine.InvalidExprHandle");
            throw e;
        }
        return exprValue;
    }

    public static Object evaluateCompiledExpression(CompiledExpression expr, IResultObject ro, int currentIndex, Scriptable scope, ScriptContext cx) throws DataException {
        if (expr instanceof ColumnReferenceExpression) {
            ColumnReferenceExpression colref = (ColumnReferenceExpression)expr;
            if (colref.isIndexed()) {
                int idx = colref.getColumnindex();
                if (idx == 0) {
                    return new Integer(currentIndex);
                }
                if (ro != null) {
                    try {
                        return DataTypeUtil.convert((Object)ro.getFieldValue(idx), (int)colref.getDataType());
                    }
                    catch (BirtException e) {
                        throw DataException.wrap(e);
                    }
                }
                return null;
            }
            String name = colref.getColumnName();
            if ("_rowPosition".equals(name)) {
                return new Integer(currentIndex);
            }
            if (ro != null) {
                try {
                    return DataTypeUtil.convert((Object)ro.getFieldValue(name), (int)colref.getDataType());
                }
                catch (BirtException e) {
                    throw DataException.wrap(e);
                }
            }
            return null;
        }
        return expr.evaluate(cx, scope);
    }

    public static Object evaluateCompiledExpression(CompiledExpression expr, IResultIterator odiResult, Scriptable scope, ScriptContext cx) throws DataException {
        return ExprEvaluateUtil.evaluateCompiledExpression(expr, odiResult.getCurrentResult(), odiResult.getCurrentResultIndex(), scope, cx);
    }

    public static Object evaluateRawExpression(IBaseExpression dataExpr, Scriptable scope, ScriptContext cx) throws BirtException {
        return ExprEvaluateUtil.doEvaluateRawExpression(dataExpr, scope, false, cx);
    }

    public static Object evaluateRawExpression2(IBaseExpression dataExpr, Scriptable scope, ScriptContext cx) throws BirtException {
        return ExprEvaluateUtil.doEvaluateRawExpression(dataExpr, scope, true, cx);
    }

    private static Object doEvaluateRawExpression(IBaseExpression dataExpr, Scriptable scope, boolean javaType, ScriptContext cx) throws BirtException {
        if (dataExpr == null) {
            return null;
        }
        if (dataExpr instanceof IScriptExpression) {
            if (((IScriptExpression)dataExpr).getText() == null) {
                throw new DataException("data.engine.EmptyExpression");
            }
            Object value = ScriptEvalUtil.evaluateJSAsExpr(cx, scope, ((IScriptExpression)dataExpr).getText(), null, 0);
            if (javaType) {
                value = JavascriptEvalUtil.convertJavascriptValue((Object)value);
            }
            value = DataTypeUtil.convert((Object)value, (int)dataExpr.getDataType());
            return value;
        }
        if (dataExpr instanceof IConditionalExpression) {
            if (dataExpr.getHandle() != null) {
                return new Boolean(((NEvaluator)dataExpr.getHandle()).evaluate(cx, scope));
            }
            IScriptExpression opr = ((IConditionalExpression)dataExpr).getExpression();
            int oper = ((IConditionalExpression)dataExpr).getOperator();
            IBaseExpression operand1 = ((IConditionalExpression)dataExpr).getOperand1();
            IBaseExpression operand2 = ((IConditionalExpression)dataExpr).getOperand2();
            if (operand1 instanceof IExpressionCollection) {
                Object[] expr = ((IExpressionCollection)operand1).getExpressions().toArray();
                Object[] result = new Object[expr.length];
                int i = 0;
                while (i < result.length) {
                    result[i] = ExprEvaluateUtil.doEvaluateRawExpression((IBaseExpression)expr[i], scope, javaType, cx);
                    ++i;
                }
                return ScriptEvalUtil.evalConditionalExpr(ExprEvaluateUtil.doEvaluateRawExpression(opr, scope, javaType, cx), oper, ExprEvaluateUtil.flatternMultipleValues(result));
            }
            return ScriptEvalUtil.evalConditionalExpr(ExprEvaluateUtil.doEvaluateRawExpression(opr, scope, javaType, cx), oper, ExprEvaluateUtil.doEvaluateRawExpression(operand1, scope, javaType, cx), ExprEvaluateUtil.doEvaluateRawExpression(operand2, scope, javaType, cx));
        }
        assert (false);
        return null;
    }

    public static Object evaluateValue(IBaseExpression dataExpr, int index, IResultObject roObject, Scriptable scope, ScriptContext cx) throws BirtException {
        Object handle;
        Object exprValue = null;
        Object object = handle = dataExpr == null ? null : dataExpr.getHandle();
        if (handle instanceof ICompiledScript) {
            return cx.newContext((Object)scope).evaluate((ICompiledScript)handle);
        }
        if (handle instanceof CompiledExpression) {
            CompiledExpression expr = (CompiledExpression)handle;
            Object value = ExprEvaluateUtil.evaluateCompiledExpression(expr, index, roObject, scope, cx);
            try {
                exprValue = DataTypeUtil.convert((Object)value, (int)dataExpr.getDataType());
            }
            catch (BirtException birtException) {
                throw new DataException("data.engine.InconvertibleDatatype", new Object[]{value, value.getClass(), DataType.getClass((int)dataExpr.getDataType())});
            }
        } else if (dataExpr instanceof ConditionalExpression) {
            int i;
            Object[] result;
            int length;
            Object[] exprs;
            ConditionalExpression ce = (ConditionalExpression)dataExpr;
            Object resultExpr = ExprEvaluateUtil.evaluateValue(ce.getExpression(), index, roObject, scope, cx);
            Object[] op1Value = new Object[]{};
            Object[] op2Value = new Object[]{};
            boolean isCombined = false;
            if (ce.getOperand1() != null) {
                if (ce.getOperand1() instanceof IScriptExpression) {
                    op1Value = new Object[]{ExprEvaluateUtil.evaluateValue(ce.getOperand1(), index, roObject, scope, cx)};
                } else if (ce.getOperand1() instanceof IExpressionCollection) {
                    isCombined = true;
                    exprs = ((IExpressionCollection)ce.getOperand1()).getExpressions().toArray();
                    length = exprs.length;
                    result = new Object[length];
                    i = 0;
                    while (i < length) {
                        result[i] = ExprEvaluateUtil.evaluateValue((IBaseExpression)exprs[i], index, roObject, scope, cx);
                        ++i;
                    }
                    op1Value = ExprEvaluateUtil.flatternMultipleValues(result);
                }
            }
            if (ce.getOperand2() != null) {
                if (ce.getOperand2() instanceof IScriptExpression) {
                    op2Value = new Object[]{ExprEvaluateUtil.evaluateValue(ce.getOperand2(), index, roObject, scope, cx)};
                } else if (ce.getOperand2() instanceof IExpressionCollection) {
                    exprs = ((IExpressionCollection)ce.getOperand2()).getExpressions().toArray();
                    length = exprs.length;
                    result = new Object[length];
                    i = 0;
                    while (i < length) {
                        result[i] = ExprEvaluateUtil.evaluateValue((IBaseExpression)exprs[i], index, roObject, scope, cx);
                        ++i;
                    }
                    op2Value = ExprEvaluateUtil.flatternMultipleValues(result);
                }
            }
            exprValue = isCombined ? ScriptEvalUtil.evalConditionalExpr(resultExpr, ce.getOperator(), op1Value) : ScriptEvalUtil.evalConditionalExpr(resultExpr, ce.getOperator(), op1Value.length > 0 ? op1Value[0] : null, op2Value.length > 0 ? op2Value[0] : null);
        } else {
            DataException e = new DataException("data.engine.InvalidExprHandle");
            throw e;
        }
        return exprValue;
    }

    private static Object evaluateCompiledExpression(CompiledExpression expr, int index, IResultObject roObject, Scriptable scope, ScriptContext cx) throws DataException {
        if (expr instanceof ColumnReferenceExpression) {
            ColumnReferenceExpression colref = (ColumnReferenceExpression)expr;
            if (colref.isIndexed()) {
                int idx = colref.getColumnindex();
                if (idx == 0) {
                    return new Integer(index);
                }
                if (roObject != null) {
                    return roObject.getFieldValue(idx);
                }
                return null;
            }
            String name = colref.getColumnName();
            if ("_rowPosition".equals(name)) {
                return new Integer(index);
            }
            if (roObject != null) {
                return roObject.getFieldValue(name);
            }
            return null;
        }
        return expr.evaluate(cx, scope);
    }

    private static Object[] flatternMultipleValues(Object[] values) {
        if (values == null || values.length == 0) {
            return new Object[0];
        }
        ArrayList<Object> flattern = new ArrayList<Object>();
        int i = 0;
        while (i < values.length) {
            if (values[i] instanceof Object[]) {
                Object[] flatternObj = (Object[])values[i];
                flattern.addAll(Arrays.asList(ExprEvaluateUtil.flatternMultipleValues(flatternObj)));
            } else {
                flattern.add(values[i]);
            }
            ++i;
        }
        return flattern.toArray();
    }
}

