/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.IQueryService;
import org.eclipse.birt.data.engine.impl.IServiceForQueryResults;
import org.eclipse.birt.data.engine.impl.IServiceForResultSet;
import org.eclipse.birt.data.engine.impl.NamingRelationUtil;
import org.eclipse.birt.data.engine.impl.PreparedDummyQuery;
import org.eclipse.birt.data.engine.impl.PreparedQueryUtil;
import org.eclipse.birt.data.engine.impl.QueryResultsUtil;
import org.eclipse.birt.data.engine.impl.ResultIterator;
import org.eclipse.birt.data.engine.impl.ResultIterator2;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.StreamWrapper;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.mozilla.javascript.Scriptable;

public class QueryResults
implements IQueryResults,
IQueryService {
    private IServiceForQueryResults queryService;
    private DataEngineSession session;
    private Scriptable queryScope;
    private int nestedLevel;
    private String rootQueryResultID;
    private String selfQueryResultID;
    private IResultIterator iterator;
    private static Logger logger = Logger.getLogger(QueryResults.class.getName());
    private String name;

    QueryResults(IServiceForQueryResults queryService) throws DataException {
        logger.entering(QueryResults.class.getName(), "QueryResults", queryService);
        assert (queryService != null);
        this.queryService = queryService;
        this.session = queryService.getSession();
        this.queryScope = queryService.getScope();
        this.nestedLevel = queryService.getNestedLevel();
        logger.exiting(QueryResults.class.getName(), "QueryResults");
    }

    public String getID() {
        if (this.selfQueryResultID == null) {
            this.selfQueryResultID = this.session.getQueryResultIDUtil().nextID();
        }
        return QueryResultIDUtil.buildID(this.rootQueryResultID, this.selfQueryResultID);
    }

    public IPreparedQuery getPreparedQuery() {
        return this.queryService.getPreparedQuery();
    }

    public IResultMetaData getResultMetaData() throws DataException {
        if (this.queryService == null) {
            throw new DataException("data.engine.ResultClosed");
        }
        return this.queryService.getResultMetaData();
    }

    public IResultIterator getResultIterator() throws DataException {
        this.session.getStopSign().start();
        if (this.queryService == null) {
            throw new DataException("data.engine.ResultClosed");
        }
        try {
            if (this.iterator == null) {
                this.queryService.initAutoBinding();
                this.queryService.validateQuery();
                org.eclipse.birt.data.engine.odi.IResultIterator odiIterator = this.queryService.executeQuery();
                if (this.queryService.getQueryDefn() instanceof IQueryDefinition) {
                    this.iterator = QueryResultsUtil.processOdiResult(this.session, this, (IQueryDefinition)this.queryService.getQueryDefn(), odiIterator, ((IQueryDefinition)this.queryService.getQueryDefn()).getDataSetName());
                    if (this.iterator != null) {
                        return this.iterator;
                    }
                }
                this.iterator = this.isDummyQuery(odiIterator) ? new DummyResultIterator(new ResultService(this.session, this), odiIterator, this.queryScope, this.queryService.getStartingRawID()) : (this.queryService.getQueryDefn() instanceof IQueryDefinition && ((IQueryDefinition)this.queryService.getQueryDefn()).isSummaryQuery() ? new ResultIterator2(new ResultService(this.session, this), odiIterator, this.queryScope, this.queryService.getStartingRawID()) : (this.queryService.getQueryDefn().usesDetails() || this.queryService.getQueryDefn().cacheQueryResults() ? new ResultIterator(new ResultService(this.session, this), odiIterator, this.queryScope, this.queryService.getStartingRawID()) : new ResultIterator2(new ResultService(this.session, this), odiIterator, this.queryScope, this.queryService.getStartingRawID())));
            }
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
        logger.logp(Level.FINE, QueryResults.class.getName(), "getResultIterator", "finished");
        return this.iterator;
    }

    private boolean isDummyQuery(org.eclipse.birt.data.engine.odi.IResultIterator odiIterator) throws DataException {
        return this.queryService.getQueryDefn() instanceof IQueryDefinition && ((IQueryDefinition)this.queryService.getQueryDefn()).getDataSetName() == null && (odiIterator.getResultClass().getFieldCount() == 0 || odiIterator.getResultClass().getFieldCount() == 1 && odiIterator.getResultClass().getFieldName(1).equals("_$$_dte_inner_row_id_$$_"));
    }

    public void close() throws BirtException {
        if (this.queryService == null) {
            return;
        }
        NamingRelationUtil.merge(this.session, this.queryService.getQueryDefn(), this);
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
        this.queryService.close();
        this.queryService = null;
        logger.logp(Level.FINE, QueryResults.class.getName(), "close", "QueryResults is closed");
    }

    void setID(String rootQueryResultID, String selfQueryResultID) {
        this.rootQueryResultID = rootQueryResultID;
        this.selfQueryResultID = selfQueryResultID;
    }

    void setID(String selfQueryResultID) {
        this.setID(null, selfQueryResultID);
    }

    int getGroupLevel() {
        return this.queryService.getGroupLevel();
    }

    public IServiceForQueryResults getQueryService() {
        return this.queryService;
    }

    public boolean isClosed() {
        return this.queryService == null;
    }

    public int getNestedLevel() {
        return this.nestedLevel;
    }

    public Scriptable getQueryScope() {
        return this.queryScope;
    }

    public IExecutorHelper getExecutorHelper() throws DataException {
        if (this.getResultIterator() instanceof ResultIterator) {
            return ((ResultIterator)this.getResultIterator()).getOdiResult().getExecutorHelper();
        }
        return null;
    }

    public DataSetRuntime[] getDataSetRuntime(int count) {
        return this.queryService.getDataSetRuntimes(count);
    }

    public void cancel() {
        this.session.getStopSign().stop();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private class DummyOdiResultIterator
    extends CachedResultSet {
        private boolean isFirstRowFetched = false;
        private org.eclipse.birt.data.engine.odi.IResultIterator prototype = null;

        DummyOdiResultIterator(org.eclipse.birt.data.engine.odi.IResultIterator result) {
            this.prototype = result;
        }

        public void close() {
        }

        public void doSave(StreamWrapper streamsWrapper, boolean isSubQuery) throws DataException {
            try {
                if (streamsWrapper.getStreamForResultClass() != null) {
                    IOUtil.writeInt((OutputStream)streamsWrapper.getStreamForResultClass(), (int)0);
                    streamsWrapper.getStreamForResultClass().close();
                    if (streamsWrapper.getStreamForDataSet() != null) {
                        IOUtil.writeInt((OutputStream)streamsWrapper.getStreamForDataSet(), (int)0);
                        streamsWrapper.getStreamForDataSet().close();
                    }
                    if (streamsWrapper.getStreamForDataSetRowLens() != null) {
                        IOUtil.writeLong((DataOutputStream)streamsWrapper.getStreamForDataSetRowLens(), (long)0L);
                        streamsWrapper.getStreamForDataSetRowLens().close();
                    }
                }
                IOUtil.writeInt((OutputStream)streamsWrapper.getStreamForGroupInfo(), (int)0);
            }
            catch (IOException e) {
                throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Class");
            }
        }

        public void first(int groupingLevel) throws DataException {
            this.prototype.first(groupingLevel);
        }

        public int getCurrentGroupIndex(int groupLevel) throws DataException {
            return 0;
        }

        public IResultObject getCurrentResult() throws DataException {
            return this.prototype.getCurrentResult();
        }

        public int getCurrentResultIndex() throws DataException {
            return 0;
        }

        public int getEndingGroupLevel() throws DataException {
            return 0;
        }

        public IExecutorHelper getExecutorHelper() {
            return this.prototype.getExecutorHelper();
        }

        public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
            return this.prototype.getGroupStartAndEndIndex(groupLevel);
        }

        public IResultClass getResultClass() throws DataException {
            return this.prototype.getResultClass();
        }

        public ResultSetCache getResultSetCache() {
            return this.prototype.getResultSetCache();
        }

        public int getRowCount() throws DataException {
            return 1;
        }

        public int getStartingGroupLevel() throws DataException {
            return 0;
        }

        public void last(int groupingLevel) throws DataException {
            this.prototype.last(groupingLevel);
        }

        public boolean next() throws DataException {
            if (!this.isFirstRowFetched) {
                this.isFirstRowFetched = true;
                return true;
            }
            return false;
        }
    }

    private class DummyResultIterator
    extends ResultIterator {
        DummyResultIterator(IServiceForResultSet rService, org.eclipse.birt.data.engine.odi.IResultIterator odiResult, Scriptable scope, int staringRawId) throws DataException {
            super(rService, new DummyOdiResultIterator(odiResult), scope, staringRawId);
        }

        public boolean next() throws DataException {
            return this.getOdiResult().next();
        }

        public IResultIterator getSecondaryIterator(String subQueryName, Scriptable subScope) throws DataException {
            Collection subQueries = this.getQueryResults().getPreparedQuery().getReportQueryDefn().getSubqueries();
            Iterator subIt = subQueries.iterator();
            HashMap<String, ISubqueryDefinition> subQueryMap = new HashMap<String, ISubqueryDefinition>();
            while (subIt.hasNext()) {
                ISubqueryDefinition subquery = (ISubqueryDefinition)subIt.next();
                PreparedQueryUtil.mappingParentColumnBinding(subquery);
                subQueryMap.put(subquery.getName(), subquery);
            }
            PreparedDummyQuery preparedQuery = new PreparedDummyQuery((ISubqueryDefinition)subQueryMap.get(subQueryName), QueryResults.this.session);
            try {
                IQueryResults queryResults = preparedQuery.executeQuery(subScope, subScope);
                return queryResults.getResultIterator();
            }
            catch (BirtException e) {
                throw new DataException(e.getMessage());
            }
        }

        public void close() throws BirtException {
            super.close();
        }
    }

    private static class ResultService
    implements IServiceForResultSet {
        private DataEngineSession session;
        private QueryResults queryResults;

        public ResultService(DataEngineSession session, QueryResults queryResults) {
            this.session = session;
            this.queryResults = queryResults;
        }

        public IQueryResults getQueryResults() {
            return this.queryResults;
        }

        public IBaseQueryDefinition getQueryDefn() {
            return this.queryResults.queryService.getQueryDefn();
        }

        public IQueryResults execSubquery(org.eclipse.birt.data.engine.odi.IResultIterator iterator, String subQueryName, Scriptable subScope) throws DataException {
            return this.queryResults.queryService.execSubquery(iterator, this.queryResults.queryService.getQueryExecutor(), subQueryName, subScope);
        }

        public IBaseExpression getBindingExpr(String exprName) throws DataException {
            return this.queryResults.queryService.getBindingExpr(exprName);
        }

        public IScriptExpression getAutoBindingExpr(String exprName) {
            return this.queryResults.queryService.getAutoBindingExpr(exprName);
        }

        public List getAllBindingExprs() {
            return this.queryResults.queryService.getAllBindingExprs();
        }

        public Map getAllAutoBindingExprs() {
            return this.queryResults.queryService.getAllAutoBindingExprs();
        }

        public DataEngineSession getSession() {
            return this.session;
        }
    }
}

