/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.aggregation.AggrInfo;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.GroupBindingColumn;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.IPreparedQueryService;
import org.eclipse.birt.data.engine.impl.IQueryExecutor;
import org.eclipse.birt.data.engine.impl.IServiceForQueryResults;
import org.eclipse.birt.data.engine.impl.ISubQueryExecutor;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedSubquery;
import org.eclipse.birt.data.engine.odi.IAggrInfo;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.JSResultSetRow;
import org.mozilla.javascript.Scriptable;

public class ServiceForQueryResults
implements IServiceForQueryResults {
    private DataEngineSession session;
    private IPreparedQueryService queryService;
    private IQueryExecutor queryExecutor;
    private PreparedDataSourceQuery reportQuery;
    private IBaseQueryDefinition queryDefn;
    private ExprManager exprManager;
    private Scriptable scope;
    private int nestedLevel;
    private int startingRawId;
    private static Logger logger = Logger.getLogger(ServiceForQueryResults.class.getName());

    public ServiceForQueryResults(DataEngineSession session, Scriptable scope, int nestedLevel, PreparedDataSourceQuery reportQuery, IPreparedQueryService query, IQueryExecutor queryExecutor, IBaseQueryDefinition queryDefn, ExprManager exprManager) throws DataException {
        Object[] params = new Object[]{session, scope, new Integer(nestedLevel), reportQuery, query, queryExecutor, queryDefn, exprManager};
        logger.entering(ServiceForQueryResults.class.getName(), "ServiceForQueryResults", params);
        assert (reportQuery != null && queryExecutor != null);
        this.session = session;
        this.scope = scope;
        this.nestedLevel = nestedLevel;
        this.reportQuery = reportQuery;
        this.queryService = query;
        this.queryExecutor = queryExecutor;
        this.queryDefn = queryDefn;
        this.exprManager = exprManager;
        this.startingRawId = this.calculateStartingIndex(queryExecutor);
        logger.exiting(ServiceForQueryResults.class.getName(), "ServiceForQueryResults");
    }

    private int calculateStartingIndex(IQueryExecutor queryExecutor) throws DataException {
        return queryExecutor instanceof ISubQueryExecutor ? ((ISubQueryExecutor)queryExecutor).getSubQueryStartingIndex() : 0;
    }

    public Scriptable getScope() {
        return this.scope;
    }

    public int getNestedLevel() {
        return this.nestedLevel;
    }

    public IBaseQueryDefinition getQueryDefn() {
        return this.queryDefn;
    }

    public IPreparedQuery getPreparedQuery() {
        return this.reportQuery;
    }

    public int getGroupLevel() {
        if (this.queryService instanceof PreparedSubquery) {
            PreparedSubquery subQuery = (PreparedSubquery)this.queryService;
            return subQuery.getGroupLevel();
        }
        return 0;
    }

    public DataSetRuntime getDataSetRuntime() {
        return this.queryExecutor.getDataSet();
    }

    public DataSetRuntime[] getDataSetRuntimes(int count) {
        assert (count >= 0);
        DataSetRuntime[] dsRuns = new DataSetRuntime[count];
        if (count > 1) {
            DataSetRuntime[] innerDsRuns = null;
            IQueryExecutor executor = this.queryExecutor;
            innerDsRuns = executor.getNestedDataSets(count - 1);
            int i = 0;
            while (i < count - 1) {
                dsRuns[i] = innerDsRuns[i];
                ++i;
            }
        }
        dsRuns[count - 1] = this.queryExecutor.getDataSet();
        return dsRuns;
    }

    public IResultMetaData getResultMetaData() throws DataException {
        return this.queryExecutor.getResultMetaData();
    }

    public IResultIterator executeQuery() throws DataException {
        this.queryExecutor.execute(new EventHandler());
        return this.queryExecutor.getOdiResultSet();
    }

    public IQueryResults execSubquery(IResultIterator iterator, IQueryExecutor parentExecutor, String subQueryName, Scriptable subScope) throws DataException {
        return this.queryService.execSubquery(iterator, parentExecutor, subQueryName, subScope);
    }

    public void close() {
        if (this.queryExecutor != null) {
            this.queryExecutor.close();
            this.queryExecutor = null;
        }
    }

    public void validateQuery() throws DataException {
        this.exprManager.validateColumnBinding();
        this.validateFilters();
        this.validateSorts();
    }

    public IBaseExpression getBindingExpr(String exprName) throws DataException {
        return this.exprManager.getExpr(exprName);
    }

    public IScriptExpression getAutoBindingExpr(String exprName) {
        return this.exprManager.getAutoBindingExpr(exprName);
    }

    public List getAllBindingExprs() {
        return this.exprManager.getBindingExprs();
    }

    public Map getAllAutoBindingExprs() {
        return this.exprManager.getAutoBindingExprMap();
    }

    public void initAutoBinding() throws DataException {
        if (!this.needAutoBinding()) {
            return;
        }
        IResultClass metaData = this.queryExecutor.getOdiResultClass();
        int columnCount = metaData.getFieldCount();
        int i = 0;
        while (i < columnCount) {
            int colIndex = i + 1;
            try {
                String colName = metaData.getFieldName(colIndex);
                if (!this.isTemp(colName)) {
                    Class odiDataType = metaData.getFieldValueClass(colIndex);
                    ScriptExpression baseExpr = new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)colName), DataTypeUtil.toApiDataType((Class)odiDataType));
                    CompiledExpression compiledExpr = ExpressionCompilerUtil.compile(baseExpr.getText(), this.session.getEngineContext().getScriptContext());
                    baseExpr.setHandle(compiledExpr);
                    this.exprManager.addAutoBindingExpr(colName, baseExpr);
                }
            }
            catch (BirtException birtException) {}
            ++i;
        }
    }

    private boolean isTemp(String name) {
        return name.matches("\\Q_{$TEMP_GROUP_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_SORT_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_FILTER_\\E\\d*\\Q$}_\\E");
    }

    private boolean needAutoBinding() {
        if (this.queryDefn instanceof IQueryDefinition) {
            return ((IQueryDefinition)this.queryDefn).needAutoBinding();
        }
        return false;
    }

    private void validateFilters() throws DataException {
        int i = 0;
        while (i < this.queryDefn.getFilters().size()) {
            IFilterDefinition filter = (IFilterDefinition)this.queryDefn.getFilters().get(i);
            if (this.hasRowNumRefExpr(filter.getExpression())) {
                throw new DataException("data.engine.filterExprContainRowNum");
            }
            ++i;
        }
    }

    private void validateSorts() throws DataException {
        int i = 0;
        while (i < this.queryDefn.getSorts().size()) {
            ISortDefinition sort = (ISortDefinition)this.queryDefn.getSorts().get(i);
            if (this.hasRowNumRefExpr(sort.getExpression())) {
                throw new DataException("data.engine.sortExprContainRowNum");
            }
            ++i;
        }
    }

    private boolean hasRowNumRefExpr(IBaseExpression expr) throws DataException {
        if (expr instanceof IScriptExpression) {
            return this.hasRowNumRefExpr((IScriptExpression)expr);
        }
        if (expr instanceof IConditionalExpression) {
            IConditionalExpression ce = (IConditionalExpression)expr;
            return this.hasRowNumRefExpr(ce.getExpression()) || this.hasRowNumRefExpr(ce.getOperand1()) || this.hasRowNumRefExpr(ce.getOperand2());
        }
        return false;
    }

    private boolean hasRowNumRefExpr(IScriptExpression expr) throws DataException {
        block5: {
            block4: {
                try {
                    if (expr != null && expr.getText() != null) break block4;
                    return false;
                }
                catch (BirtException e) {
                    throw new DataException(e.getLocalizedMessage());
                }
            }
            if (!expr.getText().matches(".*\\Qrow.__rownum\\E.*")) break block5;
            return true;
        }
        return this.findRowNumReferenceInBindings(ExpressionUtil.extractColumnExpressions((String)expr.getText()));
    }

    private boolean findRowNumReferenceInBindings(List bindingNames) throws DataException {
        int i = 0;
        while (i < bindingNames.size()) {
            IBinding binding = (IBinding)this.queryDefn.getBindings().get(((IColumnBinding)bindingNames.get(i)).getResultSetColumnName());
            if (binding == null) {
                return false;
            }
            IBaseExpression expr = binding.getExpression();
            if (this.hasRowNumRefExpr(expr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getStartingRawID() throws DataException {
        return this.startingRawId;
    }

    public IQueryExecutor getQueryExecutor() throws DataException {
        return this.queryExecutor;
    }

    public DataEngineSession getSession() {
        return this.session;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventHandler
    implements IEventHandler {
        private JSResultSetRow jsResultSetRow;
        private IExecutorHelper helper;

        private EventHandler() {
        }

        @Override
        public void handleEndOfDataSetProcess(IResultIterator resultIterator) throws DataException {
            this.jsResultSetRow = new JSResultSetRow(resultIterator, ServiceForQueryResults.this.exprManager, ServiceForQueryResults.this.queryExecutor.getQueryScope(), this.helper, ServiceForQueryResults.this.session.getEngineContext().getScriptContext());
            ServiceForQueryResults.this.getDataSetRuntime().setJSResultSetRow(this.jsResultSetRow);
            ServiceForQueryResults.this.getDataSetRuntime().setMode(DataSetRuntime.Mode.Query);
        }

        @Override
        public Object getValue(IResultObject rsObject, int index, String name) throws DataException {
            if (this.jsResultSetRow == null) {
                return rsObject.getFieldValue(index);
            }
            return this.jsResultSetRow.getValue(rsObject, index, name);
        }

        @Override
        public boolean isRowID(int index, String name) throws DataException {
            IBaseExpression baseExpr = ServiceForQueryResults.this.exprManager.getExpr(name);
            if (baseExpr instanceof IScriptExpression) {
                String exprText = ((IScriptExpression)baseExpr).getText();
                if (exprText == null) {
                    return false;
                }
                return exprText.trim().equalsIgnoreCase("dataSetRow[0]") || exprText.trim().equalsIgnoreCase("dataSetRow._rowPosition");
            }
            return false;
        }

        @Override
        public IBinding getBinding(String name) throws DataException {
            if (name == null) {
                return null;
            }
            return ServiceForQueryResults.this.exprManager.getBinding(name);
        }

        @Override
        public IExecutorHelper getExecutorHelper() {
            return this.helper;
        }

        @Override
        public void setExecutorHelper(IExecutorHelper helper) {
            this.helper = helper;
        }

        @Override
        public Map getColumnBindings() throws DataException {
            HashMap<String, IBinding> result = new HashMap<String, IBinding>();
            List groupBindingColumns = ServiceForQueryResults.this.exprManager.getBindingExprs();
            int i = 0;
            while (i < groupBindingColumns.size()) {
                GroupBindingColumn gbc = (GroupBindingColumn)groupBindingColumns.get(i);
                Iterator it = gbc.getColumnNames().iterator();
                while (it.hasNext()) {
                    String name = it.next().toString();
                    result.put(name, gbc.getBinding(name));
                }
                ++i;
            }
            return result;
        }

        @Override
        public List<IBinding> getAllColumnBindings() {
            return this.getColumnBindings(ServiceForQueryResults.this.queryDefn);
        }

        private List<IBinding> getColumnBindings(IBaseQueryDefinition defn) {
            ArrayList<IBinding> result = new ArrayList<IBinding>();
            for (Object key : defn.getBindings().keySet()) {
                result.add((IBinding)defn.getBindings().get(key));
            }
            result.addAll(this.populateGroupColumnBindings(defn.getGroups().iterator()));
            result.addAll(this.populateSubQueryColumnBindings(defn.getSubqueries().iterator()));
            return result;
        }

        private List<IBinding> populateGroupColumnBindings(Iterator groups) {
            ArrayList<IBinding> result = new ArrayList<IBinding>();
            while (groups.hasNext()) {
                IGroupDefinition gd = (IGroupDefinition)groups.next();
                result.addAll(this.populateSubQueryColumnBindings(gd.getSubqueries().iterator()));
            }
            return result;
        }

        private List<IBinding> populateSubQueryColumnBindings(Iterator subs) {
            ArrayList<IBinding> result = new ArrayList<IBinding>();
            while (subs.hasNext()) {
                IBaseQueryDefinition defn1 = (IBaseQueryDefinition)subs.next();
                result.addAll(this.getColumnBindings(defn1));
            }
            return result;
        }

        @Override
        public Map getAppContext() {
            return ServiceForQueryResults.this.queryExecutor.getAppContext();
        }

        @Override
        public List getAggrDefinitions() throws DataException {
            List result = this.populateAggrDefinitions();
            this.sort(result);
            return result;
        }

        private List populateAggrDefinitions() throws DataException {
            ArrayList result = new ArrayList();
            ExpressionCompiler compiler = new ExpressionCompiler();
            compiler.setDataSetMode(false);
            List groupBindingColumns = ServiceForQueryResults.this.exprManager.getBindingExprs();
            int i = 0;
            while (i < groupBindingColumns.size()) {
                GroupBindingColumn gbc = (GroupBindingColumn)groupBindingColumns.get(i);
                Iterator it = gbc.getColumnNames().iterator();
                while (it.hasNext()) {
                    String name = it.next().toString();
                    this.populateOneAggrDefinition(result, ServiceForQueryResults.this.session.getEngineContext().getScriptContext(), compiler, gbc, name);
                }
                ++i;
            }
            return result;
        }

        private void populateOneAggrDefinition(List result, ScriptContext cx, ExpressionCompiler compiler, GroupBindingColumn gbc, String name) throws DataException {
            IBinding binding = gbc.getBinding(name);
            if (this.isAggregationBinding(binding)) {
                ArrayList<IBaseExpression> argument = new ArrayList<IBaseExpression>(binding.getArguments());
                IAggrFunction aggrFunction = AggregationManager.getInstance().getAggregation(binding.getAggrFunction());
                if (binding.getExpression() != null) {
                    argument.add(0, binding.getExpression());
                }
                IBaseExpression[] compiledArgu = this.populateAggregationArgument(cx, compiler, binding, argument, aggrFunction);
                compiler.compile(binding.getFilter(), cx);
                AggrInfo aggrDefn = new AggrInfo(name, gbc.getGroupLevel(), aggrFunction, compiledArgu, binding.getFilter());
                result.add(aggrDefn);
            }
        }

        private boolean isAggregationBinding(IBinding binding) throws DataException {
            return binding.getAggrFunction() != null;
        }

        private IBaseExpression[] populateAggregationArgument(ScriptContext cx, ExpressionCompiler compiler, IBinding binding, List argument, IAggrFunction aggrFunction) throws DataException {
            IBaseExpression[] compiledArgu = new IBaseExpression[argument.size()];
            int j = 0;
            while (j < argument.size()) {
                IScriptExpression scriptExpr = (IScriptExpression)argument.get(j);
                compiler.compile(scriptExpr, cx);
                compiledArgu[j] = scriptExpr;
                ++j;
            }
            return compiledArgu;
        }

        private void sort(List aggrDefns) throws DataException {
            try {
                Map nameMap = this.populateBindingNameMap(aggrDefns);
                HashMap aggrRefMap = new HashMap();
                HashMap<String, Integer> aggrRefGroupLevelMap = new HashMap<String, Integer>();
                int i = 0;
                while (i < aggrDefns.size()) {
                    IAggrInfo aggrDefn = (IAggrInfo)aggrDefns.get(i);
                    ArrayList<IBaseExpression> exprs = new ArrayList<IBaseExpression>();
                    int x = 0;
                    while (x < aggrDefn.getArgument().length) {
                        exprs.add(aggrDefn.getArgument()[x]);
                        ++x;
                    }
                    if (aggrDefn.getFilter() != null) {
                        exprs.add(aggrDefn.getFilter());
                    }
                    HashSet aggrRefs = new HashSet();
                    HashSet aggrRefList = new HashSet();
                    boolean use0AggrLevel = this.popAggrRefFromExprs(aggrRefList, exprs, nameMap);
                    if (aggrRefList.size() > 0) {
                        aggrRefs.addAll(aggrRefList);
                    }
                    int groupLevel = 0;
                    int groupLevelInAggr = this.getGroupLevel(aggrRefs);
                    if (!use0AggrLevel) {
                        groupLevel = groupLevelInAggr;
                    }
                    aggrRefMap.put(aggrDefn.getName(), aggrRefs);
                    aggrRefGroupLevelMap.put(aggrDefn.getName(), new Integer(groupLevel));
                    ++i;
                }
                this.popualteCalcuateRound(aggrDefns, nameMap, aggrRefMap, aggrRefGroupLevelMap);
                this.sortAggrDefnsAccordingToCalLvl(aggrDefns);
            }
            catch (BirtException be) {
                throw DataException.wrap(be);
            }
        }

        private int getGroupLevel(Set aggrRefs) throws DataException {
            Iterator it = aggrRefs.iterator();
            int groupLevel = -1;
            while (it.hasNext()) {
                IAggrInfo aggr = (IAggrInfo)it.next();
                if (groupLevel == -1) {
                    groupLevel = aggr.getGroupLevel();
                }
                if (groupLevel == aggr.getGroupLevel()) continue;
                throw new DataException("data.engine.WrongNumAggrArgs", aggr.getName());
            }
            return groupLevel;
        }

        private void sortAggrDefnsAccordingToCalLvl(List aggrDefns) {
            Collections.sort(aggrDefns, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int round2;
                    if (!$assertionsDisabled && !(o1 instanceof IAggrInfo)) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !(o2 instanceof IAggrInfo)) {
                        throw new AssertionError();
                    }
                    int round1 = ((IAggrInfo)o1).getRound();
                    if (round1 == (round2 = ((IAggrInfo)o2).getRound())) {
                        return 0;
                    }
                    if (round1 > round2) {
                        return 1;
                    }
                    return -1;
                }
            });
        }

        private void popualteCalcuateRound(List aggrDefns, Map nameMap, Map aggrRefMap, Map aggrRefGroupLevelMap) {
            ArrayList aggrDefnsCopy = new ArrayList();
            aggrDefnsCopy.addAll(aggrDefns);
            int calculateRound = -1;
            while (aggrDefnsCopy.size() > 0) {
                ++calculateRound;
                ArrayList<IAggrInfo> removedNames = new ArrayList<IAggrInfo>();
                Iterator<Object> it = aggrRefMap.keySet().iterator();
                while (it.hasNext()) {
                    String name = it.next().toString();
                    IAggrInfo defn = (IAggrInfo)nameMap.get(name);
                    Set aggrRefList = (Set)aggrRefMap.get(name);
                    if (aggrRefList.size() != 0) continue;
                    defn.setRound(calculateRound);
                    defn.setCalculateLevel((Integer)aggrRefGroupLevelMap.get(name));
                    aggrDefnsCopy.remove(defn);
                    removedNames.add(defn);
                }
                int i = 0;
                while (i < removedNames.size()) {
                    aggrRefMap.remove(((IAggrInfo)removedNames.get(i)).getName());
                    ++i;
                }
                for (Set temp : aggrRefMap.values()) {
                    temp.removeAll(removedNames);
                }
            }
        }

        private Map populateBindingNameMap(List aggrDefns) {
            HashMap<String, IAggrInfo> nameMap = new HashMap<String, IAggrInfo>();
            int i = 0;
            while (i < aggrDefns.size()) {
                IAggrInfo aggrDefn = (IAggrInfo)aggrDefns.get(i);
                nameMap.put(aggrDefn.getName(), aggrDefn);
                ++i;
            }
            return nameMap;
        }

        private boolean hasDataSetRowReference(IScriptExpression expr) throws BirtException {
            return !ExpressionUtil.extractColumnExpressions((String)expr.getText(), (String)"dataSetRow").isEmpty();
        }

        private boolean popAggrRefFromExprs(Set aggrReferences, List exprs, Map aggrMap) throws DataException {
            boolean[] result = new boolean[exprs.size()];
            int i = 0;
            while (i < exprs.size()) {
                result[i] = this.popAggrRefFromBaseExpr(aggrReferences, (IBaseExpression)exprs.get(i), aggrMap);
                ++i;
            }
            boolean base = false;
            int i2 = 0;
            while (i2 < result.length) {
                if (!this.isConstantExpr((IBaseExpression)exprs.get(i2))) {
                    base = result[i2];
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < result.length) {
                if (!this.isConstantExpr((IBaseExpression)exprs.get(i2)) && result[i2] != base) {
                    throw new DataException("data.engine.AggrParamGroupLevelInconsistent");
                }
                ++i2;
            }
            return result.length == 0 ? false : base;
        }

        private boolean popAggrRefFromBaseExpr(Set aggrReferences, IBaseExpression expr, Map aggrMap) throws DataException {
            try {
                boolean result = false;
                if (expr instanceof IScriptExpression) {
                    result = this.popAggrRefFromScriptExpr(aggrReferences, (IScriptExpression)expr, aggrMap);
                } else if (expr instanceof IConditionalExpression) {
                    IConditionalExpression ce = (IConditionalExpression)expr;
                    result = this.popAggrRefFromScriptExpr(aggrReferences, ce.getExpression(), aggrMap) || this.popAggrRefFromBaseExpr(aggrReferences, ce.getOperand1(), aggrMap) || this.popAggrRefFromBaseExpr(aggrReferences, ce.getOperand2(), aggrMap);
                } else if (expr instanceof IExpressionCollection) {
                    IExpressionCollection ce = (IExpressionCollection)expr;
                    Object[] exprs = ce.getExpressions().toArray();
                    int i = 0;
                    while (i < exprs.length) {
                        if (this.popAggrRefFromBaseExpr(aggrReferences, (IBaseExpression)exprs[i], aggrMap)) {
                            result = true;
                            break;
                        }
                        ++i;
                    }
                }
                return result;
            }
            catch (BirtException be) {
                throw DataException.wrap(be);
            }
        }

        private boolean popAggrRefFromScriptExpr(Set aggrReferences, IScriptExpression expr, Map aggrMap) throws DataException {
            try {
                List usedRowReferences = ExpressionUtil.extractColumnExpressions((String)expr.getText());
                boolean result = this.hasDataSetRowReference(expr);
                int i = 0;
                while (i < usedRowReferences.size()) {
                    Object o = aggrMap.get(((IColumnBinding)usedRowReferences.get(i)).getResultSetColumnName());
                    if (o != null) {
                        aggrReferences.add(o);
                    } else {
                        result = result || this.popAggrRefFromBaseExpr(aggrReferences, this.getBinding(((IColumnBinding)usedRowReferences.get(i)).getResultSetColumnName()).getExpression(), aggrMap);
                    }
                    ++i;
                }
                return result;
            }
            catch (BirtException be) {
                throw DataException.wrap(be);
            }
        }

        private boolean isConstantExpr(IBaseExpression expr) throws DataException {
            if (expr == null) {
                return true;
            }
            if (!(expr instanceof IScriptExpression)) {
                return false;
            }
            try {
                return ExpressionUtil.extractColumnExpressions((String)((IScriptExpression)expr).getText()).isEmpty() && !this.hasDataSetRowReference((IScriptExpression)expr);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }
}

