/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.odaconsumer.ColumnHint;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.ResultSetMetaData;

class ProjectedColumns {
    private ArrayList m_columns;
    private int[] m_projectedIndices;
    private int m_baseColumnMetadataCount;
    private ResultSetMetaData m_runtimeMetaData;
    private ArrayList m_customColumns;
    private ArrayList m_columnHints;
    private String[] m_projectedColumns;
    private static String sm_className = ProjectedColumns.class.getName();
    private static String sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
    private static LogHelper sm_logger = LogHelper.getInstance(sm_loggerName);

    ProjectedColumns(ResultSetMetaData runtimeMetaData) throws DataException {
        sm_logger.entering(sm_className, "ProjectedColumns", runtimeMetaData);
        assert (runtimeMetaData != null);
        this.m_runtimeMetaData = runtimeMetaData;
        this.m_columns = new ArrayList();
        this.m_baseColumnMetadataCount = runtimeMetaData.getColumnCount();
        int i = 1;
        while (i <= this.m_baseColumnMetadataCount) {
            String name = runtimeMetaData.getColumnName(i);
            String label = runtimeMetaData.getColumnLabel(i);
            Class driverDataType = runtimeMetaData.getColumnTypeAsJavaClass(i);
            String nativeTypeName = runtimeMetaData.getColumnNativeTypeName(i);
            ResultFieldMetadata column = new ResultFieldMetadata(i, name, label, driverDataType, nativeTypeName, false);
            column.setDriverProvidedDataType(driverDataType);
            this.m_columns.add(column);
            ++i;
        }
        sm_logger.exiting(sm_className, "ProjectedColumns", this);
    }

    void addHint(ColumnHint columnHint) throws DataException {
        sm_logger.entering(sm_className, "addHint", columnHint);
        assert (columnHint != null);
        int columnPosition = columnHint.getPosition();
        if (columnPosition > 0 && columnPosition <= this.m_columns.size()) {
            String newColumnName;
            int driverIndex = columnPosition - 1;
            ResultFieldMetadata fieldMD = (ResultFieldMetadata)this.m_columns.get(driverIndex);
            String columnHintAlias = columnHint.getAlias();
            if (columnHintAlias != null) {
                this.validateNewNameOrAlias(columnHintAlias, driverIndex);
            }
            if ((newColumnName = columnHint.getName()) != null && newColumnName.length() > 0) {
                this.validateNewNameOrAlias(newColumnName, driverIndex);
                fieldMD.setName(newColumnName);
            }
            this.updateFieldDataTypeAndAlias(fieldMD, columnHint, driverIndex);
        } else {
            String columnHintName = columnHint.getName();
            int i = 0;
            int n = this.m_columns.size();
            while (i < n) {
                ResultFieldMetadata fieldMD = (ResultFieldMetadata)this.m_columns.get(i);
                if (fieldMD.getName().equals(columnHintName)) {
                    this.updateFieldDataTypeAndAlias(fieldMD, columnHint, i);
                }
                ++i;
            }
        }
        this.doGetColumnHints().add(columnHint);
        sm_logger.exiting(sm_className, "addHint");
    }

    private void updateFieldDataTypeAndAlias(ResultFieldMetadata fieldMetaData, ColumnHint columnHint, int driverIndex) throws DataException {
        Class effectiveDataType;
        String columnHintAlias = columnHint.getAlias();
        if (columnHintAlias != null) {
            this.validateNewNameOrAlias(columnHintAlias, driverIndex);
        }
        fieldMetaData.setAlias(columnHintAlias);
        if (sm_logger.isLoggable(Level.FINER)) {
            sm_logger.logp(Level.FINER, sm_className, "updateFieldDataTypeAndAlias", "Updated result field[{0}] to alias: {1}.", new Object[]{new Integer(driverIndex), columnHintAlias});
        }
        if ((effectiveDataType = fieldMetaData.getDriverProvidedDataType()) == null) {
            effectiveDataType = columnHint.getEffectiveDataType(this.m_runtimeMetaData.getOdaDataSourceId(), this.m_runtimeMetaData.getDataSetType());
        }
        if (effectiveDataType == null) {
            return;
        }
        fieldMetaData.setDataType(effectiveDataType);
        if (sm_logger.isLoggable(Level.FINER)) {
            sm_logger.logp(Level.FINER, sm_className, "updateFieldDataTypeAndAlias", "Set result field[{0}] to data type: {1}.", new Object[]{new Integer(driverIndex), effectiveDataType});
        }
    }

    private ArrayList doGetColumnHints() {
        if (this.m_columnHints == null) {
            this.m_columnHints = new ArrayList();
        }
        return this.m_columnHints;
    }

    void addCustomColumn(String columnName, Class columnType) throws DataException {
        sm_logger.entering(sm_className, "addCustomColumn", columnName);
        assert (columnName != null && columnName.length() > 0);
        this.validateNewNameOrAlias(columnName, -1);
        ResultFieldMetadata column = new ResultFieldMetadata(-1, columnName, columnName, columnType, null, true);
        this.m_columns.add(column);
        this.doGetCustomColumns().add(new PreparedStatement.CustomColumn(columnName, columnType));
        sm_logger.exiting(sm_className, "addCustomColumn", column);
    }

    private ArrayList doGetCustomColumns() {
        if (this.m_customColumns == null) {
            this.m_customColumns = new ArrayList();
        }
        return this.m_customColumns;
    }

    void setProjectedNames(String[] projectedColumns) throws DataException {
        sm_logger.entering(sm_className, "setProjectedNames", projectedColumns);
        if (projectedColumns == null) {
            this.projectAllBaseColumns();
        } else {
            this.projectSelectedBaseColumns(projectedColumns);
        }
        this.m_projectedColumns = projectedColumns;
        sm_logger.exiting(sm_className, "setProjectedNames");
    }

    List getColumnsMetadata() {
        sm_logger.entering(sm_className, "getColumnsMetadata");
        if (this.m_projectedIndices == null) {
            this.projectAllBaseColumns();
        }
        ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
        int i = 0;
        int n = this.m_projectedIndices.length;
        while (i < n) {
            int colIndex = this.m_projectedIndices[i];
            ResultFieldMetadata column = (ResultFieldMetadata)this.m_columns.get(colIndex);
            projectedColumns.add(column);
            ++i;
        }
        i = this.m_baseColumnMetadataCount;
        n = this.m_columns.size();
        while (i < n) {
            ResultFieldMetadata column = (ResultFieldMetadata)this.m_columns.get(i);
            projectedColumns.add(column);
            ++i;
        }
        sm_logger.exiting(sm_className, "getColumnsMetadata", projectedColumns);
        return projectedColumns;
    }

    private void projectSelectedBaseColumns(String[] projectedColumns) throws DataException {
        ArrayList<Integer> projectedIndices = new ArrayList<Integer>();
        int i = 0;
        while (i < projectedColumns.length) {
            String projectedName = projectedColumns[i];
            assert (projectedName != null || projectedName.length() == 0);
            int colIndex = this.findColumnIndex(projectedName);
            if (colIndex >= 0 && colIndex < this.m_baseColumnMetadataCount) {
                projectedIndices.add(new Integer(colIndex));
            } else if (colIndex < this.m_baseColumnMetadataCount) {
                projectedIndices = null;
                sm_logger.logp(Level.SEVERE, sm_className, "projectSelectedBaseColumns", "No match found for project column {0} ", projectedName);
                throw new DataException("odaconsumer.UnrecognizedProjectedColumnName", new Object[]{projectedName});
            }
            ++i;
        }
        int size = projectedIndices.size();
        this.m_projectedIndices = new int[size];
        int i2 = 0;
        while (i2 < size) {
            this.m_projectedIndices[i2] = (Integer)projectedIndices.get(i2);
            ++i2;
        }
    }

    private int findColumnIndex(String projectedName) {
        int foundIndex = -1;
        int colIndex = 0;
        int n = this.m_columns.size();
        while (colIndex < n) {
            ResultFieldMetadata column = (ResultFieldMetadata)this.m_columns.get(colIndex);
            if (projectedName.equals(column.getName()) || projectedName.equals(column.getAlias())) {
                foundIndex = colIndex;
                break;
            }
            ++colIndex;
        }
        if (sm_logger.isLoggable(Level.FINEST)) {
            sm_logger.logp(Level.FINEST, sm_className, "findColumnIndex", "Found column {0} at index {1}.", new Object[]{projectedName, new Integer(foundIndex)});
        }
        return foundIndex;
    }

    private void projectAllBaseColumns() {
        this.m_projectedIndices = new int[this.m_baseColumnMetadataCount];
        int i = 0;
        while (i < this.m_baseColumnMetadataCount) {
            this.m_projectedIndices[i] = i;
            ++i;
        }
        if (sm_logger.isLoggable(Level.FINEST)) {
            sm_logger.logp(Level.FINEST, sm_className, "projectAllBaseColumns", "Projected all columns {0} .", (Object)this.m_projectedIndices);
        }
    }

    private void validateNewNameOrAlias(String newColumnNameOrAlias, int driverIndex) throws DataException {
        assert (newColumnNameOrAlias != null && newColumnNameOrAlias.length() > 0);
        int i = 0;
        int n = this.m_columns.size();
        while (i < n) {
            ResultFieldMetadata column;
            if (i != driverIndex && ((column = (ResultFieldMetadata)this.m_columns.get(i)).getName() != null && column.getName().equals(newColumnNameOrAlias) || column.getAlias() != null && column.getAlias().equals(newColumnNameOrAlias))) {
                sm_logger.logp(Level.SEVERE, sm_className, "validateNewNameOrAlias", "column name or alias {0} is aready used by column {1}", new Object[]{newColumnNameOrAlias, column});
                throw new DataException("odaconsumer.ColumnNameOrAliasAlreadyUsed", new Object[]{newColumnNameOrAlias, new Integer(i + 1)});
            }
            ++i;
        }
    }

    ArrayList getColumnHints() {
        return this.m_columnHints;
    }

    ArrayList getCustomColumns() {
        return this.m_customColumns;
    }

    String[] getProjections() {
        return this.m_projectedColumns;
    }
}

