/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.data.engine.olap.data.util.BaseDiskArray;

public abstract class BaseDiskSortedStack {
    private static final int DEFAULT_BUFFER_SIZE = 1000;
    protected List segments = null;
    protected Object[] buffer = null;
    private int bufferPos = 0;
    private Object[] popBuffer = null;
    private int[] pointers = null;
    private Comparator comparator = null;
    private boolean forceDistinct = false;
    private Object lastPopObject = null;
    private int size = 0;

    public BaseDiskSortedStack(int bufferSize, boolean isAscending, boolean forceDistinct) {
        this(bufferSize, forceDistinct, BaseDiskSortedStack.createComparator(isAscending));
    }

    public BaseDiskSortedStack(int bufferSize, boolean forceDistinct, Comparator comparator) {
        this.buffer = bufferSize <= 0 ? new Object[1000] : new Object[bufferSize];
        this.segments = new ArrayList();
        this.comparator = comparator;
        this.forceDistinct = forceDistinct;
        this.size = 0;
    }

    private static Comparator createComparator(boolean isAscending) {
        if (isAscending) {
            return new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    Comparable data1 = (Comparable)obj1;
                    Comparable data2 = (Comparable)obj2;
                    return data1.compareTo(data2);
                }
            };
        }
        return new Comparator(){

            public int compare(Object obj1, Object obj2) {
                Comparable data1 = (Comparable)obj1;
                Comparable data2 = (Comparable)obj2;
                return data2.compareTo(data1);
            }
        };
    }

    public void push(Object o) throws IOException {
        if (this.bufferPos < this.buffer.length) {
            this.buffer[this.bufferPos] = o;
            ++this.bufferPos;
        } else {
            this.sort(this.buffer);
            if (this.forceDistinct) {
                int endIndex = this.removeDuplicated(this.buffer);
                this.saveToDisk(0, endIndex);
            } else {
                this.saveToDisk(0, this.buffer.length - 1);
            }
            this.buffer[0] = o;
            this.bufferPos = 1;
        }
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    protected abstract void saveToDisk(int var1, int var2) throws IOException;

    private void sort(Object[] objectArray) {
        Arrays.sort(objectArray, this.comparator);
    }

    private void sort(Object[] objectArray, int fromIndex, int toIndex) {
        Arrays.sort(objectArray, fromIndex, toIndex, this.comparator);
    }

    private int removeDuplicated(Object[] objectArray) {
        return this.removeDuplicated(objectArray, 0, objectArray.length - 1);
    }

    private int removeDuplicated(Object[] objectArray, int fromIndex, int toIndex) {
        int pos = fromIndex;
        int i = fromIndex + 1;
        while (i <= toIndex) {
            if (this.comparator.compare(objectArray[i], objectArray[pos]) != 0) {
                objectArray[++pos] = objectArray[i];
            }
            ++i;
        }
        return pos;
    }

    public Object pop() throws IOException {
        int min;
        if (this.popBuffer == null) {
            this.initPop();
        }
        if ((min = this.getMin()) < 0) {
            return null;
        }
        Object reObj = this.popBuffer[min];
        this.popBuffer[min] = this.readNext(min);
        if (this.forceDistinct) {
            if (this.lastPopObject == null) {
                this.lastPopObject = reObj;
            } else if (((Comparable)this.lastPopObject).compareTo(reObj) == 0) {
                return this.pop();
            }
        }
        this.lastPopObject = reObj;
        return reObj;
    }

    private int getMin() {
        int result = -1;
        int i = 0;
        while (i < this.popBuffer.length) {
            if (this.popBuffer[i] != null) {
                result = i;
                break;
            }
            ++i;
        }
        if (result == -1) {
            return -1;
        }
        i = result + 1;
        while (i < this.popBuffer.length) {
            if (this.popBuffer[i] != null && this.comparator.compare(this.popBuffer[i], this.popBuffer[result]) < 0) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    private void initPop() throws IOException {
        this.sort(this.buffer, 0, this.bufferPos);
        if (this.forceDistinct) {
            this.bufferPos = this.removeDuplicated(this.buffer, 0, this.bufferPos - 1) + 1;
        }
        this.popBuffer = new Object[this.getSegmentCount()];
        this.pointers = new int[this.getSegmentCount()];
        int i = 0;
        while (i < this.popBuffer.length) {
            this.popBuffer[i] = this.readNext(i);
            ++i;
        }
    }

    private int getSegmentCount() {
        return this.segments.size() + 1;
    }

    private Object readNext(int segmentNo) throws IOException {
        if (segmentNo < this.segments.size()) {
            BaseDiskArray diskList = (BaseDiskArray)this.segments.get(segmentNo);
            if (this.pointers[segmentNo] < diskList.size()) {
                int n = segmentNo;
                int n2 = this.pointers[n];
                this.pointers[n] = n2 + 1;
                return diskList.get(n2);
            }
            return null;
        }
        if (this.pointers[segmentNo] >= this.bufferPos) {
            return null;
        }
        int n = segmentNo;
        int n3 = this.pointers[n];
        this.pointers[n] = n3 + 1;
        return this.buffer[n3];
    }

    public void close() throws IOException {
        int i = 0;
        while (i < this.segments.size()) {
            BaseDiskArray diskList = (BaseDiskArray)this.segments.get(i);
            diskList.close();
            ++i;
        }
    }
}

