/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IStructureCreator;
import org.eclipse.birt.data.engine.olap.data.util.StructureDiskArray;

public class BufferedStructureArray
implements IDiskArray {
    private StructureDiskArray diskList = null;
    private IStructureCreator creator = null;
    private Object[] buffer = null;
    private int bufferPos = 0;
    private static Logger logger = Logger.getLogger(BufferedStructureArray.class.getName());

    public BufferedStructureArray(IStructureCreator creator, int bufferSize) {
        this.buffer = bufferSize <= 0 ? new Object[100] : new Object[bufferSize];
        this.creator = creator;
    }

    public boolean add(Object o) throws IOException {
        if (this.bufferPos < this.buffer.length) {
            this.buffer[this.bufferPos] = o;
            ++this.bufferPos;
            return true;
        }
        if (this.diskList == null) {
            this.diskList = new StructureDiskArray(this.creator);
        }
        this.diskList.add(o);
        return false;
    }

    public void close() throws IOException {
        this.clearTempDir();
    }

    private void clearTempDir() throws IOException {
        if (this.diskList != null) {
            this.diskList.close();
        }
    }

    public Object get(int index) throws IOException {
        if (index < this.bufferPos) {
            return this.buffer[index];
        }
        if (this.diskList == null) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        return this.diskList.get(index - this.buffer.length);
    }

    public int size() {
        if (this.diskList == null) {
            return this.bufferPos;
        }
        return this.buffer.length + this.diskList.size();
    }

    public void clear() throws IOException {
        this.bufferPos = 0;
        Arrays.fill(this.buffer, null);
        if (this.diskList != null) {
            this.diskList.clear();
            this.diskList = null;
        }
    }
}

