/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.IComputedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.NamedObject;
import org.eclipse.birt.data.engine.olap.impl.query.ComputedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.EdgeDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.MeasureDefinition;

public class CubeQueryDefinition
extends NamedObject
implements ICubeQueryDefinition {
    private IEdgeDefinition columnEdge;
    private IEdgeDefinition rowEdge;
    private IEdgeDefinition pageEdge;
    private List measureList;
    private List bindingList = new ArrayList();
    private List filterList;
    private List sortList;
    private List computedMeasureList;
    private List<ICubeOperation> cubeOperations;
    private String queryResultsID;
    private boolean cacheQueryResults = false;
    private int breakHierarchyOption = 0;

    public CubeQueryDefinition(String name) {
        super(name);
        this.measureList = new ArrayList();
        this.filterList = new ArrayList();
        this.sortList = new ArrayList();
        this.computedMeasureList = new ArrayList();
        this.cubeOperations = new ArrayList<ICubeOperation>();
    }

    public void addBinding(IBinding binding) {
        if (CubeQueryDefinition.needReconstructure(binding)) {
            binding = CubeQueryDefinition.constructNewBinding(binding);
        }
        this.bindingList.add(binding);
    }

    private static boolean needReconstructure(IBinding binding) {
        block4: {
            IAggrFunction aggrFunction;
            block5: {
                try {
                    if (binding.getAggrFunction() == null || binding.getExpression() != null) break block4;
                    aggrFunction = AggregationManager.getInstance().getAggregation(binding.getAggrFunction());
                    if (aggrFunction != null) break block5;
                    return false;
                }
                catch (DataException dataException) {}
            }
            IParameterDefn[] parameterDefn = aggrFunction.getParameterDefn();
            if (parameterDefn != null && parameterDefn.length > 0 && parameterDefn[0].isDataField()) {
                return true;
            }
        }
        return false;
    }

    private static IBinding constructNewBinding(IBinding binding) {
        Binding newBinding = null;
        try {
            int i;
            newBinding = new Binding(binding.getBindingName());
            List aggregationOn = binding.getAggregatOns();
            if (aggregationOn != null) {
                i = 0;
                while (i < aggregationOn.size()) {
                    newBinding.addAggregateOn((String)aggregationOn.get(i));
                    ++i;
                }
            }
            if (binding.getArguments() != null) {
                i = 1;
                while (i < binding.getArguments().size()) {
                    newBinding.addArgument((IBaseExpression)binding.getArguments().get(i));
                    ++i;
                }
            }
            if (binding.getArguments().size() > 0) {
                newBinding.setExpression((IBaseExpression)binding.getArguments().get(0));
            }
            newBinding.setAggrFunction(binding.getAggrFunction());
            newBinding.setDataType(binding.getDataType());
            newBinding.setDisplayName(binding.getDisplayName());
            newBinding.setFilter(binding.getFilter());
        }
        catch (DataException dataException) {}
        return newBinding;
    }

    public void addFilter(IFilterDefinition filterDefn) {
        this.filterList.add(filterDefn);
    }

    public void addSort(ISortDefinition sortDefn) {
        this.sortList.add(sortDefn);
    }

    public IEdgeDefinition createEdge(int type) {
        if (type == 2) {
            this.columnEdge = new EdgeDefinition("COLUMN_EDGE");
            return this.columnEdge;
        }
        if (type == 1) {
            this.rowEdge = new EdgeDefinition("ROW_EDGE");
            return this.rowEdge;
        }
        if (type == 3) {
            this.pageEdge = new EdgeDefinition("PAGE_EDGE");
            return this.pageEdge;
        }
        return null;
    }

    public IMeasureDefinition createMeasure(String name) {
        MeasureDefinition measureDfn = new MeasureDefinition(name);
        this.measureList.add(measureDfn);
        return measureDfn;
    }

    public List getBindings() {
        return Collections.unmodifiableList(this.bindingList);
    }

    public IEdgeDefinition getEdge(int type) {
        if (type == 2) {
            return this.columnEdge;
        }
        if (type == 1) {
            return this.rowEdge;
        }
        if (type == 3) {
            return this.pageEdge;
        }
        return null;
    }

    public List getFilters() {
        return this.filterList;
    }

    public List getMeasures() {
        return this.measureList;
    }

    public List getSorts() {
        return this.sortList;
    }

    public String getQueryResultsID() {
        return this.queryResultsID;
    }

    public void setQueryResultsID(String queryResultsID) {
        this.queryResultsID = queryResultsID;
    }

    public boolean cacheQueryResults() {
        return this.cacheQueryResults;
    }

    public void setCacheQueryResults(boolean cacheQueryResults) {
        this.cacheQueryResults = cacheQueryResults;
    }

    public int getFilterOption() {
        return this.breakHierarchyOption;
    }

    public void setFilterOption(int breakHierarchyOption) {
        this.breakHierarchyOption = breakHierarchyOption;
    }

    public IComputedMeasureDefinition createComputedMeasure(String measureName, int type, IBaseExpression expr) throws DataException {
        ComputedMeasureDefinition cmd = new ComputedMeasureDefinition(measureName, type, expr);
        this.computedMeasureList.add(cmd);
        return cmd;
    }

    public List getComputedMeasures() {
        return this.computedMeasureList;
    }

    public void addCubeOperation(ICubeOperation cubeOperation) {
        if (cubeOperation == null) {
            throw new NullPointerException("cubeOperation is null");
        }
        this.cubeOperations.add(cubeOperation);
    }

    public ICubeOperation[] getCubeOperations() {
        return this.cubeOperations.toArray(new ICubeOperation[0]);
    }
}

