/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.util.DirectedGraph;
import org.eclipse.birt.data.engine.impl.util.DirectedGraphEdge;
import org.eclipse.birt.data.engine.impl.util.GraphNode;
import org.eclipse.birt.data.engine.olap.api.query.IComputedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeOperationFactory;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;

public class PreparedCubeQueryDefinition
implements ICubeQueryDefinition {
    private ICubeQueryDefinition cqd;
    private List<IBinding> realBindings = new ArrayList<IBinding>();
    private Set<IBinding> bindingsForNestAggregation = new HashSet<IBinding>();
    private Map<String, IBinding> nameToBinding = new HashMap<String, IBinding>();

    public PreparedCubeQueryDefinition(ICubeQueryDefinition cqd) throws DataException {
        assert (cqd != null);
        this.cqd = cqd;
        for (Object o : cqd.getBindings()) {
            List referencedBindings;
            IBinding binding = (IBinding)o;
            if (this.nameToBinding.containsKey(binding.getBindingName())) {
                throw new DataException("data.engine.DuplicatedBindingName");
            }
            this.nameToBinding.put(binding.getBindingName(), binding);
            if (OlapExpressionUtil.isAggregationBinding(binding) && (referencedBindings = ExpressionCompilerUtil.extractColumnExpression(binding.getExpression(), "data")) != null && referencedBindings.size() > 0) {
                this.bindingsForNestAggregation.add(binding);
                continue;
            }
            this.realBindings.add(binding);
        }
        this.convertToCubeOperations();
    }

    public ICubeQueryDefinition getCubeQueryDefinition() {
        return this.cqd;
    }

    private void convertToCubeOperations() throws DataException {
        HashSet<DirectedGraphEdge> edges = new HashSet<DirectedGraphEdge>();
        for (IBinding binding : this.bindingsForNestAggregation) {
            List referencedBindings = ExpressionCompilerUtil.extractColumnExpression(binding.getExpression(), "data");
            for (String name : referencedBindings) {
                IBinding reference = this.nameToBinding.get(name);
                if (reference == null || !this.bindingsForNestAggregation.contains(reference)) continue;
                edges.add(new DirectedGraphEdge(new GraphNode(binding), new GraphNode(reference)));
            }
        }
        GraphNode[] nodes = null;
        try {
            nodes = new DirectedGraph(edges).flattenNodesByDependency();
        }
        catch (DirectedGraph.CycleFoundException e) {
            throw new DataException("data.engine.ColumnBindingCycle", ((IBinding)e.getNode().getValue()).getBindingName());
        }
        HashSet<IBinding> processed = new HashSet<IBinding>();
        GraphNode[] graphNodeArray = nodes;
        int n = nodes.length;
        int name = 0;
        while (name < n) {
            GraphNode node = graphNodeArray[name];
            IBinding b = (IBinding)node.getValue();
            this.cqd.addCubeOperation(CubeOperationFactory.getInstance().createAddingNestAggregationsOperation(new IBinding[]{b}));
            processed.add(b);
            ++name;
        }
        if (this.bindingsForNestAggregation.size() > processed.size()) {
            ArrayList<IBinding> left = new ArrayList<IBinding>();
            for (IBinding b : this.bindingsForNestAggregation) {
                if (processed.contains(b)) continue;
                left.add(b);
            }
            this.cqd.addCubeOperation(CubeOperationFactory.getInstance().createAddingNestAggregationsOperation(left.toArray(new IBinding[0])));
        }
    }

    public void addBinding(IBinding binding) {
        throw new UnsupportedOperationException("adding binding is not allowed for prepared cube query definition");
    }

    public void addCubeOperation(ICubeOperation cubeOperation) {
        throw new UnsupportedOperationException("adding cube operation is not allowed for prepared cube query definition");
    }

    public void addFilter(IFilterDefinition filter) {
        this.cqd.addFilter(filter);
    }

    public void addSort(ISortDefinition sort) {
        this.cqd.addSort(sort);
    }

    public boolean cacheQueryResults() {
        return this.cqd.cacheQueryResults();
    }

    public IComputedMeasureDefinition createComputedMeasure(String measureName, int type, IBaseExpression expr) throws DataException {
        return this.cqd.createComputedMeasure(measureName, type, expr);
    }

    public IEdgeDefinition createEdge(int type) {
        return this.cqd.createEdge(type);
    }

    public IMeasureDefinition createMeasure(String measureName) {
        return this.cqd.createMeasure(measureName);
    }

    public List getBindings() {
        return Collections.unmodifiableList(this.realBindings);
    }

    public List getComputedMeasures() {
        return this.cqd.getComputedMeasures();
    }

    public ICubeOperation[] getCubeOperations() {
        return this.cqd.getCubeOperations();
    }

    public IEdgeDefinition getEdge(int type) {
        return this.cqd.getEdge(type);
    }

    public int getFilterOption() {
        return this.cqd.getFilterOption();
    }

    public List getFilters() {
        return this.cqd.getFilters();
    }

    public List getMeasures() {
        return this.cqd.getMeasures();
    }

    public String getQueryResultsID() {
        return this.cqd.getQueryResultsID();
    }

    public List getSorts() {
        return this.cqd.getSorts();
    }

    public void setCacheQueryResults(boolean b) {
        this.cqd.setCacheQueryResults(b);
    }

    public void setFilterOption(int breakHierarchyOption) {
        this.cqd.setFilterOption(breakHierarchyOption);
    }

    public void setQueryResultsID(String id) {
        this.cqd.setQueryResultsID(id);
    }

    public String getName() {
        return this.cqd.getName();
    }

    public void setName(String name) {
        this.cqd.setName(name);
    }
}

