/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.persistence.options;

import java.util.Map;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.options.Options;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.options.TargetDatabase;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.options.TargetServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkOptions
extends EclipseLinkPersistenceUnitProperties
implements Options {
    private String sessionName;
    private String sessionsXml;
    private Boolean includeDescriptorQueries;
    private String targetDatabase;
    private String targetServer;
    private String eventListener;
    private Boolean temporalMutable;

    public EclipseLinkOptions(PersistenceUnit parent) {
        super(parent);
    }

    @Override
    protected void initializeProperties() {
        this.sessionName = this.getStringValue("eclipselink.session-name");
        this.sessionsXml = this.getStringValue("eclipselink.sessions-xml");
        this.includeDescriptorQueries = this.getBooleanValue("eclipselink.session.include.descriptor.queries");
        this.targetDatabase = this.getTargetDatabaseFromPersistenceXml();
        this.targetServer = this.getTargetServerFromPersistenceXml();
        this.eventListener = this.getStringValue("eclipselink.session-event-listener");
        this.temporalMutable = this.getBooleanValue("eclipselink.temporal.mutable");
    }

    protected String getTargetDatabaseFromPersistenceXml() {
        String value = this.getStringValue("eclipselink.target-database");
        if (value == null) {
            return null;
        }
        TargetDatabase standardTargetDatabase = (TargetDatabase)this.getEnumValue("eclipselink.target-database", TargetDatabase.values());
        return standardTargetDatabase == null ? value : EclipseLinkOptions.getEclipseLinkStringValueOf((Object)standardTargetDatabase);
    }

    protected String getTargetServerFromPersistenceXml() {
        String value = this.getStringValue("eclipselink.target-server");
        if (value == null) {
            return null;
        }
        TargetServer standardTargetServer = (TargetServer)this.getEnumValue("eclipselink.target-server", TargetServer.values());
        return standardTargetServer == null ? value : EclipseLinkOptions.getEclipseLinkStringValueOf((Object)standardTargetServer);
    }

    @Override
    public void propertyValueChanged(String propertyName, String newValue) {
        if (propertyName.equals("eclipselink.session-name")) {
            this.sessionNameChanged(newValue);
        } else if (propertyName.equals("eclipselink.sessions-xml")) {
            this.sessionsXmlChanged(newValue);
        } else if (propertyName.equals("eclipselink.target-database")) {
            this.targetDatabaseChanged(newValue);
        } else if (propertyName.equals("eclipselink.target-server")) {
            this.targetServerChanged(newValue);
        } else if (propertyName.equals("eclipselink.session.include.descriptor.queries")) {
            this.includeDescriptorQueriesChanged(newValue);
        } else if (propertyName.equals("eclipselink.session-event-listener")) {
            this.eventListenerChanged(newValue);
        } else if (propertyName.equals("eclipselink.temporal.mutable")) {
            this.temporalMutableChanged(newValue);
        }
    }

    @Override
    public void propertyRemoved(String propertyName) {
        if (propertyName.equals("eclipselink.session-name")) {
            this.sessionNameChanged(null);
        } else if (propertyName.equals("eclipselink.sessions-xml")) {
            this.sessionsXmlChanged(null);
        } else if (propertyName.equals("eclipselink.target-database")) {
            this.targetDatabaseChanged(null);
        } else if (propertyName.equals("eclipselink.target-server")) {
            this.targetServerChanged(null);
        } else if (propertyName.equals("eclipselink.session.include.descriptor.queries")) {
            this.includeDescriptorQueriesChanged(null);
        } else if (propertyName.equals("eclipselink.session-event-listener")) {
            this.eventListenerChanged(null);
        } else if (propertyName.equals("eclipselink.temporal.mutable")) {
            this.temporalMutableChanged(null);
        }
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.session-name", "sessionName");
        propertyNames.put("eclipselink.sessions-xml", "sessionsXml");
        propertyNames.put("eclipselink.session.include.descriptor.queries", "includeDescriptorQueriesy");
        propertyNames.put("eclipselink.target-database", "targetDatabase");
        propertyNames.put("eclipselink.target-server", "targetServer");
        propertyNames.put("eclipselink.session-event-listener", "eventListener");
        propertyNames.put("eclipselink.temporal.mutable", "temporalMutable");
    }

    @Override
    public String getSessionName() {
        return this.sessionName;
    }

    @Override
    public void setSessionName(String newSessionName) {
        String old = this.sessionName;
        this.sessionName = newSessionName;
        this.putProperty("sessionName", newSessionName);
        this.firePropertyChanged("sessionName", old, newSessionName);
    }

    private void sessionNameChanged(String newValue) {
        String old = this.sessionName;
        this.sessionName = newValue;
        this.firePropertyChanged("sessionName", old, newValue);
    }

    @Override
    public String getDefaultSessionName() {
        return "";
    }

    @Override
    public String getSessionsXml() {
        return this.sessionsXml;
    }

    @Override
    public void setSessionsXml(String newSessionsXml) {
        String old = this.sessionsXml;
        this.sessionsXml = newSessionsXml;
        this.putProperty("sessionsXml", newSessionsXml);
        this.firePropertyChanged("sessionsXml", old, newSessionsXml);
    }

    private void sessionsXmlChanged(String newValue) {
        String old = this.sessionsXml;
        this.sessionsXml = newValue;
        this.firePropertyChanged("sessionsXml", old, newValue);
    }

    @Override
    public String getDefaultSessionsXml() {
        return "";
    }

    @Override
    public Boolean getIncludeDescriptorQueries() {
        return this.includeDescriptorQueries;
    }

    @Override
    public void setIncludeDescriptorQueries(Boolean newIncludeDescriptorQueries) {
        Boolean old = this.includeDescriptorQueries;
        this.includeDescriptorQueries = newIncludeDescriptorQueries;
        this.putProperty("includeDescriptorQueriesy", newIncludeDescriptorQueries);
        this.firePropertyChanged("includeDescriptorQueriesy", old, newIncludeDescriptorQueries);
    }

    private void includeDescriptorQueriesChanged(String stringValue) {
        Boolean newValue = EclipseLinkOptions.getBooleanValueOf(stringValue);
        Boolean old = this.includeDescriptorQueries;
        this.includeDescriptorQueries = newValue;
        this.firePropertyChanged("includeDescriptorQueriesy", old, newValue);
    }

    @Override
    public Boolean getDefaultIncludeDescriptorQueries() {
        return DEFAULT_SESSION_INCLUDE_DESCRIPTOR_QUERIES;
    }

    @Override
    public String getTargetDatabase() {
        return this.targetDatabase;
    }

    @Override
    public void setTargetDatabase(TargetDatabase newTargetDatabase) {
        if (newTargetDatabase == null) {
            this.setTargetDatabase_(null);
            return;
        }
        this.setTargetDatabase_(EclipseLinkOptions.getEclipseLinkStringValueOf((Object)newTargetDatabase));
    }

    @Override
    public void setTargetDatabase(String newTargetDatabase) {
        if (newTargetDatabase == null) {
            this.setTargetDatabase_(null);
            return;
        }
        TargetDatabase customTargetDatabase = TargetDatabase.getTargetDatabaseFor(newTargetDatabase);
        if (customTargetDatabase == null) {
            this.setTargetDatabase_(newTargetDatabase);
        } else {
            this.setTargetDatabase(customTargetDatabase);
        }
    }

    private void setTargetDatabase_(String newTargetDatabase) {
        String old = this.targetDatabase;
        this.targetDatabase = newTargetDatabase;
        this.putProperty("targetDatabase", newTargetDatabase);
        this.firePropertyChanged("targetDatabase", old, newTargetDatabase);
    }

    private void targetDatabaseChanged(String newValue) {
        String old = this.targetDatabase;
        this.targetDatabase = newValue;
        this.firePropertyChanged("targetDatabase", old, newValue);
    }

    @Override
    public String getDefaultTargetDatabase() {
        return DEFAULT_TARGET_DATABASE;
    }

    @Override
    public String getTargetServer() {
        return this.targetServer;
    }

    @Override
    public void setTargetServer(TargetServer newTargetServer) {
        if (newTargetServer == null) {
            this.setTargetServer_(null);
            return;
        }
        this.setTargetServer_(EclipseLinkOptions.getEclipseLinkStringValueOf((Object)newTargetServer));
    }

    @Override
    public void setTargetServer(String newTargetServer) {
        if (newTargetServer == null) {
            this.setTargetServer_(null);
            return;
        }
        TargetServer customTargetServer = TargetServer.getTargetServerFor(newTargetServer);
        if (customTargetServer == null) {
            this.setTargetServer_(newTargetServer);
        } else {
            this.setTargetServer(customTargetServer);
        }
    }

    private void setTargetServer_(String newTargetServer) {
        String old = this.targetServer;
        this.targetServer = newTargetServer;
        this.putProperty("targetServer", newTargetServer);
        this.firePropertyChanged("targetServer", old, newTargetServer);
    }

    private void targetServerChanged(String newValue) {
        String old = this.targetServer;
        this.targetServer = newValue;
        this.firePropertyChanged("targetServer", old, newValue);
    }

    @Override
    public String getDefaultTargetServer() {
        return DEFAULT_TARGET_SERVER;
    }

    @Override
    public String getEventListener() {
        return this.eventListener;
    }

    @Override
    public void setEventListener(String newEventListener) {
        String old = this.eventListener;
        this.eventListener = newEventListener;
        this.putProperty("eventListener", newEventListener);
        this.firePropertyChanged("eventListener", old, newEventListener);
    }

    private void eventListenerChanged(String newValue) {
        String old = this.eventListener;
        this.eventListener = newValue;
        this.firePropertyChanged("eventListener", old, newValue);
    }

    @Override
    public String getDefaultEventListener() {
        return DEFAULT_SESSION_EVENT_LISTENER;
    }

    @Override
    public Boolean getTemporalMutable() {
        return this.temporalMutable;
    }

    @Override
    public void setTemporalMutable(Boolean newTemporalMutable) {
        Boolean old = this.temporalMutable;
        this.temporalMutable = newTemporalMutable;
        this.putProperty("temporalMutable", newTemporalMutable);
        this.firePropertyChanged("temporalMutable", old, newTemporalMutable);
    }

    private void temporalMutableChanged(String stringValue) {
        Boolean newValue = EclipseLinkOptions.getBooleanValueOf(stringValue);
        Boolean old = this.temporalMutable;
        this.temporalMutable = newValue;
        this.firePropertyChanged("temporalMutable", old, newValue);
    }

    @Override
    public Boolean getDefaultTemporalMutable() {
        return DEFAULT_TEMPORAL_MUTABLE;
    }
}

