/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.CustomMsgException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.CustomMsgCommand;
import org.eclipse.birt.report.model.command.LibraryCommand;
import org.eclipse.birt.report.model.command.ShiftLibraryCommand;
import org.eclipse.birt.report.model.command.ThemeCommand;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.StyleSheetLoader;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.util.ModelUtil;

abstract class LayoutModuleHandle
extends ModuleHandle {
    public LayoutModuleHandle(Module module) {
        super(module);
        this.initializeSlotHandles();
        this.cachePropertyHandles();
    }

    public void addConfigVariable(ConfigVariable configVar) throws SemanticException {
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("configVars");
        if (configVar != null && StringUtil.isBlank(configVar.getName())) {
            throw new PropertyValueException(this.getElement(), propDefn, (Object)configVar, "Error.PropertyValueException.INVALID_VALUE");
        }
        if (configVar != null && this.findConfigVariable(configVar.getName()) != null) {
            throw new PropertyValueException(this.getElement(), propDefn, (Object)configVar.getName(), "Error.PropertyValueException.VALUE_EXISTS");
        }
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        cmd.addItem(new StructureContext(this.getElement(), propDefn, null), (Object)configVar);
    }

    public void addImage(EmbeddedImage image) throws SemanticException {
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.module, this.getElement());
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("images");
        cmd.addItem(new StructureContext(this.module, propDefn, null), (Object)image);
    }

    private void addParameters(ArrayList list, ParameterGroupHandle handle) {
        SlotHandle h = handle.getParameters();
        Iterator it = h.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
    }

    public void addTranslation(String resourceKey, String locale, String text) throws CustomMsgException {
        CustomMsgCommand command = new CustomMsgCommand(this.getModule());
        command.addTranslation(resourceKey, locale, text);
    }

    public void dropConfigVariable(String name) throws SemanticException {
        PropertyHandle propHandle = this.getPropertyHandle("configVars");
        int posn = this.findConfigVariablePos(name);
        if (posn < 0) {
            throw new PropertyValueException(this.getElement(), propHandle.getPropertyDefn(), (Object)name, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        propHandle.removeItem(posn);
    }

    public void dropImage(List images) throws SemanticException {
        if (images == null) {
            return;
        }
        PropertyHandle propHandle = this.getPropertyHandle("images");
        propHandle.removeItems(images);
    }

    public void dropImage(String name) throws SemanticException {
        PropertyHandle propHandle = this.getPropertyHandle("images");
        int pos = this.findImagePos(name);
        if (pos < 0) {
            throw new PropertyValueException(this.getElement(), propHandle.getPropertyDefn(), (Object)name, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        propHandle.removeItem(pos);
    }

    public void dropTranslation(String resourceKey, String locale) throws CustomMsgException {
        CustomMsgCommand command = new CustomMsgCommand(this.getModule());
        command.dropTranslation(resourceKey, locale);
    }

    private int findConfigVariablePos(String name) {
        List configVars = (List)this.module.getLocalProperty(this.module, "configVars");
        if (configVars == null) {
            return -1;
        }
        int i = 0;
        for (ConfigVariable var : configVars) {
            if (var.getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int findImagePos(String name) {
        List images = (List)this.module.getLocalProperty(this.module, "images");
        int i = 0;
        for (EmbeddedImage image : images) {
            if (image.getName() != null && image.getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public SlotHandle getComponents() {
        return this.getSlot(5);
    }

    public SlotHandle getDataSets() {
        return this.getSlot(3);
    }

    public SlotHandle getDataSources() {
        return this.getSlot(2);
    }

    public List getFlattenParameters() {
        ArrayList<DesignElementHandle> list = new ArrayList<DesignElementHandle>();
        SlotHandle slotHandle = this.getParameters();
        Iterator it = slotHandle.iterator();
        while (it.hasNext()) {
            DesignElementHandle h = (DesignElementHandle)it.next();
            list.add(h);
            if (!(h instanceof ParameterGroupHandle)) continue;
            this.addParameters(list, (ParameterGroupHandle)h);
        }
        DesignElementHandle.doSort(list);
        return list;
    }

    public SlotHandle getMasterPages() {
        return this.getSlot(4);
    }

    public SlotHandle getParameters() {
        return this.getSlot(1);
    }

    public SlotHandle getStyles() {
        return this.getSlot(0);
    }

    public Iterator imagesIterator() {
        return this.getPropertyHandle("images").iterator();
    }

    public void replaceConfigVariable(ConfigVariable oldVar, ConfigVariable newVar) throws SemanticException {
        this.replaceObjectInList("configVars", oldVar, newVar);
    }

    public void replaceImage(EmbeddedImage oldVar, EmbeddedImage newVar) throws SemanticException {
        this.replaceObjectInList("images", oldVar, newVar);
    }

    private void replaceObjectInList(String propName, Object oldVar, Object newVar) throws SemanticException {
        ElementPropertyDefn propDefn = this.module.getPropertyDefn(propName);
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.module, this.getElement());
        cmd.replaceItem(new StructureContext(this.getElement(), propDefn, null), (Structure)oldVar, (Structure)newVar);
    }

    public List getAllStyles() {
        List<DesignElement> elementList = this.module.getNameHelper().getElements(0, Integer.MAX_VALUE);
        return this.generateHandleList(elementList);
    }

    public List getVisibleThemes(int level) {
        List<DesignElement> elementList = this.module.getNameHelper().getElements(6, level);
        return this.generateHandleList(this.sortVisibleElements(elementList, level));
    }

    public List getParametersAndParameterGroups() {
        SlotHandle params = this.getSlot(1);
        ArrayList<DesignElementHandle> retList = new ArrayList<DesignElementHandle>();
        int i = 0;
        while (i < params.getCount()) {
            retList.add(params.get(i));
            ++i;
        }
        return retList;
    }

    public List getAllPages() {
        List<DesignElement> elementList = this.module.getNameHelper().getNameSpace(5).getElements();
        return this.generateHandleList(elementList);
    }

    public void shiftLibrary(LibraryHandle library, int toPosn) throws SemanticException {
        if (library == null) {
            return;
        }
        ShiftLibraryCommand command = new ShiftLibraryCommand(this.module);
        command.shiftLibrary((Library)library.getElement(), toPosn);
    }

    public Iterator includeLibrariesIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("libraries");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    public void includeLibrary(String libraryFileName, String namespace) throws DesignFileException, SemanticException {
        LibraryCommand command = new LibraryCommand(this.module);
        command.addLibrary(libraryFileName, namespace);
    }

    public void dropLibrary(LibraryHandle library) throws SemanticException {
        if (library == null) {
            return;
        }
        LibraryCommand command = new LibraryCommand(this.module);
        command.dropLibrary((Library)library.getElement());
        ModuleOption options = this.module.getOptions();
        if (options == null || options.useSemanticCheck()) {
            this.checkReport();
        }
    }

    public void reloadLibrary(LibraryHandle libraryToReload) throws SemanticException, DesignFileException {
        if (libraryToReload == null) {
            return;
        }
        HashMap<String, Library> reloadLibs = new HashMap<String, Library>();
        LibraryCommand command = new LibraryCommand(this.module);
        String location = libraryToReload.getLocation();
        if (location == null) {
            location = libraryToReload.getFileName();
        }
        command.reloadLibrary(location, reloadLibs);
        ModuleOption options = this.module.getOptions();
        if (options == null || options.useSemanticCheck()) {
            this.checkReport();
        }
    }

    private void reloadLibrary(Library libraryToReload, IncludedLibrary includedLib, Map reloadLibs) throws SemanticException, DesignFileException {
        if (libraryToReload == null) {
            return;
        }
        LibraryCommand command = new LibraryCommand(this.module);
        command.reloadLibrary(libraryToReload, includedLib, reloadLibs);
        ModuleOption options = this.module.getOptions();
        if (options == null || options.useSemanticCheck()) {
            this.checkReport();
        }
    }

    public void reloadLibraries() throws SemanticException, DesignFileException {
        List libs = this.getListProperty("libraries");
        if (libs == null || libs.isEmpty()) {
            return;
        }
        ArrayList cachedList = new ArrayList();
        cachedList.addAll(libs);
        HashMap reloadLibs = new HashMap();
        int i = 0;
        while (i < cachedList.size()) {
            IncludedLibrary lib = (IncludedLibrary)cachedList.get(i);
            Library includeLib = this.module.getLibraryWithNamespace(lib.getNamespace(), 1);
            if (includeLib != null) {
                this.reloadLibrary(includeLib, lib, reloadLibs);
            } else {
                LibraryCommand cmd = new LibraryCommand(this.module);
                cmd.reloadLibrary(lib.getFileName(), lib.getNamespace());
            }
            ++i;
        }
        ModuleOption options = this.module.getOptions();
        if (options == null || options.useSemanticCheck()) {
            this.checkReport();
        }
    }

    public void reloadLibrary(String reloadPath) throws SemanticException, DesignFileException {
        if (StringUtil.isEmpty(reloadPath)) {
            return;
        }
        URL url = ModelUtil.getURLPresentation(reloadPath);
        String path = null;
        if (url != null) {
            path = url.toExternalForm();
        }
        if (path == null) {
            DesignParserException ex = new DesignParserException(new String[]{reloadPath}, "Error.DesignParserException.FILE_NOT_FOUND");
            ArrayList<DesignParserException> exceptionList = new ArrayList<DesignParserException>();
            exceptionList.add(ex);
            throw new DesignFileException(path, exceptionList);
        }
        List<Library> libs = this.module.getLibrariesByLocation(path, Integer.MAX_VALUE);
        HashMap<String, Library> reloadLibs = new HashMap<String, Library>();
        int i = 0;
        while (i < libs.size()) {
            LibraryCommand command = new LibraryCommand(this.module);
            Library lib = libs.get(i);
            command.reloadLibrary(lib, null, reloadLibs);
            ++i;
        }
        ModuleOption options = this.module.getOptions();
        if (options == null || options.useSemanticCheck()) {
            this.checkReport();
        }
    }

    public void dropLibraryAndBreakExtends(LibraryHandle library) throws SemanticException {
        if (library == null) {
            return;
        }
        LibraryCommand command = new LibraryCommand(this.module);
        command.dropLibraryAndBreakExtends((Library)library.getElement());
        ModuleOption options = this.module.getOptions();
        if (options == null || options.useSemanticCheck()) {
            this.checkReport();
        }
    }

    public CssStyleSheetHandle openCssStyleSheet(String fileName) throws StyleSheetException {
        CssStyleSheet sheet = this.module.loadCss(fileName);
        return sheet.handle(this.module);
    }

    public CssStyleSheetHandle openCssStyleSheet(InputStream is) throws StyleSheetException {
        StyleSheetLoader loader = new StyleSheetLoader();
        return loader.load(this.module, is).handle(this.module);
    }

    public void setThemeName(String themeName) throws SemanticException {
        ThemeCommand command = new ThemeCommand((Module)this.getElement());
        command.setTheme(themeName);
    }

    public void setTheme(ThemeHandle theme) throws SemanticException {
        ThemeCommand command = new ThemeCommand((Module)this.getElement());
        command.setThemeElement(theme);
    }

    List getAllTemplateParameterDefinitions() {
        List<DesignElement> elementList = this.module.getNameHelper().getElements(7, 0);
        return this.generateHandleList(elementList);
    }
}

