/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.metadata.IObjectDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyType;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.metadata.UserChoice;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UserPropertyDefn
extends ElementPropertyDefn
implements IStructure {
    private String displayName = null;
    private Boolean isVisible = null;
    public static final String TYPE_MEMBER = "type";
    public static final String NAME_MEMBER = "name";
    public static final String ISVISIBLE_MEMBER = "isVisible";
    public static final String DEFAULT_MEMBER = "default";
    public static final String DISPLAY_NAME_MEMBER = "displayName";
    public static final String DISPLAY_NAME_ID_MEMBER = "displayNameID";
    public static final String STRUCTURE_NAME = "UserProperty";
    public static final String CHOICES_MEMBER = "choices";
    private static List<IPropertyType> allowedTypes = null;

    static {
        allowedTypes = new ArrayList<IPropertyType>();
        for (IPropertyType propType : MetaDataDictionary.getInstance().getPropertyTypes()) {
            int type = propType.getTypeCode();
            switch (type) {
                case 0: 
                case 2: 
                case 6: 
                case 7: 
                case 11: 
                case 14: 
                case 21: {
                    allowedTypes.add(propType);
                    break;
                }
            }
        }
    }

    public UserPropertyDefn() {
        PropertyType typeDefn = MetaDataDictionary.getInstance().getPropertyType("string");
        this.setType(typeDefn);
    }

    public static List<IPropertyType> getAllowedTypes() {
        return allowedTypes;
    }

    @Override
    public Object getProperty(Module module, PropertyDefn prop) {
        Object value = this.getLocalProperty(module, prop);
        return value == null ? prop.getDefault() : value;
    }

    @Override
    public void setProperty(PropertyDefn prop, Object value) {
        assert (prop != null);
        String memberName = prop.getName();
        if (memberName.equals(TYPE_MEMBER)) {
            this.type = MetaDataDictionary.getInstance().getPropertyType((String)value);
        } else if (memberName.equals(NAME_MEMBER)) {
            this.name = value == null ? null : value.toString();
        } else if (memberName.equals(DISPLAY_NAME_MEMBER)) {
            this.displayName = value == null ? null : value.toString();
        } else if (memberName.equals(DISPLAY_NAME_ID_MEMBER)) {
            this.displayNameID = value == null ? null : value.toString();
        } else if (memberName.equals(ISVISIBLE_MEMBER)) {
            assert (value instanceof Boolean);
            this.isVisible = (Boolean)value;
        } else if (memberName.equals(DEFAULT_MEMBER)) {
            this.setDefault(value);
        }
    }

    @Override
    public String getStructName() {
        return STRUCTURE_NAME;
    }

    @Override
    public int getValueType() {
        return 1;
    }

    @Override
    public IStructure copy() {
        try {
            UserPropertyDefn uDefn = (UserPropertyDefn)this.clone();
            if (this.details instanceof ChoiceSet) {
                uDefn.details = ((ChoiceSet)this.details).clone();
            }
            return uDefn;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }

    @Override
    public IStructureDefn getDefn() {
        return MetaDataDictionary.getInstance().getStructure(STRUCTURE_NAME);
    }

    @Override
    public IObjectDefn getObjectDefn() {
        return MetaDataDictionary.getInstance().getStructure(STRUCTURE_NAME);
    }

    @Override
    public String getDisplayName() {
        if (!StringUtil.isBlank(this.displayName)) {
            return this.displayName;
        }
        return this.name;
    }

    public void setDisplayName(String theName) {
        this.displayName = theName;
    }

    public void setChoices(UserChoice[] choiceArray) {
        if (choiceArray == null) {
            this.details = null;
            return;
        }
        ChoiceSet choices = new ChoiceSet(null);
        choices.setChoices(choiceArray);
        this.details = choices;
    }

    @Override
    protected String validateExtendedChoicesByDisplayName(Module module, String displayName) {
        if (displayName == null || !this.hasChoices()) {
            return null;
        }
        IChoiceSet choiceSet = this.getChoices();
        UserChoice choice = choiceSet.findUserChoiceByDisplayName(module, displayName);
        if (choice != null) {
            return choice.getName();
        }
        return null;
    }

    @Override
    public IStructureDefn getStructDefn() {
        return MetaDataDictionary.getInstance().getStructure(STRUCTURE_NAME);
    }

    @Override
    public IMethodInfo getMethodInfo() {
        assert (false);
        return null;
    }

    @Override
    public void setType(PropertyType typeDefn) {
        this.type = typeDefn;
    }

    public void checkUserPropertyDefn(Module module, DesignElement element) throws UserPropertyException, MetaDataException {
        IChoiceSet choices;
        String name = this.getName();
        if (!element.getDefn().allowsUserProperties()) {
            throw new UserPropertyException(element, name, "Error.UserPropertyException.USER_PROP_DISALLOWED");
        }
        if (StringUtil.isBlank(name)) {
            throw new UserPropertyException(element, name, "Error.UserPropertyException.NAME_REQUIRED");
        }
        if (element.getPropertyDefn(name) != null) {
            throw new UserPropertyException(element, name, "Error.UserPropertyException.DUPLICATE_NAME");
        }
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        if (dd.getPropertyType(this.getTypeCode()) == null || this.getTypeCode() == 15 || this.getTypeCode() == 16) {
            throw new UserPropertyException(element, name, "Error.UserPropertyException.INVALID_TYPE");
        }
        if (this.getTypeCode() == 5 && ((choices = this.getChoices()) == null || choices.getChoices().length == 0)) {
            throw new UserPropertyException(element, name, "Error.UserPropertyException.MISSING_CHOICES");
        }
        if (this.hasChoices()) {
            IChoiceSet choiceSet = this.getChoices();
            IChoice[] choices2 = choiceSet.getChoices();
            int i = 0;
            while (i < choices2.length) {
                UserChoice choice = (UserChoice)choices2[i];
                Object value = choice.getValue();
                if (StringUtil.isBlank(choice.getName())) {
                    throw new UserPropertyException(element, name, "Error.UserPropertyException.CHOICE_NAME_REQUIRED");
                }
                if (value == null) {
                    throw new UserPropertyException(element, name, "Error.UserPropertyException.CHOICE_VALUE_REQUIRED");
                }
                if (this.getTypeCode() != 5) {
                    try {
                        value = this.validateValue(module, value);
                    }
                    catch (PropertyValueException propertyValueException) {
                        throw new UserPropertyException(element, name, "Error.UserPropertyException.INVALID_CHOICE_VALUE");
                    }
                }
                ++i;
            }
        }
        this.build();
    }

    @Override
    public Object getLocalProperty(Module module, PropertyDefn propDefn) {
        assert (propDefn != null);
        String memberName = propDefn.getName();
        if (memberName.equals(TYPE_MEMBER)) {
            return this.type.getName();
        }
        if (memberName.equals(NAME_MEMBER)) {
            return this.name;
        }
        if (memberName.equals(DISPLAY_NAME_MEMBER)) {
            return this.displayName;
        }
        if (memberName.equals(DISPLAY_NAME_ID_MEMBER)) {
            return this.displayNameID;
        }
        if (memberName.equals(ISVISIBLE_MEMBER)) {
            return this.isVisible;
        }
        return null;
    }

    @Override
    public Object getProperty(Module module, String memberName) {
        PropertyDefn prop = (PropertyDefn)this.getDefn().getMember(memberName);
        if (prop == null) {
            return null;
        }
        return this.getProperty(module, prop);
    }

    @Override
    public boolean isReferencable() {
        return false;
    }

    @Override
    public void setDefault(Object value) {
        if (value != null && this.getTypeCode() == 7 && !(value instanceof Expression)) {
            value = new Expression(value, "constant");
        }
        super.setDefault(value);
    }

    @Override
    public void build() throws MetaDataException {
        if (this.isIntrinsic() && this.isStyleProperty()) {
            throw new MetaDataException(new String[]{this.name}, "INCONSISTENT_PROP_TYPE");
        }
    }

    @Override
    public boolean isDesignTime() {
        return true;
    }

    @Override
    public boolean isVisible() {
        Boolean value = (Boolean)this.getProperty(null, ISVISIBLE_MEMBER);
        return value == null ? true : value;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }
}

