/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.List;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IPropertyType;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.metadata.UserChoice;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.PropertyRecord;
import org.eclipse.birt.report.model.command.UserPropertyRecord;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

public class UserPropertyCommand
extends AbstractElementCommand {
    public UserPropertyCommand(Module module, DesignElement obj) {
        super(module, obj);
    }

    public void addUserProperty(UserPropertyDefn prop) throws UserPropertyException {
        if (prop == null) {
            return;
        }
        assert (this.element != null);
        this.checkUserPropertyDefn(prop);
        String name = prop.getName();
        if (this.element.getPropertyDefn(name) != null) {
            throw new UserPropertyException(this.element, name, "Error.UserPropertyException.DUPLICATE_NAME");
        }
        ActivityStack stack = this.getActivityStack();
        UserPropertyRecord propCmd = new UserPropertyRecord(this.element, prop, true);
        stack.execute(propCmd);
    }

    public void dropUserProperty(String propName) throws UserPropertyException {
        assert (this.element != null);
        if (StringUtil.isBlank(propName)) {
            return;
        }
        if (!this.element.getDefn().allowsUserProperties()) {
            throw new UserPropertyException(this.element, propName, "Error.UserPropertyException.USER_PROP_DISALLOWED");
        }
        UserPropertyDefn prop = this.element.getLocalUserPropertyDefn(propName);
        if (prop == null) {
            throw new UserPropertyException(this.element, propName, "Error.UserPropertyException.NOT_FOUND");
        }
        UserPropertyRecord propCmd = new UserPropertyRecord(this.element, prop, false);
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(propCmd.getLabel());
        if (this.element.getLocalProperty(this.module, propName) != null) {
            PropertyRecord valueCmd = new PropertyRecord(this.element, propName, null);
            stack.execute(valueCmd);
        }
        List<DesignElement> descendents = this.element.getDescendents();
        int i = 0;
        while (i < descendents.size()) {
            DesignElement child = descendents.get(i);
            if (child.getLocalProperty(this.module, propName) != null) {
                PropertyRecord valueCmd = new PropertyRecord(child, propName, null);
                stack.execute(valueCmd);
            }
            ++i;
        }
        stack.execute(propCmd);
        stack.commit();
    }

    public void setPropertyDefn(UserPropertyDefn oldPropDefn, UserPropertyDefn newPropDefn) throws UserPropertyException, PropertyValueException {
        assert (this.element != null);
        assert (oldPropDefn != null);
        if (newPropDefn == null) {
            this.dropUserProperty(oldPropDefn.getName());
            return;
        }
        String propName = oldPropDefn.getName();
        if (this.element.getLocalUserPropertyDefn(propName) == null) {
            throw new UserPropertyException(this.element, propName, "Error.UserPropertyException.NOT_FOUND");
        }
        this.checkUserPropertyDefn(newPropDefn);
        String name = newPropDefn.getName();
        int oldType = oldPropDefn.getType().getTypeCode();
        int newType = newPropDefn.getType().getTypeCode();
        ActivityStack stack = this.getActivityStack();
        String label = CommandLabelFactory.getCommandLabel("Message.ChangePropertyDefinition", new String[]{oldPropDefn.getDisplayName()});
        stack.startTrans(label);
        UserPropertyRecord propCmd = new UserPropertyRecord(this.element, newPropDefn, true);
        stack.execute(propCmd);
        List<DesignElement> descendents = this.element.getDescendents();
        descendents.add(this.element);
        int i = 0;
        while (i < descendents.size()) {
            PropertyRecord valueCmd;
            DesignElement child = descendents.get(i);
            Object value = child.getLocalProperty(this.module, propName);
            if (oldType != newType || oldType == 5 && newType == 5) {
                if (value != null) {
                    try {
                        value = this.validateValue(newPropDefn, value.toString());
                    }
                    catch (PropertyValueException ex) {
                        stack.rollback();
                        throw ex;
                    }
                    if (value != null) {
                        valueCmd = new PropertyRecord(child, name, value);
                        stack.execute(valueCmd);
                    }
                    if (!name.equals(propName)) {
                        valueCmd = new PropertyRecord(child, propName, null);
                        stack.execute(valueCmd);
                    }
                }
            } else if (!name.equals(propName) && value != null) {
                valueCmd = new PropertyRecord(child, name, value);
                stack.execute(valueCmd);
                valueCmd = new PropertyRecord(child, propName, null);
                stack.execute(valueCmd);
            }
            ++i;
        }
        if (!name.equals(propName)) {
            propCmd = new UserPropertyRecord(this.element, oldPropDefn, false);
            stack.execute(propCmd);
        }
        stack.commit();
    }

    private void checkUserPropertyDefn(UserPropertyDefn prop) throws UserPropertyException {
        Object defaultValue;
        IChoiceSet choices;
        String name = prop.getName();
        if (!this.element.getDefn().allowsUserProperties()) {
            throw new UserPropertyException(this.element, name, "Error.UserPropertyException.USER_PROP_DISALLOWED");
        }
        if (StringUtil.isBlank(name)) {
            throw new UserPropertyException(this.element, name, "Error.UserPropertyException.NAME_REQUIRED");
        }
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        List<IPropertyType> supportedTypes = UserPropertyDefn.getAllowedTypes();
        assert (supportedTypes != null);
        if (!supportedTypes.contains(dd.getPropertyType(prop.getTypeCode()))) {
            throw new UserPropertyException(this.element, name, "Error.UserPropertyException.INVALID_TYPE");
        }
        String msgID = prop.getDisplayNameID();
        String displayName = prop.getDisplayName();
        if (!StringUtil.isBlank(msgID) && StringUtil.isBlank(displayName = this.module.getMessage(msgID))) {
            throw new UserPropertyException(this.element, name, "Error.UserPropertyException.INVALID_DISPLAY_ID");
        }
        if (prop.getTypeCode() == 5 && ((choices = prop.getChoices()) == null || choices.getChoices().length == 0)) {
            throw new UserPropertyException(this.element, name, "Error.UserPropertyException.MISSING_CHOICES");
        }
        if (prop.hasChoices()) {
            IChoiceSet choiceSet = prop.getChoices();
            IChoice[] choices2 = choiceSet.getChoices();
            int i = 0;
            while (i < choices2.length) {
                UserChoice choice = (UserChoice)choices2[i];
                Object value = choice.getValue();
                if (StringUtil.isBlank(choice.getName())) {
                    throw new UserPropertyException(this.element, name, "Error.UserPropertyException.CHOICE_NAME_REQUIRED");
                }
                if (value == null) {
                    throw new UserPropertyException(this.element, name, "Error.UserPropertyException.CHOICE_VALUE_REQUIRED");
                }
                if (prop.getTypeCode() != 5) {
                    try {
                        value = prop.validateValue(this.module, value);
                    }
                    catch (PropertyValueException propertyValueException) {
                        throw new UserPropertyException(this.element, name, "Error.UserPropertyException.INVALID_CHOICE_VALUE");
                    }
                }
                ++i;
            }
        }
        if ((defaultValue = prop.getDefault()) != null) {
            try {
                prop.validateValue(this.getModule(), defaultValue);
            }
            catch (PropertyValueException e) {
                throw new UserPropertyException(this.element, name, "Error.UserPropertyException.INVALID_DEFAULT_VALUE", e, new String[]{defaultValue.toString(), prop.getType().getName()});
            }
        }
        try {
            prop.build();
        }
        catch (MetaDataException e) {
            throw new UserPropertyException(this.element, name, "Error.UserPropertyException.INVALID_DEFINITION", e);
        }
    }

    private Object validateValue(ElementPropertyDefn prop, String value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        try {
            return prop.validateValue(this.module, value);
        }
        catch (PropertyValueException ex) {
            ex.setElement(this.element);
            ex.setPropertyName(prop.getName());
            throw ex;
        }
    }
}

