/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.extension.IReportItemFactory;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.GroupNameValidator;
import org.eclipse.birt.report.model.core.CaseInsensitiveNameSpace;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.namespace.AbstractModuleNameContext;
import org.eclipse.birt.report.model.core.namespace.AbstractNameHelper;
import org.eclipse.birt.report.model.core.namespace.INameContext;
import org.eclipse.birt.report.model.core.namespace.INameHelper;
import org.eclipse.birt.report.model.core.namespace.NameContextFactory;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.olap.Level;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.NamePropertyType;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleNameHelper
extends AbstractNameHelper {
    protected Module module = null;
    private List<String>[] cachedContentNames = new ArrayList[10];
    private Map<String, DesignElement> cachedLevelNames = new HashMap<String, DesignElement>();

    public ModuleNameHelper(Module module) {
        this.module = module;
        this.initialize();
    }

    @Override
    protected void initialize() {
        int count = this.getNameSpaceCount();
        this.nameContexts = new INameContext[count];
        int i = 0;
        while (i < count) {
            this.nameContexts[i] = NameContextFactory.createModuleNameContext(this.module, i);
            this.cachedContentNames[i] = new ArrayList<String>();
            ++i;
        }
    }

    @Override
    protected void initCachedNameSpaces() {
        this.cachedNameSpaces = new NameSpace[this.getNameSpaceCount()];
        int i = 0;
        while (i < this.getNameSpaceCount()) {
            this.cachedNameSpaces[i] = i == 0 || i == 2 ? new CaseInsensitiveNameSpace() : new NameSpace();
            ++i;
        }
    }

    @Override
    public int getNameSpaceCount() {
        return 10;
    }

    @Override
    public String getUniqueName(DesignElement element, String namePrefix) {
        if (element == null) {
            return null;
        }
        if (element instanceof GroupElement) {
            String groupName = this.getUniqueGroupName((GroupElement)element);
            return groupName;
        }
        ElementDefn eDefn = (ElementDefn)element.getDefn();
        if (!this.module.getDefn().isKindOf(eDefn.getNameConfig().getNameContainer())) {
            INameHelper nameHelper = new NameExecutor(element).getNameHelper(this.module);
            return nameHelper == null ? null : nameHelper.getUniqueName(element, namePrefix);
        }
        String name = element.getName();
        if (StringUtil.isBlank(name)) {
            name = namePrefix;
        }
        name = StringUtil.trimString(name);
        name = NamePropertyType.validateName(name);
        if (eDefn.getNameOption() == 0) {
            return null;
        }
        if (eDefn.getNameOption() == 1 && name == null && this.module instanceof ReportDesign) {
            return null;
        }
        if (this.module instanceof Library && element instanceof StyleElement && element.getContainer() == null && name != null) {
            return name;
        }
        int nameSpaceID = eDefn.getNameSpaceID();
        NameSpace nameSpace = this.getCachedNameSpace(nameSpaceID);
        List<String> cachedContentNames = this.getCachedContentNames(nameSpaceID);
        NameSpace moduleNameSpace = this.nameContexts[nameSpaceID].getNameSpace();
        String validName = name;
        if (element instanceof StyleElement) {
            String string = validName = validName == null ? null : validName.toLowerCase();
        }
        if (validName != null && ModuleNameHelper.isValidInNameSpace(nameSpace, element, validName) && ModuleNameHelper.isValidInNameSpace(moduleNameSpace, element, validName) && !cachedContentNames.contains(validName)) {
            return name;
        }
        if (name == null) {
            if (element instanceof ExtendedItem) {
                ExtensionElementDefn extDefn = ((ExtendedItem)element).getExtDefn();
                PeerExtensionElementDefn peerDefn = (PeerExtensionElementDefn)extDefn;
                IReportItemFactory peerFactory = peerDefn.getReportItemFactory();
                assert (peerFactory != null);
                String extensionDefaultName = null;
                IMessages msgs = peerFactory.getMessages();
                if (msgs != null) {
                    extensionDefaultName = msgs.getMessage((String)extDefn.getDisplayNameKey(), this.module.getLocale());
                }
                if (StringUtil.isBlank(extensionDefaultName)) {
                    extensionDefaultName = peerDefn.getName();
                }
                name = ModelMessages.getMessage("Message.NamePrefixNew");
                name = String.valueOf(name) + extensionDefaultName;
            } else {
                name = ModelMessages.getMessage("New." + element.getDefn().getName());
                name = name.trim();
            }
        }
        int index = 0;
        String baseName = name;
        validName = name;
        if (element instanceof StyleElement) {
            validName = validName == null ? null : validName.toLowerCase();
        }
        while (nameSpace.contains(validName) || moduleNameSpace.contains(validName) || cachedContentNames.contains(validName)) {
            validName = name = String.valueOf(baseName) + ++index;
            if (!(element instanceof StyleElement)) continue;
            String string = validName = validName == null ? null : validName.toLowerCase();
        }
        return name;
    }

    @Override
    public void makeUniqueName(DesignElement element) {
        if (element instanceof GroupElement) {
            String name = this.getUniqueName(element);
            if (name != null) {
                this.setUniqueGroupName((GroupElement)element, name);
            }
            return;
        }
        super.makeUniqueName(element);
    }

    List<String> getCachedContentNames(int id) {
        assert (id >= 0 && id < 10);
        return this.cachedContentNames[id];
    }

    private String getUniqueGroupName(GroupElement group) {
        if (group == null || group.getContainer() == null) {
            return null;
        }
        ListingHandle listing = (ListingHandle)group.getContainer().getHandle(this.module);
        String groupName = (String)group.getLocalProperty(this.module, "groupName");
        if (StringUtil.isBlank(groupName = NamePropertyType.validateName(groupName))) {
            GroupElement virtualGroup = (GroupElement)group.getVirtualParent();
            while (virtualGroup != null) {
                groupName = (String)virtualGroup.getLocalProperty(virtualGroup.getRoot(), "groupName");
                if (!StringUtil.isBlank(groupName)) break;
                virtualGroup = (GroupElement)virtualGroup.getVirtualParent();
            }
        }
        String namePrefix = groupName;
        int level = group.getGroupLevel();
        if (StringUtil.isBlank(namePrefix)) {
            namePrefix = ModelMessages.getMessage("New." + group.getDefn().getName());
            namePrefix = namePrefix.trim();
            groupName = String.valueOf(namePrefix) + level;
        }
        while (GroupNameValidator.getInstance().validateForRenamingGroup(listing, (GroupHandle)group.getHandle(this.module), groupName).size() != 0) {
            groupName = String.valueOf(namePrefix) + level;
            ++level;
        }
        return groupName;
    }

    private void setUniqueGroupName(GroupElement group, String groupName) {
        assert (groupName != null);
        String localGroupName = (String)group.getLocalProperty(this.module, "groupName");
        if (groupName.equals(localGroupName)) {
            return;
        }
        group.setProperty("groupName", (Object)groupName);
    }

    @Override
    public void addContentName(int id, String name) {
        if (id >= 0 && id < 10 && !this.cachedContentNames[id].contains(name)) {
            this.cachedContentNames[id].add(name);
        }
    }

    @Override
    public DesignElement getElement() {
        return this.module;
    }

    public boolean addCachedLevel(DesignElement level) {
        if (!(level instanceof Level)) {
            return true;
        }
        String name = level.getName();
        if (name == null) {
            return true;
        }
        if (this.cachedLevelNames.get(name) != null && this.cachedLevelNames.get(name) != level) {
            return false;
        }
        this.cachedLevelNames.put(level.getName(), level);
        return true;
    }

    public Level findCachedLevel(String elementName) {
        if (elementName == null) {
            return null;
        }
        String namespace = StringUtil.extractNamespace(elementName);
        String name = StringUtil.extractName(elementName);
        if (namespace == null) {
            return (Level)this.cachedLevelNames.get(name);
        }
        Library lib = this.module.getLibraryWithNamespace(namespace);
        return lib == null ? null : ((ModuleNameHelper)lib.getNameHelper()).findCachedLevel(name);
    }

    public void clearCachedLevels() {
        this.cachedLevelNames = null;
        List<Library> libs = this.module.getAllLibraries();
        if (libs == null) {
            return;
        }
        int i = 0;
        while (i < libs.size()) {
            Library lib = libs.get(i);
            ((ModuleNameHelper)lib.getNameHelper()).cachedLevelNames = null;
            ++i;
        }
    }

    @Override
    public void cacheValues() {
        AbstractModuleNameContext tmpContext = (AbstractModuleNameContext)this.getNameContext(0);
        tmpContext.cacheValues();
    }
}

