/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.CssException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.command.CssCommand;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetAdapter;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Theme;

public class CssStyleSheetHandleAdapter {
    private final Module module;
    private final DesignElement element;

    public CssStyleSheetHandleAdapter(Module module, DesignElement element) {
        this.module = module;
        this.element = element;
    }

    public final void addCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        if (sheetHandle == null) {
            return;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        command.addCss(sheetHandle.getStyleSheet());
    }

    public final void addCss(String fileName) throws SemanticException {
        if (fileName == null) {
            return;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        command.addCss(fileName);
    }

    public final void dropCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        if (sheetHandle == null) {
            return;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        command.dropCss(sheetHandle.getStyleSheet());
    }

    public final boolean canDropCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        if (!this.element.canEdit(this.module)) {
            return false;
        }
        if (sheetHandle == null) {
            return false;
        }
        String fileName = sheetHandle.getFileName();
        int position = CssStyleSheetAdapter.getPositionOfCssStyleSheet(this.module, ((ICssStyleSheetOperation)((Object)this.element)).getCsses(), fileName);
        return position != -1;
    }

    public final boolean canAddCssStyleSheet(String fileName) {
        if (!this.element.canEdit(this.module)) {
            return false;
        }
        if (fileName == null) {
            return false;
        }
        URL url = this.module.findResource(fileName, 3);
        if (url == null) {
            return false;
        }
        CssStyleSheet sheet = CssStyleSheetAdapter.getCssStyleSheetByLocation(this.module, ((ICssStyleSheetOperation)((Object)this.element)).getCsses(), url);
        return sheet == null;
    }

    public final boolean canAddCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        if (!this.element.canEdit(this.module)) {
            return false;
        }
        if (sheetHandle == null) {
            return false;
        }
        String fileName = sheetHandle.getFileName();
        return this.canAddCssStyleSheet(fileName);
    }

    public final void reloadCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        if (sheetHandle == null) {
            return;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        command.reloadCss(sheetHandle.getStyleSheet());
    }

    public final void addCss(IncludedCssStyleSheet cssStruct) throws SemanticException {
        if (cssStruct == null) {
            return;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        command.addCss(cssStruct);
    }

    public IncludedCssStyleSheetHandle findIncludedCssStyleSheetHandleByFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        String propName = null;
        if (this.element instanceof ReportDesign) {
            propName = "cssStyleSheets";
        } else if (this.element instanceof Theme) {
            propName = "cssStyleSheets";
        }
        PropertyHandle propHandle = this.element.getHandle(this.module).getPropertyHandle(propName);
        Iterator handleIter = propHandle.iterator();
        while (handleIter.hasNext()) {
            IncludedCssStyleSheetHandle handle = (IncludedCssStyleSheetHandle)handleIter.next();
            if (!fileName.equals(handle.getFileName())) continue;
            return handle;
        }
        return null;
    }

    public CssStyleSheetHandle findCssStyleSheetHandleByFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        List<CssStyleSheet> list = ((ICssStyleSheetOperation)((Object)this.element)).getCsses();
        int i = 0;
        while (i < list.size()) {
            CssStyleSheet css = list.get(i);
            if (fileName.equals(css.getFileName())) {
                return css.handle(this.module);
            }
            ++i;
        }
        return null;
    }

    public void renameCss(IncludedCssStyleSheetHandle handle, String newFileName) throws SemanticException {
        if (newFileName == null || handle == null) {
            return;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        IncludedCssStyleSheet includedCssStyleSheet = command.getIncludedCssStyleSheetByLocation(handle.getFileName());
        command.renameCss(includedCssStyleSheet, newFileName);
    }

    public boolean canRenameCss(IncludedCssStyleSheetHandle sheetHandle, String newFileName) {
        if (newFileName == null || sheetHandle == null) {
            return false;
        }
        if (sheetHandle.getFileName().equals(newFileName)) {
            return false;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        IncludedCssStyleSheet includedCssStyleSheet = command.getIncludedCssStyleSheetByLocation(sheetHandle.getFileName());
        IncludedCssStyleSheet foundIncludedCssStyleSheet = null;
        try {
            foundIncludedCssStyleSheet = command.checkRenameCss(includedCssStyleSheet, newFileName);
        }
        catch (CssException cssException) {
            return false;
        }
        return foundIncludedCssStyleSheet != sheetHandle.getStructure();
    }
}

