/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.EncryptedPropertyState;
import org.eclipse.birt.report.model.parser.ExpressionState;
import org.eclipse.birt.report.model.parser.ListPropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.PropertyState;
import org.eclipse.birt.report.model.parser.SimplePropertyListState;
import org.eclipse.birt.report.model.parser.StructureState;
import org.eclipse.birt.report.model.parser.TextPropertyState;
import org.eclipse.birt.report.model.parser.XmlPropertyState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;

public abstract class DesignParseState
extends AbstractParseState {
    protected ModuleParserHandler handler = null;

    public DesignParseState(ModuleParserHandler theHandler) {
        this.handler = theHandler;
    }

    public XMLParserHandler getHandler() {
        return this.handler;
    }

    public abstract DesignElement getElement();

    protected void setProperty(String propName, String value) {
        DesignElement element = this.getElement();
        ElementPropertyDefn prop = element.getPropertyDefn(propName);
        assert (prop != null);
        Object propValue = null;
        try {
            propValue = prop.validateXml(this.handler.getModule(), value);
        }
        catch (PropertyValueException ex) {
            ex.setElement(element);
            ex.setPropertyName(propName);
            this.handler.getErrorHandler().semanticError((Exception)((Object)ex));
            return;
        }
        element.setProperty(propName, propValue);
    }

    public AbstractParseState startElement(String tagName) {
        int tagValue = tagName.toLowerCase().hashCode();
        if (ParserSchemaConstants.PROPERTY_TAG == tagValue) {
            return new PropertyState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.LIST_PROPERTY_TAG == tagValue) {
            return new ListPropertyState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.EXPRESSION_TAG == tagValue) {
            return new ExpressionState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.XML_PROPERTY_TAG == tagValue) {
            return new XmlPropertyState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.STRUCTURE_TAG == tagValue) {
            return new StructureState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.METHOD_TAG == tagValue) {
            return new PropertyState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.TEXT_PROPERTY_TAG == tagValue) {
            return new TextPropertyState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.HTML_PROPERTY_TAG == tagValue) {
            return new TextPropertyState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.ENCRYPTED_PROPERTY_TAG == tagValue) {
            return new EncryptedPropertyState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.SIMPLE_PROPERTY_LIST_TAG == tagValue) {
            return new SimplePropertyListState(this.handler, this.getElement());
        }
        return super.startElement(tagName);
    }

    protected void initElementID(Attributes attrs, DesignElement element) {
        try {
            String theID = attrs.getValue("id");
            if (!StringUtil.isBlank(theID)) {
                long id = Long.parseLong(theID);
                if (id <= 0L) {
                    this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{element.getIdentifier(), attrs.getValue("id")}, "Error.DesignParserException.INVALID_ELEMENT_ID")));
                }
                element.setID(id);
            } else {
                this.handler.unhandleIDElements.add(element);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{element.getIdentifier(), attrs.getValue("id")}, "Error.DesignParserException.INVALID_ELEMENT_ID")));
        }
    }

    protected boolean addElementID(Module module, DesignElement content) {
        long elementID = content.getID();
        if (elementID > 0L) {
            DesignElement element = module.getElementByID(elementID);
            assert (element != content);
            if (element == null) {
                module.addElementID(content);
            } else {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{content.getIdentifier(), element.getIdentifier()}, "Error.DesignParserException.DUPLICATE_ELEMENT_ID")));
                return false;
            }
        }
        return true;
    }
}

